/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.kotlin.random;

import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.SinceKotlin;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;
import shade.ru.endlesscode.rpginventory.kotlin.random.Random;
import shade.ru.endlesscode.rpginventory.kotlin.random.XorWowRandom;
import shade.ru.endlesscode.rpginventory.kotlin.ranges.IntRange;
import shade.ru.endlesscode.rpginventory.kotlin.ranges.LongRange;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\fH\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0014\u0010\u0010\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0011H\u0007\u001a\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u00a8\u0006\u0014"}, d2={"Random", "Lshade/ru/endlesscode/rpginventory/kotlin/random/Random;", "seed", "", "", "boundsErrorMessage", "", "from", "", "until", "checkRangeBounds", "", "", "nextInt", "range", "Lshade/ru/endlesscode/rpginventory/kotlin/ranges/IntRange;", "nextLong", "Lshade/ru/endlesscode/rpginventory/kotlin/ranges/LongRange;", "takeUpperBits", "bitCount", "shade.ru.endlesscode.rpginventory.kotlin-stdlib"})
public final class RandomKt {
    @SinceKotlin(version="1.3")
    @NotNull
    public static final Random Random(int n) {
        return new XorWowRandom(n, n >> 31);
    }

    @SinceKotlin(version="1.3")
    @NotNull
    public static final Random Random(long l) {
        return new XorWowRandom((int)l, (int)(l >> 32));
    }

    @SinceKotlin(version="1.3")
    public static final int nextInt(@NotNull Random random, @NotNull IntRange intRange) {
        Intrinsics.checkParameterIsNotNull(random, "receiver$0");
        Intrinsics.checkParameterIsNotNull(intRange, "range");
        if (intRange.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Cannot get random in empty range: " + intRange);
        }
        return intRange.getLast() < Integer.MAX_VALUE ? random.nextInt(intRange.getFirst(), intRange.getLast() + 1) : (intRange.getFirst() > Integer.MIN_VALUE ? random.nextInt(intRange.getFirst() - 1, intRange.getLast()) + 1 : random.nextInt());
    }

    @SinceKotlin(version="1.3")
    public static final long nextLong(@NotNull Random random, @NotNull LongRange longRange) {
        Intrinsics.checkParameterIsNotNull(random, "receiver$0");
        Intrinsics.checkParameterIsNotNull(longRange, "range");
        if (longRange.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Cannot get random in empty range: " + longRange);
        }
        return longRange.getLast() < Long.MAX_VALUE ? random.nextLong(longRange.getStart(), longRange.getEndInclusive() + 1L) : (longRange.getStart() > Long.MIN_VALUE ? random.nextLong(longRange.getStart() - 1L, longRange.getEndInclusive()) + 1L : random.nextLong());
    }

    public static final int takeUpperBits(int n, int n2) {
        return n >>> 32 - n2 & -n2 >> 31;
    }

    public static final void checkRangeBounds(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n2 > n;
        if (!bl) {
            String string = RandomKt.boundsErrorMessage(n, n2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static final void checkRangeBounds(long l, long l2) {
        boolean bl;
        boolean bl2 = bl = l2 > l;
        if (!bl) {
            String string = RandomKt.boundsErrorMessage(l, l2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static final void checkRangeBounds(double d, double d2) {
        boolean bl;
        boolean bl2 = bl = d2 > d;
        if (!bl) {
            String string = RandomKt.boundsErrorMessage(d, d2);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final String boundsErrorMessage(@NotNull Object object, @NotNull Object object2) {
        Intrinsics.checkParameterIsNotNull(object, "from");
        Intrinsics.checkParameterIsNotNull(object2, "until");
        return "Random range is empty: [" + object + ", " + object2 + ").";
    }
}

