/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.kotlin.random;

import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.kotlin.Deprecated;
import shade.ru.endlesscode.rpginventory.kotlin.DeprecationLevel;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.SinceKotlin;
import shade.ru.endlesscode.rpginventory.kotlin.internal.PlatformImplementationsKt;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.JvmField;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.DefaultConstructorMarker;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.DoubleCompanionObject;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;
import shade.ru.endlesscode.rpginventory.kotlin.random.PlatformRandomKt;
import shade.ru.endlesscode.rpginventory.kotlin.random.RandomKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b'\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016\u00a8\u0006\u0019"}, d2={"Lshade/ru/endlesscode/rpginventory/kotlin/random/Random;", "", "()V", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "Companion", "Default", "shade.ru.endlesscode.rpginventory.kotlin-stdlib"})
@SinceKotlin(version="1.3")
public abstract class Random {
    private static final Random defaultRandom;
    @JvmField
    @NotNull
    public static final Companion Companion;
    public static final Default Default;

    public abstract int nextBits(int var1);

    public int nextInt() {
        return this.nextBits(32);
    }

    public int nextInt(int n) {
        return this.nextInt(0, n);
    }

    public int nextInt(int n, int n2) {
        int n3;
        int n4;
        RandomKt.checkRangeBounds(n, n2);
        int n5 = n2 - n;
        if (n5 > 0 || n5 == Integer.MIN_VALUE) {
            int n6;
            int n7;
            if ((n5 & -n5) == n5) {
                n7 = PlatformRandomKt.fastLog2(n5);
                n6 = this.nextBits(n7);
            } else {
                int n8;
                while ((n8 = this.nextInt() >>> 1) - (n7 = n8 % n5) + (n5 - 1) < 0) {
                }
                n6 = n7;
            }
            int n9 = n6;
            return n + n9;
        }
        while (n > (n4 = (n3 = this.nextInt())) || n2 <= n4) {
        }
        return n3;
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    public long nextLong(long l) {
        return this.nextLong(0L, l);
    }

    public long nextLong(long l, long l2) {
        long l3;
        long l4;
        RandomKt.checkRangeBounds(l, l2);
        long l5 = l2 - l;
        if (l5 > 0L) {
            long l6;
            if ((l5 & -l5) == l5) {
                long l7;
                int n;
                int n2 = (int)l5;
                int n3 = (int)(l5 >>> 32);
                if (n2 != 0) {
                    n = PlatformRandomKt.fastLog2(n2);
                    l7 = (long)this.nextBits(n) & 0xFFFFFFFFL;
                } else if (n3 == 1) {
                    l7 = (long)this.nextInt() & 0xFFFFFFFFL;
                } else {
                    n = PlatformRandomKt.fastLog2(n3);
                    l7 = ((long)this.nextBits(n) << 32) + (long)this.nextInt();
                }
                l6 = l7;
            } else {
                long l8;
                long l9;
                while ((l9 = this.nextLong() >>> 1) - (l8 = l9 % l5) + (l5 - 1L) < 0L) {
                }
                l6 = l8;
            }
            return l + l6;
        }
        while (l > (l4 = (l3 = this.nextLong())) || l2 <= l4) {
        }
        return l3;
    }

    public boolean nextBoolean() {
        return this.nextBits(1) != 0;
    }

    public double nextDouble() {
        return PlatformRandomKt.doubleFromParts(this.nextBits(26), this.nextBits(27));
    }

    public double nextDouble(double d) {
        return this.nextDouble(0.0, d);
    }

    public double nextDouble(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        RandomKt.checkRangeBounds(d, d2);
        double d8 = d7 = d2 - d;
        if (Double.isInfinite(d8) && !Double.isInfinite(d6 = (d8 = d)) && !Double.isNaN(d6 = d8) && !Double.isInfinite(d6 = (d8 = d2)) && !Double.isNaN(d6 = d8)) {
            d8 = this.nextDouble() * (d2 / (double)2 - d / (double)2);
            d5 = d + d8 + d8;
        } else {
            d5 = d4 = d + this.nextDouble() * d7;
        }
        if (d4 >= d2) {
            d8 = d2;
            d3 = Math.nextAfter(d8, DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY());
        } else {
            d3 = d4;
        }
        return d3;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / (float)0x1000000;
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        Intrinsics.checkParameterIsNotNull(byArray, "array");
        int n5 = n;
        int n6 = n5 = 0 <= n5 && byArray.length >= n5 && 0 <= (n5 = n2) && byArray.length >= n5 ? 1 : 0;
        if (n5 == 0) {
            String string = "fromIndex (" + n + ") or toIndex (" + n2 + ") are out of range: 0.." + byArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n7 = n5 = n <= n2 ? 1 : 0;
        if (n5 == 0) {
            String string = "fromIndex (" + n + ") must be not greater than toIndex (" + n2 + ").";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n5 = (n2 - n) / 4;
        int n8 = n;
        int n9 = 0;
        int n10 = n5;
        while (n9 < n10) {
            n4 = n9++;
            n3 = this.nextInt();
            byArray[n8] = (byte)n3;
            byArray[n8 + 1] = (byte)(n3 >>> 8);
            byArray[n8 + 2] = (byte)(n3 >>> 16);
            byArray[n8 + 3] = (byte)(n3 >>> 24);
            n8 += 4;
        }
        n9 = n2 - n8;
        n10 = this.nextBits(n9 * 8);
        n3 = n9;
        for (n4 = 0; n4 < n3; ++n4) {
            byArray[n8 + n4] = (byte)(n10 >>> n4 * 8);
        }
        return byArray;
    }

    @NotNull
    public static /* synthetic */ byte[] nextBytes$default(Random random, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBytes");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return random.nextBytes(byArray, n, n2);
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull(byArray, "array");
        return this.nextBytes(byArray, 0, byArray.length);
    }

    @NotNull
    public byte[] nextBytes(int n) {
        return this.nextBytes(new byte[n]);
    }

    static {
        Default = new Default(null);
        defaultRandom = PlatformImplementationsKt.IMPLEMENTATIONS.defaultPlatformRandom();
        Companion = shade.ru.endlesscode.rpginventory.kotlin.random.Random$Companion.INSTANCE;
    }

    @Deprecated(message="Use Default companion object instead", level=DeprecationLevel.HIDDEN)
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lshade/ru/endlesscode/rpginventory/kotlin/random/Random$Companion;", "Lshade/ru/endlesscode/rpginventory/kotlin/random/Random;", "()V", "nextBits", "", "bitCount", "shade.ru.endlesscode.rpginventory.kotlin-stdlib"})
    public static final class Companion
    extends Random {
        public static final Companion INSTANCE;

        @Override
        public int nextBits(int n) {
            return Default.nextBits(n);
        }

        private Companion() {
        }

        static {
            Companion companion;
            INSTANCE = companion = new Companion();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001aH\u0016R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lshade/ru/endlesscode/rpginventory/kotlin/random/Random$Default;", "Lshade/ru/endlesscode/rpginventory/kotlin/random/Random;", "()V", "Companion", "Lshade/ru/endlesscode/rpginventory/kotlin/random/Random$Companion;", "Companion$annotations", "defaultRandom", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "shade.ru.endlesscode.rpginventory.kotlin-stdlib"})
    public static final class Default
    extends Random {
        @Override
        public int nextBits(int n) {
            return defaultRandom.nextBits(n);
        }

        @Override
        public int nextInt() {
            return defaultRandom.nextInt();
        }

        @Override
        public int nextInt(int n) {
            return defaultRandom.nextInt(n);
        }

        @Override
        public int nextInt(int n, int n2) {
            return defaultRandom.nextInt(n, n2);
        }

        @Override
        public long nextLong() {
            return defaultRandom.nextLong();
        }

        @Override
        public long nextLong(long l) {
            return defaultRandom.nextLong(l);
        }

        @Override
        public long nextLong(long l, long l2) {
            return defaultRandom.nextLong(l, l2);
        }

        @Override
        public boolean nextBoolean() {
            return defaultRandom.nextBoolean();
        }

        @Override
        public double nextDouble() {
            return defaultRandom.nextDouble();
        }

        @Override
        public double nextDouble(double d) {
            return defaultRandom.nextDouble(d);
        }

        @Override
        public double nextDouble(double d, double d2) {
            return defaultRandom.nextDouble(d, d2);
        }

        @Override
        public float nextFloat() {
            return defaultRandom.nextFloat();
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] byArray) {
            Intrinsics.checkParameterIsNotNull(byArray, "array");
            return defaultRandom.nextBytes(byArray);
        }

        @Override
        @NotNull
        public byte[] nextBytes(int n) {
            return defaultRandom.nextBytes(n);
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] byArray, int n, int n2) {
            Intrinsics.checkParameterIsNotNull(byArray, "array");
            return defaultRandom.nextBytes(byArray, n, n2);
        }

        @Deprecated(message="Use Default companion object instead", level=DeprecationLevel.HIDDEN)
        public static /* synthetic */ void Companion$annotations() {
        }

        private Default() {
        }

        public /* synthetic */ Default(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

