/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.Unit;
import shade.ru.endlesscode.rpginventory.kotlin.collections.CollectionsKt;
import shade.ru.endlesscode.rpginventory.kotlin.io.ByteStreamsKt;
import shade.ru.endlesscode.rpginventory.kotlin.io.CloseableKt;
import shade.ru.endlesscode.rpginventory.kotlin.io.FileAlreadyExistsException;
import shade.ru.endlesscode.rpginventory.kotlin.io.FilePathComponents;
import shade.ru.endlesscode.rpginventory.kotlin.io.FileSystemException;
import shade.ru.endlesscode.rpginventory.kotlin.io.FilesKt;
import shade.ru.endlesscode.rpginventory.kotlin.io.FilesKt__FileTreeWalkKt;
import shade.ru.endlesscode.rpginventory.kotlin.io.FilesKt__UtilsKt;
import shade.ru.endlesscode.rpginventory.kotlin.io.NoSuchFileException;
import shade.ru.endlesscode.rpginventory.kotlin.io.OnErrorAction;
import shade.ru.endlesscode.rpginventory.kotlin.io.TerminateException;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.functions.Function2;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;
import shade.ru.endlesscode.rpginventory.kotlin.sequences.Sequence;
import shade.ru.endlesscode.rpginventory.kotlin.text.StringsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=5, xi=1, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u001a(\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002\u001a(\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002\u001a8\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\u001a\b\u0002\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u001a&\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u000f*\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0002*\u00020\u0002\u001a\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d*\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0011\u0010\u001c\u001a\u00020\u001f*\u00020\u001fH\u0002\u00a2\u0006\u0002\b\u001e\u001a\u0012\u0010 \u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010#\u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0012\u0010'\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002\u001a\u001b\u0010)\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\b*\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006+"}, d2={"extension", "", "Ljava/io/File;", "getExtension", "(Ljava/io/File;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath", "nameWithoutExtension", "getNameWithoutExtension", "createTempDir", "prefix", "suffix", "directory", "createTempFile", "copyRecursively", "", "target", "overwrite", "onError", "Lshade/ru/endlesscode/rpginventory/kotlin/Function2;", "Ljava/io/IOException;", "Lshade/ru/endlesscode/rpginventory/kotlin/io/OnErrorAction;", "copyTo", "bufferSize", "", "deleteRecursively", "endsWith", "other", "normalize", "", "normalize$FilesKt__UtilsKt", "Lshade/ru/endlesscode/rpginventory/kotlin/io/FilePathComponents;", "relativeTo", "base", "relativeToOrNull", "relativeToOrSelf", "resolve", "relative", "resolveSibling", "startsWith", "toRelativeString", "toRelativeStringOrNull", "toRelativeStringOrNull$FilesKt__UtilsKt", "shade.ru.endlesscode.rpginventory.kotlin-stdlib"}, xs="shade/ru/endlesscode/rpginventory/kotlin/io/FilesKt")
class FilesKt__UtilsKt
extends FilesKt__FileTreeWalkKt {
    @NotNull
    public static final File createTempDir(@NotNull String string, @Nullable String string2, @Nullable File file) {
        Intrinsics.checkParameterIsNotNull(string, "prefix");
        File file2 = File.createTempFile(string, string2, file);
        file2.delete();
        if (file2.mkdir()) {
            File file3 = file2;
            Intrinsics.checkExpressionValueIsNotNull(file3, "dir");
            return file3;
        }
        throw (Throwable)new IOException("Unable to create temporary directory " + file2 + '.');
    }

    @NotNull
    public static /* synthetic */ File createTempDir$default(String string, String string2, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string, string2, file);
    }

    @NotNull
    public static final File createTempFile(@NotNull String string, @Nullable String string2, @Nullable File file) {
        Intrinsics.checkParameterIsNotNull(string, "prefix");
        File file2 = File.createTempFile(string, string2, file);
        Intrinsics.checkExpressionValueIsNotNull(file2, "File.createTempFile(prefix, suffix, directory)");
        return file2;
    }

    @NotNull
    public static /* synthetic */ File createTempFile$default(String string, String string2, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string, string2, file);
    }

    @NotNull
    public static final String getExtension(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "name");
        return StringsKt.substringAfterLast(string, '.', "");
    }

    @NotNull
    public static final String getInvariantSeparatorsPath(@NotNull File file) {
        String string;
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        if (File.separatorChar != '/') {
            String string2 = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull(string2, "path");
            string = StringsKt.replace$default(string2, File.separatorChar, '/', false, 4, null);
        } else {
            String string3 = file.getPath();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "path");
        }
        return string;
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "name");
        return StringsKt.substringBeforeLast$default(string, ".", null, 2, null);
    }

    @NotNull
    public static final String toRelativeString(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt(file, file2);
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("this and base files have different roots: " + file + " and " + file2 + '.');
        }
        return string;
    }

    @NotNull
    public static final File relativeTo(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "base");
        return new File(FilesKt.toRelativeString(file, file2));
    }

    @NotNull
    public static final File relativeToOrSelf(@NotNull File file, @NotNull File file2) {
        File file3;
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt(file, file2);
        if (string != null) {
            String string2;
            String string3 = string2 = string;
            file3 = new File(string3);
        } else {
            file3 = file;
        }
        return file3;
    }

    @Nullable
    public static final File relativeToOrNull(@NotNull File file, @NotNull File file2) {
        File file3;
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull$FilesKt__UtilsKt(file, file2);
        if (string != null) {
            String string2;
            String string3 = string2 = string;
            file3 = new File(string3);
        } else {
            file3 = null;
        }
        return file3;
    }

    private static final String toRelativeStringOrNull$FilesKt__UtilsKt(@NotNull File file, File file2) {
        int n;
        FilePathComponents filePathComponents = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents(file));
        FilePathComponents filePathComponents2 = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(FilesKt.toComponents(file2));
        if (Intrinsics.areEqual(filePathComponents.getRoot(), filePathComponents2.getRoot()) ^ true) {
            return null;
        }
        int n2 = filePathComponents2.getSize();
        int n3 = filePathComponents.getSize();
        Comparable<File> comparable = file;
        File file3 = comparable;
        int n4 = n3;
        int n5 = n2;
        int n6 = Math.min(n4, n5);
        for (n = 0; n < n6 && Intrinsics.areEqual(filePathComponents.getSegments().get(n), filePathComponents2.getSegments().get(n)); ++n) {
        }
        int n7 = n;
        comparable = new StringBuilder();
        int n8 = n2 - 1;
        n = n7;
        if (n8 >= n) {
            while (true) {
                if (Intrinsics.areEqual(filePathComponents2.getSegments().get(n8).getName(), "..")) {
                    return null;
                }
                ((StringBuilder)comparable).append("..");
                if (n8 != n7) {
                    ((StringBuilder)comparable).append(File.separatorChar);
                }
                if (n8 == n) break;
                --n8;
            }
        }
        if (n7 < n3) {
            if (n7 < n2) {
                ((StringBuilder)comparable).append(File.separatorChar);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)filePathComponents.getSegments(), n7);
            Appendable appendable = (Appendable)((Object)comparable);
            String string = File.separator;
            Intrinsics.checkExpressionValueIsNotNull(string, "File.separator");
            CollectionsKt.joinTo$default(iterable, appendable, string, null, null, 0, null, null, 124, null);
        }
        return ((StringBuilder)comparable).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File copyTo(@NotNull File file, @NotNull File file2, boolean bl, int n) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "target");
        if (!file.exists()) {
            throw (Throwable)new NoSuchFileException(file, null, "The source file doesn't exist.", 2, null);
        }
        if (file2.exists()) {
            boolean bl2;
            boolean bl3 = !bl ? true : (bl2 = !file2.delete());
            if (bl2) {
                throw (Throwable)new FileAlreadyExistsException(file, file2, "The destination file already exists.");
            }
        }
        if (file.isDirectory()) {
            if (!file2.mkdirs()) {
                throw (Throwable)new FileSystemException(file, file2, "Failed to create target directory.");
            }
        } else {
            File file3 = file2.getParentFile();
            if (file3 != null) {
                file3.mkdirs();
            }
            Object object = file;
            object = new FileInputStream((File)object);
            Throwable throwable = null;
            try {
                long l;
                FileInputStream fileInputStream = (FileInputStream)object;
                Object object2 = file2;
                object2 = new FileOutputStream((File)object2);
                Throwable throwable2 = null;
                try {
                    FileOutputStream fileOutputStream = (FileOutputStream)object2;
                    l = ByteStreamsKt.copyTo(fileInputStream, fileOutputStream, n);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        return file2;
    }

    @NotNull
    public static /* synthetic */ File copyTo$default(File file, File file2, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return FilesKt.copyTo(file, file2, bl, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean copyRecursively(@NotNull File file, @NotNull File file2, boolean bl, @NotNull Function2<? super File, ? super IOException, ? extends OnErrorAction> function2) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "target");
        Intrinsics.checkParameterIsNotNull(function2, "onError");
        if (!file.exists()) {
            if (function2.invoke(file, new NoSuchFileException(file, null, "The source file doesn't exist.", 2, null)) == OnErrorAction.TERMINATE) return false;
            return true;
        }
        try {
            Iterator<File> iterator2 = FilesKt.walkTopDown(file).onFail((Function2<? super File, ? super IOException, Unit>)new Function2<File, IOException, Unit>(function2){
                final /* synthetic */ Function2 $onError;

                public final void invoke(@NotNull File file, @NotNull IOException iOException) {
                    Intrinsics.checkParameterIsNotNull(file, "f");
                    Intrinsics.checkParameterIsNotNull(iOException, "e");
                    if ((OnErrorAction)((Object)this.$onError.invoke(file, iOException)) == OnErrorAction.TERMINATE) {
                        throw (Throwable)new TerminateException(file);
                    }
                }
                {
                    this.$onError = function2;
                    super(2);
                }
            }).iterator();
            while (iterator2.hasNext()) {
                File file3 = iterator2.next();
                if (!file3.exists()) {
                    if (function2.invoke(file3, new NoSuchFileException(file3, null, "The source file doesn't exist.", 2, null)) != OnErrorAction.TERMINATE) continue;
                    return false;
                }
                String string = FilesKt.toRelativeString(file3, file);
                File file4 = new File(file2, string);
                if (!(!file4.exists() || file3.isDirectory() && file4.isDirectory())) {
                    boolean bl2;
                    boolean bl3 = !bl ? true : (file4.isDirectory() ? !FilesKt.deleteRecursively(file4) : (bl2 = !file4.delete()));
                    if (bl2) {
                        if (function2.invoke(file4, new FileAlreadyExistsException(file3, file4, "The destination file already exists.")) != OnErrorAction.TERMINATE) continue;
                        return false;
                    }
                }
                if (file3.isDirectory()) {
                    file4.mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default(file3, file4, bl, 0, 4, null).length() != file3.length() && function2.invoke(file3, new IOException("Source file wasn't copied completely, length of destination file differs.")) == OnErrorAction.TERMINATE) return false;
            }
            return true;
        }
        catch (TerminateException terminateException) {
            return false;
        }
    }

    public static /* synthetic */ boolean copyRecursively$default(File file, File file2, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function2 = copyRecursively.1.INSTANCE;
        }
        return FilesKt.copyRecursively(file, file2, bl, function2);
    }

    public static final boolean deleteRecursively(@NotNull File file) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Sequence sequence = FilesKt.walkBottomUp(file);
        boolean bl2 = bl = true;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            File file2 = (File)t;
            boolean bl3 = bl2;
            bl2 = (file2.delete() || !file2.exists()) && bl3;
        }
        return bl2;
    }

    public static final boolean startsWith(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "other");
        FilePathComponents filePathComponents = FilesKt.toComponents(file);
        FilePathComponents filePathComponents2 = FilesKt.toComponents(file2);
        if (Intrinsics.areEqual(filePathComponents.getRoot(), filePathComponents2.getRoot()) ^ true) {
            return false;
        }
        return filePathComponents.getSize() < filePathComponents2.getSize() ? false : ((Object)filePathComponents.getSegments().subList(0, filePathComponents2.getSize())).equals(filePathComponents2.getSegments());
    }

    public static final boolean startsWith(@NotNull File file, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(string, "other");
        return FilesKt.startsWith(file, new File(string));
    }

    public static final boolean endsWith(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "other");
        FilePathComponents filePathComponents = FilesKt.toComponents(file);
        FilePathComponents filePathComponents2 = FilesKt.toComponents(file2);
        if (filePathComponents2.isRooted()) {
            return Intrinsics.areEqual(file, file2);
        }
        int n = filePathComponents.getSize() - filePathComponents2.getSize();
        return n < 0 ? false : ((Object)filePathComponents.getSegments().subList(n, filePathComponents.getSize())).equals(filePathComponents2.getSegments());
    }

    public static final boolean endsWith(@NotNull File file, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(string, "other");
        return FilesKt.endsWith(file, new File(string));
    }

    @NotNull
    public static final File normalize(@NotNull File file) {
        FilePathComponents filePathComponents;
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        FilePathComponents filePathComponents2 = filePathComponents = FilesKt.toComponents(file);
        File file2 = filePathComponents2.getRoot();
        Iterable iterable = FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(filePathComponents2.getSegments());
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(string, "File.separator");
        return FilesKt.resolve(file2, CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null));
    }

    private static final FilePathComponents normalize$FilesKt__UtilsKt(@NotNull FilePathComponents filePathComponents) {
        return new FilePathComponents(filePathComponents.getRoot(), FilesKt__UtilsKt.normalize$FilesKt__UtilsKt(filePathComponents.getSegments()));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static final List<File> normalize$FilesKt__UtilsKt(@NotNull List<? extends File> var0) {
        var1_1 = new ArrayList<E>(var0.size());
        for (File var2_3 : var0) {
            if (var2_3.getName() == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var4_4.hashCode()) {
                case 1472: {
                    if (!var4_4.equals("..")) break;
                    tmp = 1;
                    break;
                }
                case 46: {
                    if (!var4_4.equals(".")) break;
                    tmp = 2;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    if (!var1_1.isEmpty() && Intrinsics.areEqual(((File)CollectionsKt.last(var1_1)).getName(), "..") ^ true) {
                        var1_1.remove(var1_1.size() - 1);
                        break;
                    }
                    var1_1.add(var2_3);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var1_1.add(var2_3);
                }
                case 2: 
            }
        }
        return var1_1;
    }

    @NotNull
    public static final File resolve(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "relative");
        if (FilesKt.isRooted(file2)) {
            return file2;
        }
        String string = file.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "this.toString()");
        String string2 = string;
        CharSequence charSequence = string2;
        return charSequence.length() == 0 || StringsKt.endsWith$default((CharSequence)string2, File.separatorChar, false, 2, null) ? new File(string2 + file2) : new File(string2 + File.separatorChar + file2);
    }

    @NotNull
    public static final File resolve(@NotNull File file, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(string, "relative");
        return FilesKt.resolve(file, new File(string));
    }

    @NotNull
    public static final File resolveSibling(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(file2, "relative");
        FilePathComponents filePathComponents = FilesKt.toComponents(file);
        File file3 = filePathComponents.getSize() == 0 ? new File("..") : filePathComponents.subPath(0, filePathComponents.getSize() - 1);
        return FilesKt.resolve(FilesKt.resolve(filePathComponents.getRoot(), file3), file2);
    }

    @NotNull
    public static final File resolveSibling(@NotNull File file, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull(file, "receiver$0");
        Intrinsics.checkParameterIsNotNull(string, "relative");
        return FilesKt.resolveSibling(file, new File(string));
    }
}

