/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.kotlin.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.RandomAccess;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.TypeCastException;
import shade.ru.endlesscode.rpginventory.kotlin.collections.AbstractIterator;
import shade.ru.endlesscode.rpginventory.kotlin.collections.AbstractList;
import shade.ru.endlesscode.rpginventory.kotlin.collections.RingBuffer;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\f\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0096\u0002J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0006J\u0015\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0014\u00a2\u0006\u0002\u0010 J'\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00010\t\"\u0004\b\u0001\u0010\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00010\tH\u0014\u00a2\u0006\u0002\u0010\"J9\u0010#\u001a\u00020\u0013\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\t2\u0006\u0010\u0014\u001a\u0002H\u00012\b\b\u0002\u0010$\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0082\bR\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lshade/ru/endlesscode/rpginventory/kotlin/collections/RingBuffer;", "T", "Lshade/ru/endlesscode/rpginventory/kotlin/collections/AbstractList;", "Ljava/util/RandomAccess;", "Lshade/ru/endlesscode/rpginventory/kotlin/collections/RandomAccess;", "capacity", "", "(I)V", "buffer", "", "", "[Ljava/lang/Object;", "getCapacity", "()I", "<set-?>", "size", "getSize", "startIndex", "add", "", "element", "(Ljava/lang/Object;)V", "get", "index", "(I)Ljava/lang/Object;", "isFull", "", "iterator", "", "removeFirst", "n", "toArray", "()[Ljava/lang/Object;", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "fill", "fromIndex", "toIndex", "([Ljava/lang/Object;Ljava/lang/Object;II)V", "forward", "shade.ru.endlesscode.rpginventory.kotlin-stdlib"})
final class RingBuffer<T>
extends AbstractList<T>
implements RandomAccess {
    private final Object[] buffer;
    private int startIndex;
    private int size;
    private final int capacity;

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public T get(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        int n2 = this.startIndex;
        RingBuffer ringBuffer = this;
        Object[] objectArray = this.buffer;
        int n3 = (n2 + n) % ringBuffer.getCapacity();
        return (T)objectArray[n3];
    }

    public final boolean isFull() {
        return this.size() == this.capacity;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(this){
            private int count;
            private int index;
            final /* synthetic */ RingBuffer this$0;

            protected void computeNext() {
                if (this.count == 0) {
                    this.done();
                } else {
                    int n;
                    this.setNext(RingBuffer.access$getBuffer$p(this.this$0)[this.index]);
                    int n2 = this.index;
                    RingBuffer ringBuffer = this.this$0;
                    int n3 = 1;
                    iterator.1 var5_5 = this;
                    var5_5.index = n = (n2 + n3) % ringBuffer.getCapacity();
                    int n4 = this.count;
                    this.count = n4 + -1;
                }
            }
            {
                this.this$0 = ringBuffer;
                this.count = ringBuffer.size();
                this.index = RingBuffer.access$getStartIndex$p(ringBuffer);
            }
        };
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] TArray) {
        int n;
        T[] TArray2;
        int n2;
        Intrinsics.checkParameterIsNotNull(TArray, "array");
        if (TArray.length < this.size()) {
            T[] TArray3 = TArray;
            n2 = this.size();
            T[] TArray4 = Arrays.copyOf(TArray3, n2);
            TArray2 = TArray4;
            Intrinsics.checkExpressionValueIsNotNull(TArray4, "java.util.Arrays.copyOf(this, newSize)");
        } else {
            TArray2 = TArray;
        }
        T[] TArray5 = TArray2;
        int n3 = this.size();
        n2 = 0;
        for (n = this.startIndex; n2 < n3 && n < this.capacity; ++n2, ++n) {
            TArray5[n2] = this.buffer[n];
        }
        n = 0;
        while (n2 < n3) {
            TArray5[n2] = this.buffer[n];
            ++n2;
            ++n;
        }
        if (TArray5.length > this.size()) {
            TArray5[this.size()] = null;
        }
        if (TArray5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return TArray5;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public final void add(T t) {
        if (this.isFull()) {
            throw (Throwable)new IllegalStateException("ring buffer is full");
        }
        int n = this.startIndex;
        RingBuffer ringBuffer = this;
        int n2 = this.size();
        Object[] objectArray = this.buffer;
        int n3 = (n + n2) % ringBuffer.getCapacity();
        objectArray[n3] = t;
        int n4 = this.size();
        this.size = n4 + 1;
    }

    public final void removeFirst(int n) {
        int n2;
        int n3 = n2 = n >= 0 ? 1 : 0;
        if (n2 == 0) {
            String string = "n shouldn't be negative but it is " + n;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n4 = n2 = n <= this.size() ? 1 : 0;
        if (n2 == 0) {
            String string = "n shouldn't be greater than the buffer size: n = " + n + ", size = " + this.size();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (n > 0) {
            int n5 = n2 = this.startIndex;
            RingBuffer ringBuffer = this;
            int n6 = (n5 + n) % ringBuffer.getCapacity();
            if (n2 > n6) {
                this.fill(this.buffer, null, n2, this.capacity);
                this.fill(this.buffer, null, 0, n6);
            } else {
                this.fill(this.buffer, null, n2, n6);
            }
            this.startIndex = n6;
            this.size = this.size() - n;
        }
    }

    private final int forward(int n, int n2) {
        return (n + n2) % this.getCapacity();
    }

    private final <T> void fill(@NotNull T[] TArray, T t, int n, int n2) {
        int n3 = n2;
        for (int i = n; i < n3; ++i) {
            TArray[i] = t;
        }
    }

    static /* synthetic */ void fill$default(RingBuffer ringBuffer, Object[] objectArray, Object object, int n, int n2, int n3, Object object2) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = objectArray.length;
        }
        ringBuffer.fill(objectArray, object, n, n2);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public RingBuffer(int n) {
        boolean bl;
        this.capacity = n;
        boolean bl2 = bl = this.capacity >= 0;
        if (!bl) {
            String string = "ring buffer capacity should not be negative but it is " + this.capacity;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.buffer = new Object[this.capacity];
    }

    public static final /* synthetic */ Object[] access$getBuffer$p(RingBuffer ringBuffer) {
        return ringBuffer.buffer;
    }

    public static final /* synthetic */ int access$forward(RingBuffer ringBuffer, int n, int n2) {
        return ringBuffer.forward(n, n2);
    }

    public static final /* synthetic */ int access$getSize$p(RingBuffer ringBuffer) {
        return ringBuffer.size();
    }

    public static final /* synthetic */ void access$setSize$p(RingBuffer ringBuffer, int n) {
        ringBuffer.size = n;
    }

    public static final /* synthetic */ int access$getStartIndex$p(RingBuffer ringBuffer) {
        return ringBuffer.startIndex;
    }

    public static final /* synthetic */ void access$setStartIndex$p(RingBuffer ringBuffer, int n) {
        ringBuffer.startIndex = n;
    }
}

