/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.kotlin.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.PublishedApi;
import shade.ru.endlesscode.rpginventory.kotlin.SinceKotlin;
import shade.ru.endlesscode.rpginventory.kotlin.TypeCastException;
import shade.ru.endlesscode.rpginventory.kotlin.collections.CollectionsKt;
import shade.ru.endlesscode.rpginventory.kotlin.internal.InlineOnly;
import shade.ru.endlesscode.rpginventory.kotlin.internal.PlatformImplementationsKt;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.CollectionToArray;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=5, xi=1, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0011\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0081\b\u001a\u0011\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0081\b\u001a\"\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0081\b\u00a2\u0006\u0002\u0010\n\u001a4\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0006\"\u0004\b\u0000\u0010\u000b2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0006H\u0081\b\u00a2\u0006\u0002\u0010\r\u001a\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0010\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u0011\u001a1\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006\"\u0004\b\u0000\u0010\u000b*\n\u0012\u0006\b\u0001\u0012\u0002H\u000b0\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\u001a\u001f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\u0017H\u0087\b\u00a8\u0006\u0018"}, d2={"checkCountOverflow", "", "count", "checkIndexOverflow", "index", "copyToArrayImpl", "", "", "collection", "", "(Ljava/util/Collection;)[Ljava/lang/Object;", "T", "array", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", "listOf", "", "element", "(Ljava/lang/Object;)Ljava/util/List;", "copyToArrayOfAny", "isVarargs", "", "([Ljava/lang/Object;Z)[Ljava/lang/Object;", "toList", "Ljava/util/Enumeration;", "shade.ru.endlesscode.rpginventory.kotlin-stdlib"}, xs="shade/ru/endlesscode/rpginventory/kotlin/collections/CollectionsKt")
class CollectionsKt__CollectionsJVMKt {
    @NotNull
    public static final <T> List<T> listOf(T t) {
        List<T> list = Collections.singletonList(t);
        Intrinsics.checkExpressionValueIsNotNull(list, "java.util.Collections.singletonList(element)");
        return list;
    }

    @InlineOnly
    private static final <T> List<T> toList(@NotNull Enumeration<T> enumeration) {
        ArrayList<T> arrayList = Collections.list(enumeration);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "java.util.Collections.list(this)");
        return arrayList;
    }

    @InlineOnly
    private static final Object[] copyToArrayImpl(Collection<?> collection) {
        return CollectionToArray.toArray(collection);
    }

    @InlineOnly
    private static final <T> T[] copyToArrayImpl(Collection<?> collection, T[] TArray) {
        if (TArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        }
        Object[] objectArray = CollectionToArray.toArray(collection, TArray);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    @NotNull
    public static final <T> Object[] copyToArrayOfAny(@NotNull T[] TArray, boolean bl) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull(TArray, "receiver$0");
        if (bl && Intrinsics.areEqual(TArray.getClass(), Object[].class)) {
            objectArray = TArray;
        } else {
            T[] TArray2 = Arrays.copyOf(TArray, TArray.length, Object[].class);
            objectArray = TArray2;
            Intrinsics.checkExpressionValueIsNotNull(TArray2, "java.util.Arrays.copyOf(\u2026 Array<Any?>::class.java)");
        }
        return objectArray;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final int checkIndexOverflow(int n) {
        if (n < 0) {
            if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 3, 0)) {
                CollectionsKt.throwIndexOverflow();
            } else {
                throw (Throwable)new ArithmeticException("Index overflow has happened.");
            }
        }
        return n;
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final int checkCountOverflow(int n) {
        if (n < 0) {
            if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 3, 0)) {
                CollectionsKt.throwCountOverflow();
            } else {
                throw (Throwable)new ArithmeticException("Count overflow has happened.");
            }
        }
        return n;
    }
}

