/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson.util;

public class BufferRecycler {
    public static final int BYTE_READ_IO_BUFFER = 0;
    public static final int BYTE_WRITE_ENCODING_BUFFER = 1;
    public static final int BYTE_WRITE_CONCAT_BUFFER = 2;
    public static final int BYTE_BASE64_CODEC_BUFFER = 3;
    public static final int CHAR_TOKEN_BUFFER = 0;
    public static final int CHAR_CONCAT_BUFFER = 1;
    public static final int CHAR_TEXT_BUFFER = 2;
    public static final int CHAR_NAME_COPY_BUFFER = 3;
    private static final int[] BYTE_BUFFER_LENGTHS = new int[]{8000, 8000, 2000, 2000};
    private static final int[] CHAR_BUFFER_LENGTHS = new int[]{4000, 4000, 200, 200};
    protected final byte[][] _byteBuffers;
    protected final char[][] _charBuffers;

    public BufferRecycler() {
        this(4, 4);
    }

    protected BufferRecycler(int n, int n2) {
        this._byteBuffers = new byte[n][];
        this._charBuffers = new char[n2][];
    }

    public final byte[] allocByteBuffer(int n) {
        return this.allocByteBuffer(n, 0);
    }

    public byte[] allocByteBuffer(int n, int n2) {
        byte[] byArray;
        int n3 = this.byteBufferLength(n);
        if (n2 < n3) {
            n2 = n3;
        }
        if ((byArray = this._byteBuffers[n]) == null || byArray.length < n2) {
            byArray = this.balloc(n2);
        } else {
            this._byteBuffers[n] = null;
        }
        return byArray;
    }

    public final void releaseByteBuffer(int n, byte[] byArray) {
        this._byteBuffers[n] = byArray;
    }

    public final char[] allocCharBuffer(int n) {
        return this.allocCharBuffer(n, 0);
    }

    public char[] allocCharBuffer(int n, int n2) {
        char[] cArray;
        int n3 = this.charBufferLength(n);
        if (n2 < n3) {
            n2 = n3;
        }
        if ((cArray = this._charBuffers[n]) == null || cArray.length < n2) {
            cArray = this.calloc(n2);
        } else {
            this._charBuffers[n] = null;
        }
        return cArray;
    }

    public void releaseCharBuffer(int n, char[] cArray) {
        this._charBuffers[n] = cArray;
    }

    protected int byteBufferLength(int n) {
        return BYTE_BUFFER_LENGTHS[n];
    }

    protected int charBufferLength(int n) {
        return CHAR_BUFFER_LENGTHS[n];
    }

    protected byte[] balloc(int n) {
        return new byte[n];
    }

    protected char[] calloc(int n) {
        return new char[n];
    }
}

