/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson.json;

import java.io.InputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import shade.ru.endlesscode.rpginventory.jackson.Base64Variant;
import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.jackson.JsonStreamContext;
import shade.ru.endlesscode.rpginventory.jackson.ObjectCodec;
import shade.ru.endlesscode.rpginventory.jackson.SerializableString;
import shade.ru.endlesscode.rpginventory.jackson.io.CharTypes;
import shade.ru.endlesscode.rpginventory.jackson.io.CharacterEscapes;
import shade.ru.endlesscode.rpginventory.jackson.io.IOContext;
import shade.ru.endlesscode.rpginventory.jackson.io.NumberOutput;
import shade.ru.endlesscode.rpginventory.jackson.json.JsonGeneratorImpl;
import shade.ru.endlesscode.rpginventory.jackson.json.JsonWriteContext;

public final class WriterBasedJsonGenerator
extends JsonGeneratorImpl {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected final Writer _writer;
    protected char _quoteChar = (char)34;
    protected char[] _outputBuffer;
    protected int _outputHead;
    protected int _outputTail;
    protected int _outputEnd;
    protected char[] _entityBuffer;
    protected SerializableString _currentEscape;

    public WriterBasedJsonGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, Writer writer) {
        super(iOContext, n, objectCodec);
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public int getOutputBuffered() {
        int n = this._outputTail - this._outputHead;
        return Math.max(0, n);
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public void writeFieldName(String string) {
        int n = this._writeContext.writeFieldName(string);
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string, n == 1);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        int n = this._writeContext.writeFieldName(serializableString.getValue());
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString, n == 1);
    }

    protected void _writeFieldName(String string, boolean bl) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeString(string);
            return;
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected void _writeFieldName(SerializableString serializableString, boolean bl) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        char[] cArray = serializableString.asQuotedChars();
        if (this._cfgUnqNames) {
            this.writeRaw(cArray, 0, cArray.length);
            return;
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n = cArray.length;
        if (this._outputTail + n + 1 >= this._outputEnd) {
            this.writeRaw(cArray, 0, n);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        } else {
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
    }

    @Override
    public void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public void writeStartObject(Object object) {
        JsonWriteContext jsonWriteContext;
        this._verifyValueWrite("start an object");
        this._writeContext = jsonWriteContext = this._writeContext.createChildObjectContext();
        if (object != null) {
            jsonWriteContext.setCurrentValue(object);
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
    }

    @Override
    public void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
    }

    @Override
    public void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    protected void _writePPFieldName(String string, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeString(string);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
            this._writeString(string);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    protected void _writePPFieldName(SerializableString serializableString, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        char[] cArray = serializableString.asQuotedChars();
        if (this._cfgUnqNames) {
            this.writeRaw(cArray, 0, cArray.length);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
            this.writeRaw(cArray, 0, cArray.length);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public void writeString(String string) {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(cArray, n, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(SerializableString serializableString) {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        char[] cArray = serializableString.asQuotedChars();
        int n = cArray.length;
        if (n < 32) {
            int n2 = this._outputEnd - this._outputTail;
            if (n > n2) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            this._writer.write(cArray, 0, n);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n, int n2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) {
        int n = string.length();
        int n2 = this._outputEnd - this._outputTail;
        if (n2 == 0) {
            this._flushBuffer();
            n2 = this._outputEnd - this._outputTail;
        }
        if (n2 >= n) {
            string.getChars(0, n, this._outputBuffer, this._outputTail);
            this._outputTail += n;
        } else {
            this.writeRawLong(string);
        }
    }

    @Override
    public void writeRaw(String string, int n, int n2) {
        int n3 = this._outputEnd - this._outputTail;
        if (n3 < n2) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(n, n + n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
        } else {
            this.writeRawLong(string.substring(n, n + n2));
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        this.writeRaw(serializableString.getValue());
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) {
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n, n2);
    }

    @Override
    public void writeRaw(char c) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private void writeRawLong(String string) {
        int n;
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        string.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n = string.length() - n3; n > this._outputEnd; n -= n2) {
            n2 = this._outputEnd;
            string.getChars(n4, n4 + n2, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        string.getChars(n4, n4 + n, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n;
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) {
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeBinary(base64Variant, byArray, n, n + n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) {
        int n2;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n < 0) {
                n2 = this._writeBinary(base64Variant, inputStream, byArray);
            } else {
                int n3 = this._writeBinary(base64Variant, inputStream, byArray, n);
                if (n3 > 0) {
                    this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n + ")");
                }
                n2 = n;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return n2;
    }

    @Override
    public void writeNumber(short s) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s);
            return;
        }
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt((int)s, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedShort(short s) {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt((int)s, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(int n) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n);
            return;
        }
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedInt(int n) {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(long l) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    private void _writeQuotedLong(long l) {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    @Override
    public void writeNumber(double d) {
        if (this._cfgNumbersAsStrings || this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS) && (Double.isNaN(d) || Double.isInfinite(d))) {
            this.writeString(String.valueOf(d));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(d));
    }

    @Override
    public void writeNumber(float f) {
        if (this._cfgNumbersAsStrings || this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS) && (Float.isNaN(f) || Float.isInfinite(f))) {
            this.writeString(String.valueOf(f));
            return;
        }
        this._verifyValueWrite("write a number");
        this.writeRaw(String.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        this._verifyValueWrite("write a number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(this._asString(bigDecimal));
        } else {
            this.writeRaw(this._asString(bigDecimal));
        }
    }

    @Override
    public void writeNumber(String string) {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
        } else {
            this.writeRaw(string);
        }
    }

    private void _writeQuotedRaw(String string) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this.writeRaw(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeBoolean(boolean bl) {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl) {
            cArray[n] = 116;
            cArray[++n] = 114;
            cArray[++n] = 117;
            cArray[++n] = 101;
        } else {
            cArray[n] = 102;
            cArray[++n] = 97;
            cArray[++n] = 108;
            cArray[++n] = 115;
            cArray[++n] = 101;
        }
        this._outputTail = n + 1;
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite("write a null");
        this._writeNull();
    }

    @Override
    protected void _verifyValueWrite(String string) {
        int n;
        int n2 = this._writeContext.writeValue();
        if (this._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite(string, n2);
            return;
        }
        switch (n2) {
            default: {
                return;
            }
            case 1: {
                n = 44;
                break;
            }
            case 2: {
                n = 58;
                break;
            }
            case 3: {
                if (this._rootValueSeparator != null) {
                    this.writeRaw(this._rootValueSeparator.getValue());
                }
                return;
            }
            case 5: {
                this._reportCantWriteValueExpectName(string);
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = n;
    }

    @Override
    public void flush() {
        this._flushBuffer();
        if (this._writer != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext jsonStreamContext;
                if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonStreamContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        this._outputHead = 0;
        this._outputTail = 0;
        if (this._writer != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._writer.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._writer.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (cArray != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    private void _writeString(String string) {
        int n = string.length();
        if (n > this._outputEnd) {
            this._writeLongString(string);
            return;
        }
        if (this._outputTail + n > this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n);
        } else if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(n, this._maximumNonEscapedChar);
        } else {
            this._writeString2(n);
        }
    }

    private void _writeString2(int n) {
        int n2 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        block0: while (this._outputTail < n2) {
            int n4;
            while ((n4 = this._outputBuffer[this._outputTail]) >= n3 || nArray[n4] == 0) {
                if (++this._outputTail < n2) continue;
                break block0;
            }
            n4 = this._outputTail - this._outputHead;
            if (n4 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n4);
            }
            char c = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c, nArray[c]);
        }
    }

    private void _writeLongString(String string) {
        int n;
        this._flushBuffer();
        int n2 = string.length();
        int n3 = 0;
        do {
            int n4;
            n = n3 + (n4 = this._outputEnd) > n2 ? n2 - n3 : n4;
            string.getChars(n3, n3 + n, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(n, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(n);
        } while ((n3 += n) < n2);
    }

    private void _writeSegment(int n) {
        int n2;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        int n4 = n2 = 0;
        while (n2 < n) {
            char c;
            while (((c = this._outputBuffer[n2]) >= n3 || nArray[c] == 0) && ++n2 < n) {
            }
            int n5 = n2 - n4;
            if (n5 > 0) {
                this._writer.write(this._outputBuffer, n4, n5);
                if (n2 >= n) break;
            }
            n4 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n2, n, c, nArray[c]);
        }
    }

    private void _writeString(char[] cArray, int n, int n2) {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n, n2);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(cArray, n, n2, this._maximumNonEscapedChar);
            return;
        }
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        while (n < n2) {
            int n4;
            int n5 = n;
            while (((n4 = cArray[n]) >= n3 || nArray[n4] == 0) && ++n < n2) {
            }
            n4 = n - n5;
            if (n4 < 32) {
                if (this._outputTail + n4 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n4 > 0) {
                    System.arraycopy(cArray, n5, this._outputBuffer, this._outputTail, n4);
                    this._outputTail += n4;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n5, n4);
            }
            if (n >= n2) break;
            char c = cArray[n++];
            this._appendCharacterEscape(c, nArray[c]);
        }
    }

    private void _writeStringASCII(int n, int n2) {
        int n3 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, n2 + 1);
        int n5 = 0;
        while (this._outputTail < n3) {
            char c;
            block5: {
                do {
                    if ((c = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[c];
                        if (n5 == 0) continue;
                    } else {
                        if (c <= n2) continue;
                        n5 = -1;
                    }
                    break block5;
                } while (++this._outputTail < n3);
                break;
            }
            int n6 = this._outputTail - this._outputHead;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n6);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape(c, n5);
        }
    }

    private void _writeSegmentASCII(int n, int n2) {
        int[] nArray = this._outputEscapes;
        int n3 = Math.min(nArray.length, n2 + 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = n4;
        while (n4 < n) {
            char c;
            do {
                if ((c = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[c];
                    if (n5 == 0) continue;
                    break;
                }
                if (c <= n2) continue;
                n5 = -1;
                break;
            } while (++n4 < n);
            int n7 = n4 - n6;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, n6, n7);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, c, n5);
        }
    }

    private void _writeStringASCII(char[] cArray, int n, int n2, int n3) {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        while (n < n2) {
            char c;
            int n6 = n;
            do {
                if ((c = cArray[n]) < n4) {
                    n5 = nArray[c];
                    if (n5 == 0) continue;
                    break;
                }
                if (c <= n3) continue;
                n5 = -1;
                break;
            } while (++n < n2);
            int n7 = n - n6;
            if (n7 < 32) {
                if (this._outputTail + n7 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n7 > 0) {
                    System.arraycopy(cArray, n6, this._outputBuffer, this._outputTail, n7);
                    this._outputTail += n7;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n6, n7);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape(c, n5);
        }
    }

    private void _writeStringCustom(int n) {
        int n2 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (this._outputTail < n2) {
            int n6;
            block7: {
                do {
                    if ((n6 = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[n6];
                        if (n5 == 0) continue;
                    } else if (n6 > n3) {
                        n5 = -1;
                    } else {
                        this._currentEscape = characterEscapes.getEscapeSequence(n6);
                        if (this._currentEscape == null) continue;
                        n5 = -2;
                    }
                    break block7;
                } while (++this._outputTail < n2);
                break;
            }
            int n7 = this._outputTail - this._outputHead;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n7);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape((char)n6, n5);
        }
    }

    private void _writeSegmentCustom(int n) {
        int[] nArray = this._outputEscapes;
        int n2 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n3 = Math.min(nArray.length, n2 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n4 = 0;
        int n5 = 0;
        int n6 = n4;
        while (n4 < n) {
            int n7;
            do {
                if ((n7 = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[n7];
                    if (n5 == 0) continue;
                    break;
                }
                if (n7 > n2) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n7);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n4 < n);
            int n8 = n4 - n6;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, n6, n8);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, (char)n7, n5);
        }
    }

    private void _writeStringCustom(char[] cArray, int n, int n2) {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n5 = 0;
        while (n < n2) {
            int n6;
            int n7 = n;
            do {
                if ((n6 = cArray[n]) < n4) {
                    n5 = nArray[n6];
                    if (n5 == 0) continue;
                    break;
                }
                if (n6 > n3) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n6);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n < n2);
            int n8 = n - n7;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    System.arraycopy(cArray, n7, this._outputBuffer, this._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n7, n8);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape((char)n6, n5);
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2 - 3;
        int n5 = this._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            n3 = byArray[n++] << 8;
            n3 |= byArray[n++] & 0xFF;
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n6 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        n3 = n2 - n;
        if (n3 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n7 = byArray[n++] << 16;
            if (n3 == 2) {
                n7 |= (byArray[n++] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n7, n3, this._outputBuffer, this._outputTail);
        }
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n > 2) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, n);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n2 = byArray[n3++] << 8;
            n2 |= byArray[n3++] & 0xFF;
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            n -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n > 0) {
            n4 = this._readMore(inputStream, byArray, n3, n4, n);
            n3 = 0;
            if (n4 > 0) {
                int n8;
                if (this._outputTail > n6) {
                    this._flushBuffer();
                }
                n2 = byArray[n3++] << 16;
                if (n3 < n4) {
                    n2 |= (byArray[n3] & 0xFF) << 8;
                    n8 = 2;
                } else {
                    n8 = 1;
                }
                this._outputTail = base64Variant.encodeBase64Partial(n2, n8, this._outputBuffer, this._outputTail);
                n -= n8;
            }
        }
        return n;
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n2 > n4) {
                n3 = this._readMore(inputStream, byArray, n2, n3, byArray.length);
                n2 = 0;
                if (n3 < 3) break;
                n4 = n3 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = byArray[n2++] << 8;
            n |= byArray[n2++] & 0xFF;
            n = n << 8 | byArray[n2++] & 0xFF;
            n5 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 < n3) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n = byArray[n2++] << 16;
            int n8 = 1;
            if (n2 < n3) {
                n |= (byArray[n2] & 0xFF) << 8;
                n8 = 2;
            }
            n5 += n8;
            this._outputTail = base64Variant.encodeBase64Partial(n, n8, this._outputBuffer, this._outputTail);
        }
        return n5;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        while (n < n2) {
            byArray[n5++] = byArray[n++];
        }
        n = 0;
        n2 = n5;
        n3 = Math.min(n3, byArray.length);
        while ((n4 = n3 - n2) != 0) {
            int n6 = inputStream.read(byArray, n2, n4);
            if (n6 < 0) {
                return n2;
            }
            if ((n2 += n6) < 3) continue;
        }
        return n2;
    }

    private final void _writeNull() {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        cArray[n] = 110;
        cArray[++n] = 117;
        cArray[++n] = 108;
        cArray[++n] = 108;
        this._outputTail = n + 1;
    }

    private void _prependOrWriteCharacterEscape(char c, int n) {
        String string;
        if (n >= 0) {
            if (this._outputTail >= 2) {
                int n2;
                this._outputHead = n2 = this._outputTail - 2;
                this._outputBuffer[n2++] = 92;
                this._outputBuffer[n2] = (char)n;
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            cArray[1] = (char)n;
            this._writer.write(cArray, 0, 2);
            return;
        }
        if (n != -2) {
            if (this._outputTail >= 6) {
                int n3;
                char[] cArray = this._outputBuffer;
                this._outputHead = n3 = this._outputTail - 6;
                cArray[n3] = 92;
                cArray[++n3] = 117;
                if (c > '\u00ff') {
                    int n4 = c >> 8 & 0xFF;
                    cArray[++n3] = HEX_CHARS[n4 >> 4];
                    cArray[++n3] = HEX_CHARS[n4 & 0xF];
                    c = (char)(c & 0xFF);
                } else {
                    cArray[++n3] = 48;
                    cArray[++n3] = 48;
                }
                cArray[++n3] = HEX_CHARS[c >> 4];
                cArray[++n3] = HEX_CHARS[c & 0xF];
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c > '\u00ff') {
                int n5 = c >> 8 & 0xFF;
                int n6 = c & 0xFF;
                cArray[10] = HEX_CHARS[n5 >> 4];
                cArray[11] = HEX_CHARS[n5 & 0xF];
                cArray[12] = HEX_CHARS[n6 >> 4];
                cArray[13] = HEX_CHARS[n6 & 0xF];
                this._writer.write(cArray, 8, 6);
            } else {
                cArray[6] = HEX_CHARS[c >> 4];
                cArray[7] = HEX_CHARS[c & 0xF];
                this._writer.write(cArray, 2, 6);
            }
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n7 = string.length();
        if (this._outputTail >= n7) {
            int n8;
            this._outputHead = n8 = this._outputTail - n7;
            string.getChars(0, n7, this._outputBuffer, n8);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(string);
    }

    private int _prependOrWriteCharacterEscape(char[] cArray, int n, int n2, char c, int n3) {
        String string;
        if (n3 >= 0) {
            if (n > 1 && n < n2) {
                cArray[n -= 2] = 92;
                cArray[n + 1] = (char)n3;
            } else {
                char[] cArray2 = this._entityBuffer;
                if (cArray2 == null) {
                    cArray2 = this._allocateEntityBuffer();
                }
                cArray2[1] = (char)n3;
                this._writer.write(cArray2, 0, 2);
            }
            return n;
        }
        if (n3 != -2) {
            if (n > 5 && n < n2) {
                n -= 6;
                cArray[n++] = 92;
                cArray[n++] = 117;
                if (c > '\u00ff') {
                    int n4 = c >> 8 & 0xFF;
                    cArray[n++] = HEX_CHARS[n4 >> 4];
                    cArray[n++] = HEX_CHARS[n4 & 0xF];
                    c = (char)(c & 0xFF);
                } else {
                    cArray[n++] = 48;
                    cArray[n++] = 48;
                }
                cArray[n++] = HEX_CHARS[c >> 4];
                cArray[n] = HEX_CHARS[c & 0xF];
                n -= 5;
            } else {
                char[] cArray3 = this._entityBuffer;
                if (cArray3 == null) {
                    cArray3 = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (c > '\u00ff') {
                    int n5 = c >> 8 & 0xFF;
                    int n6 = c & 0xFF;
                    cArray3[10] = HEX_CHARS[n5 >> 4];
                    cArray3[11] = HEX_CHARS[n5 & 0xF];
                    cArray3[12] = HEX_CHARS[n6 >> 4];
                    cArray3[13] = HEX_CHARS[n6 & 0xF];
                    this._writer.write(cArray3, 8, 6);
                } else {
                    cArray3[6] = HEX_CHARS[c >> 4];
                    cArray3[7] = HEX_CHARS[c & 0xF];
                    this._writer.write(cArray3, 2, 6);
                }
            }
            return n;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n7 = string.length();
        if (n >= n7 && n < n2) {
            string.getChars(0, n7, cArray, n -= n7);
        } else {
            this._writer.write(string);
        }
        return n;
    }

    private void _appendCharacterEscape(char c, int n) {
        String string;
        if (n >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = (char)n;
            return;
        }
        if (n != -2) {
            if (this._outputTail + 5 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            char[] cArray = this._outputBuffer;
            cArray[n2++] = 92;
            cArray[n2++] = 117;
            if (c > '\u00ff') {
                int n3 = c >> 8 & 0xFF;
                cArray[n2++] = HEX_CHARS[n3 >> 4];
                cArray[n2++] = HEX_CHARS[n3 & 0xF];
                c = (char)(c & 0xFF);
            } else {
                cArray[n2++] = 48;
                cArray[n2++] = 48;
            }
            cArray[n2++] = HEX_CHARS[c >> 4];
            cArray[n2++] = HEX_CHARS[c & 0xF];
            this._outputTail = n2;
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n4 = string.length();
        if (this._outputTail + n4 > this._outputEnd) {
            this._flushBuffer();
            if (n4 > this._outputEnd) {
                this._writer.write(string);
                return;
            }
        }
        string.getChars(0, n4, this._outputBuffer, this._outputTail);
        this._outputTail += n4;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray = new char[14];
        cArray[0] = 92;
        cArray[2] = 92;
        cArray[3] = 117;
        cArray[4] = 48;
        cArray[5] = 48;
        cArray[8] = 92;
        cArray[9] = 117;
        this._entityBuffer = cArray;
        return cArray;
    }

    protected void _flushBuffer() {
        int n = this._outputTail - this._outputHead;
        if (n > 0) {
            int n2 = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n2, n);
        }
    }
}

