/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson.json;

import java.io.DataInput;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import shade.ru.endlesscode.rpginventory.jackson.Base64Variant;
import shade.ru.endlesscode.rpginventory.jackson.JsonLocation;
import shade.ru.endlesscode.rpginventory.jackson.JsonParser;
import shade.ru.endlesscode.rpginventory.jackson.JsonToken;
import shade.ru.endlesscode.rpginventory.jackson.ObjectCodec;
import shade.ru.endlesscode.rpginventory.jackson.base.ParserBase;
import shade.ru.endlesscode.rpginventory.jackson.io.CharTypes;
import shade.ru.endlesscode.rpginventory.jackson.io.IOContext;
import shade.ru.endlesscode.rpginventory.jackson.sym.ByteQuadsCanonicalizer;
import shade.ru.endlesscode.rpginventory.jackson.util.ByteArrayBuilder;

public class UTF8DataInputJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected ObjectCodec _objectCodec;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete;
    private int _quad1;
    protected DataInput _inputData;
    protected int _nextByte = -1;

    public UTF8DataInputJsonParser(IOContext iOContext, int n, DataInput dataInput, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n2) {
        super(iOContext, n);
        this._objectCodec = objectCodec;
        this._symbols = byteQuadsCanonicalizer;
        this._inputData = dataInput;
        this._nextByte = n2;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) {
        return 0;
    }

    @Override
    public Object getInputSource() {
        return this._inputData;
    }

    @Override
    protected void _closeInput() {
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        this._symbols.release();
    }

    @Override
    public String getText() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public int getText(Writer writer) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            String string = this._parsingContext.getCurrentName();
            writer.write(string);
            return string.length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            writer.write(cArray);
            return cArray.length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public int getValueAsInt() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(n);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.size();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName().length();
        }
        if (this._currToken != null) {
            if (this._currToken.isNumeric()) {
                return this._textBuffer.size();
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n = this._readBinary(base64Variant, outputStream, byArray);
            return n;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) {
        int n = 0;
        int n2 = byArray.length - 3;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = this._inputData.readUnsignedByte()) <= 32) {
                continue;
            }
            int n5 = base64Variant.decodeBase64Char(n4);
            if (n5 < 0) {
                if (n4 == 34) break;
                n5 = this._decodeBase64Escape(base64Variant, n4, 0);
                if (n5 < 0) continue;
            }
            if (n > n2) {
                n3 += n;
                outputStream.write(byArray, 0, n);
                n = 0;
            }
            int n6 = n5;
            n4 = this._inputData.readUnsignedByte();
            n5 = base64Variant.decodeBase64Char(n4);
            if (n5 < 0) {
                n5 = this._decodeBase64Escape(base64Variant, n4, 1);
            }
            n6 = n6 << 6 | n5;
            n4 = this._inputData.readUnsignedByte();
            n5 = base64Variant.decodeBase64Char(n4);
            if (n5 < 0) {
                if (n5 != -2) {
                    if (n4 == 34 && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)(n6 >>= 4);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, n4, 2);
                }
                if (n5 == -2) {
                    n4 = this._inputData.readUnsignedByte();
                    if (!base64Variant.usesPaddingChar(n4)) {
                        throw this.reportInvalidBase64Char(base64Variant, n4, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n++] = (byte)(n6 >>= 4);
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            n4 = this._inputData.readUnsignedByte();
            n5 = base64Variant.decodeBase64Char(n4);
            if (n5 < 0) {
                if (n5 != -2) {
                    if (n4 == 34 && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)((n6 >>= 2) >> 8);
                        byArray[n++] = (byte)n6;
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, n4, 3);
                }
                if (n5 == -2) {
                    byArray[n++] = (byte)((n6 >>= 2) >> 8);
                    byArray[n++] = (byte)n6;
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            byArray[n++] = (byte)(n6 >> 16);
            byArray[n++] = (byte)(n6 >> 8);
            byArray[n++] = (byte)n6;
        }
        this._tokenIncomplete = false;
        if (n > 0) {
            n3 += n;
            outputStream.write(byArray, 0, n);
        }
        return n3;
    }

    @Override
    public JsonToken nextToken() {
        JsonToken jsonToken;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        int n = this._skipWS();
        this._binaryValue = null;
        this._tokenInputRow = this._currInputRow;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            return this._nextTokenNotInObject(n);
        }
        String string = this._parseName(n);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken _nextTokenNotInObject(int n) {
        if (n == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseNegNumber();
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parsePosNumber(n);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n);
        return this._currToken;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    @Override
    public String nextFieldName() {
        JsonToken jsonToken;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        int n = this._skipWS();
        this._binaryValue = null;
        this._tokenInputRow = this._currInputRow;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
            return null;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
            return null;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            this._nextTokenNotInObject(n);
            return null;
        }
        String string = this._parseName(n);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    @Override
    public String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    return this._finishAndReturnString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n;
    }

    @Override
    public long nextLongValue(long l) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l;
    }

    @Override
    public Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected JsonToken _parsePosNumber(int n) {
        int n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (n == 48) {
            n = this._handleLeadingZeroes();
            if (n <= 57 && n >= 48) {
                n2 = 0;
            } else {
                cArray[0] = 48;
                n2 = 1;
            }
        } else {
            cArray[0] = (char)n;
            n = this._inputData.readUnsignedByte();
            n2 = 1;
        }
        int n3 = n2;
        while (n <= 57 && n >= 48) {
            ++n3;
            cArray[n2++] = (char)n;
            n = this._inputData.readUnsignedByte();
        }
        if (n == 46 || n == 101 || n == 69) {
            return this._parseFloat(cArray, n2, n, false, n3);
        }
        this._textBuffer.setCurrentLength(n2);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace();
        } else {
            this._nextByte = n;
        }
        return this.resetInt(false, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonToken _parseNegNumber() {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n = 0;
        cArray[n++] = 45;
        int n2 = this._inputData.readUnsignedByte();
        cArray[n++] = (char)n2;
        if (n2 <= 48) {
            if (n2 != 48) return this._handleInvalidNumberStart(n2, true);
            n2 = this._handleLeadingZeroes();
        } else {
            if (n2 > 57) {
                return this._handleInvalidNumberStart(n2, true);
            }
            n2 = this._inputData.readUnsignedByte();
        }
        int n3 = 1;
        while (n2 <= 57 && n2 >= 48) {
            ++n3;
            cArray[n++] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 46 || n2 == 101 || n2 == 69) {
            return this._parseFloat(cArray, n, n2, true, n3);
        }
        this._textBuffer.setCurrentLength(n);
        this._nextByte = n2;
        if (!this._parsingContext.inRoot()) return this.resetInt(true, n3);
        this._verifyRootSpace();
        return this.resetInt(true, n3);
    }

    private final int _handleLeadingZeroes() {
        int n = this._inputData.readUnsignedByte();
        if (n < 48 || n > 57) {
            return n;
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        while (n == 48) {
            n = this._inputData.readUnsignedByte();
        }
        return n;
    }

    private final JsonToken _parseFloat(char[] cArray, int n, int n2, boolean bl, int n3) {
        int n4 = 0;
        if (n2 == 46) {
            cArray[n++] = (char)n2;
            while ((n2 = this._inputData.readUnsignedByte()) >= 48 && n2 <= 57) {
                ++n4;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
            }
        }
        int n5 = 0;
        if (n2 == 101 || n2 == 69) {
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
            if (n2 == 45 || n2 == 43) {
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                n2 = this._inputData.readUnsignedByte();
            }
            while (n2 <= 57 && n2 >= 48) {
                ++n5;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                n2 = this._inputData.readUnsignedByte();
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        this._nextByte = n2;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace();
        }
        this._textBuffer.setCurrentLength(n);
        return this.resetFloat(bl, n3, n4, n5);
    }

    private final void _verifyRootSpace() {
        int n = this._nextByte;
        if (n <= 32) {
            this._nextByte = -1;
            if (n == 13 || n == 10) {
                ++this._currInputRow;
            }
            return;
        }
        this._reportMissingRootWS(n);
    }

    protected final String _parseName(int n) {
        if (n != 34) {
            return this._handleOddName(n);
        }
        int[] nArray = _icLatin1;
        int n2 = this._inputData.readUnsignedByte();
        if (nArray[n2] == 0) {
            n = this._inputData.readUnsignedByte();
            if (nArray[n] == 0) {
                n2 = n2 << 8 | n;
                n = this._inputData.readUnsignedByte();
                if (nArray[n] == 0) {
                    n2 = n2 << 8 | n;
                    n = this._inputData.readUnsignedByte();
                    if (nArray[n] == 0) {
                        n2 = n2 << 8 | n;
                        n = this._inputData.readUnsignedByte();
                        if (nArray[n] == 0) {
                            this._quad1 = n2;
                            return this._parseMediumName(n);
                        }
                        if (n == 34) {
                            return this.findName(n2, 4);
                        }
                        return this.parseName(n2, n, 4);
                    }
                    if (n == 34) {
                        return this.findName(n2, 3);
                    }
                    return this.parseName(n2, n, 3);
                }
                if (n == 34) {
                    return this.findName(n2, 2);
                }
                return this.parseName(n2, n, 2);
            }
            if (n == 34) {
                return this.findName(n2, 1);
            }
            return this.parseName(n2, n, 1);
        }
        if (n2 == 34) {
            return "";
        }
        return this.parseName(0, n2, 0);
    }

    private final String _parseMediumName(int n) {
        int[] nArray = _icLatin1;
        int n2 = this._inputData.readUnsignedByte();
        if (nArray[n2] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 1);
            }
            return this.parseName(this._quad1, n, n2, 1);
        }
        n = n << 8 | n2;
        n2 = this._inputData.readUnsignedByte();
        if (nArray[n2] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 2);
            }
            return this.parseName(this._quad1, n, n2, 2);
        }
        n = n << 8 | n2;
        n2 = this._inputData.readUnsignedByte();
        if (nArray[n2] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 3);
            }
            return this.parseName(this._quad1, n, n2, 3);
        }
        n = n << 8 | n2;
        n2 = this._inputData.readUnsignedByte();
        if (nArray[n2] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 4);
            }
            return this.parseName(this._quad1, n, n2, 4);
        }
        return this._parseMediumName2(n2, n);
    }

    private final String _parseMediumName2(int n, int n2) {
        int[] nArray = _icLatin1;
        int n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 1);
            }
            return this.parseName(this._quad1, n2, n, n3, 1);
        }
        n = n << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 2);
            }
            return this.parseName(this._quad1, n2, n, n3, 2);
        }
        n = n << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 3);
            }
            return this.parseName(this._quad1, n2, n, n3, 3);
        }
        n = n << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 4);
            }
            return this.parseName(this._quad1, n2, n, n3, 4);
        }
        return this._parseLongName(n3, n2, n);
    }

    private final String _parseLongName(int n, int n2, int n3) {
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = n2;
        this._quadBuffer[2] = n3;
        int[] nArray = _icLatin1;
        int n4 = 3;
        while (true) {
            int n5;
            if (nArray[n5 = this._inputData.readUnsignedByte()] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 1);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 1);
            }
            n = n << 8 | n5;
            n5 = this._inputData.readUnsignedByte();
            if (nArray[n5] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 2);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 2);
            }
            n = n << 8 | n5;
            n5 = this._inputData.readUnsignedByte();
            if (nArray[n5] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 3);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 3);
            }
            n = n << 8 | n5;
            n5 = this._inputData.readUnsignedByte();
            if (nArray[n5] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 4);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 4);
            }
            if (n4 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8DataInputJsonParser._growArrayBy(this._quadBuffer, n4);
            }
            this._quadBuffer[n4++] = n;
            n = n5;
        }
    }

    private final String parseName(int n, int n2, int n3) {
        return this.parseEscapedName(this._quadBuffer, 0, n, n2, n3);
    }

    private final String parseName(int n, int n2, int n3, int n4) {
        this._quadBuffer[0] = n;
        return this.parseEscapedName(this._quadBuffer, 1, n2, n3, n4);
    }

    private final String parseName(int n, int n2, int n3, int n4, int n5) {
        this._quadBuffer[0] = n;
        this._quadBuffer[1] = n2;
        return this.parseEscapedName(this._quadBuffer, 2, n3, n4, n5);
    }

    protected final String parseEscapedName(int[] nArray, int n, int n2, int n3, int n4) {
        String string;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (nArray2[n3] != 0) {
                if (n3 == 34) break;
                if (n3 != 92) {
                    this._throwUnquotedSpace(n3, "name");
                } else {
                    n3 = this._decodeEscaped();
                }
                if (n3 > 127) {
                    if (n4 >= 4) {
                        if (n >= nArray.length) {
                            nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n++] = n2;
                        n2 = 0;
                        n4 = 0;
                    }
                    if (n3 < 2048) {
                        n2 = n2 << 8 | (0xC0 | n3 >> 6);
                        ++n4;
                    } else {
                        n2 = n2 << 8 | (0xE0 | n3 >> 12);
                        if (++n4 >= 4) {
                            if (n >= nArray.length) {
                                nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n++] = n2;
                            n2 = 0;
                            n4 = 0;
                        }
                        n2 = n2 << 8 | (0x80 | n3 >> 6 & 0x3F);
                        ++n4;
                    }
                    n3 = 0x80 | n3 & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n2 = n2 << 8 | n3;
            } else {
                if (n >= nArray.length) {
                    nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n++] = n2;
                n2 = n3;
                n4 = 1;
            }
            n3 = this._inputData.readUnsignedByte();
        }
        if (n4 > 0) {
            if (n >= nArray.length) {
                nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n++] = UTF8DataInputJsonParser.pad(n2, n4);
        }
        if ((string = this._symbols.findName(nArray, n)) == null) {
            string = this.addName(nArray, n, n4);
        }
        return string;
    }

    protected String _handleOddName(int n) {
        String string;
        int[] nArray;
        if (n == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseAposName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            char c = (char)this._decodeCharForError(n);
            this._reportUnexpectedChar(c, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n] != 0) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
                continue;
            }
            if (n2 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser._growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n2++] = n3;
            n3 = n;
            n4 = 1;
        } while (nArray[n = this._inputData.readUnsignedByte()] == 0);
        this._nextByte = n;
        if (n4 > 0) {
            if (n2 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser._growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n2++] = n3;
        }
        if ((string = this._symbols.findName(nArray2, n2)) == null) {
            string = this.addName(nArray2, n2, n4);
        }
        return string;
    }

    protected String _parseAposName() {
        String string;
        int n = this._inputData.readUnsignedByte();
        if (n == 39) {
            return "";
        }
        int[] nArray = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray2 = _icLatin1;
        while (n != 39) {
            if (n != 34 && nArray2[n] != 0) {
                if (n != 92) {
                    this._throwUnquotedSpace(n, "name");
                } else {
                    n = this._decodeEscaped();
                }
                if (n > 127) {
                    if (n4 >= 4) {
                        if (n2 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n4 = 0;
                    }
                    if (n < 2048) {
                        n3 = n3 << 8 | (0xC0 | n >> 6);
                        ++n4;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n >> 12);
                        if (++n4 >= 4) {
                            if (n2 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n4 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n >> 6 & 0x3F);
                        ++n4;
                    }
                    n = 0x80 | n & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
            } else {
                if (n2 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                }
                nArray[n2++] = n3;
                n3 = n;
                n4 = 1;
            }
            n = this._inputData.readUnsignedByte();
        }
        if (n4 > 0) {
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = UTF8DataInputJsonParser.pad(n3, n4);
        }
        if ((string = this._symbols.findName(nArray, n2)) == null) {
            string = this.addName(nArray, n2, n4);
        }
        return string;
    }

    private final String findName(int n, int n2) {
        String string = this._symbols.findName(n = UTF8DataInputJsonParser.pad(n, n2));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n;
        return this.addName(this._quadBuffer, 1, n2);
    }

    private final String findName(int n, int n2, int n3) {
        String string = this._symbols.findName(n, n2 = UTF8DataInputJsonParser.pad(n2, n3));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n;
        this._quadBuffer[1] = n2;
        return this.addName(this._quadBuffer, 2, n3);
    }

    private final String findName(int n, int n2, int n3, int n4) {
        String string = this._symbols.findName(n, n2, n3 = UTF8DataInputJsonParser.pad(n3, n4));
        if (string != null) {
            return string;
        }
        int[] nArray = this._quadBuffer;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = UTF8DataInputJsonParser.pad(n3, n4);
        return this.addName(nArray, 3, n4);
    }

    private final String findName(int[] nArray, int n, int n2, int n3) {
        if (n >= nArray.length) {
            nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n++] = UTF8DataInputJsonParser.pad(n2, n3);
        String string = this._symbols.findName(nArray, n);
        if (string == null) {
            return this.addName(nArray, n, n3);
        }
        return string;
    }

    private final String addName(int[] nArray, int n, int n2) {
        int n3;
        int n4 = (n << 2) - 4 + n2;
        if (n2 < 4) {
            n3 = nArray[n - 1];
            nArray[n - 1] = n3 << (4 - n2 << 3);
        } else {
            n3 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = nArray[n6 >> 2];
            int n8 = n6 & 3;
            n7 = n7 >> (3 - n8 << 3) & 0xFF;
            ++n6;
            if (n7 > 127) {
                int n9;
                if ((n7 & 0xE0) == 192) {
                    n7 &= 0x1F;
                    n9 = 1;
                } else if ((n7 & 0xF0) == 224) {
                    n7 &= 0xF;
                    n9 = 2;
                } else if ((n7 & 0xF8) == 240) {
                    n7 &= 7;
                    n9 = 3;
                } else {
                    this._reportInvalidInitial(n7);
                    n7 = 1;
                    n9 = 1;
                }
                if (n6 + n9 > n4) {
                    this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                }
                int n10 = nArray[n6 >> 2];
                n8 = n6 & 3;
                ++n6;
                if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n10);
                }
                n7 = n7 << 6 | n10 & 0x3F;
                if (n9 > 1) {
                    n10 = nArray[n6 >> 2];
                    n8 = n6 & 3;
                    ++n6;
                    if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n10);
                    }
                    n7 = n7 << 6 | n10 & 0x3F;
                    if (n9 > 2) {
                        n10 = nArray[n6 >> 2];
                        n8 = n6 & 3;
                        ++n6;
                        if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n10 & 0xFF);
                        }
                        n7 = n7 << 6 | n10 & 0x3F;
                    }
                }
                if (n9 > 2) {
                    n7 -= 65536;
                    if (n5 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n5++] = (char)(55296 + (n7 >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                }
            }
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n5++] = (char)n7;
        }
        String string = new String(cArray, 0, n5);
        if (n2 < 4) {
            nArray[n - 1] = n3;
        }
        return this._symbols.addName(string, nArray, n);
    }

    @Override
    protected void _finishString() {
        int n = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n2 = cArray.length;
        do {
            int n3;
            if (nArray[n3 = this._inputData.readUnsignedByte()] != 0) {
                if (n3 == 34) {
                    this._textBuffer.setCurrentLength(n);
                    return;
                }
                this._finishString2(cArray, n, n3);
                return;
            }
            cArray[n++] = (char)n3;
        } while (n < n2);
        this._finishString2(cArray, n, this._inputData.readUnsignedByte());
    }

    private String _finishAndReturnString() {
        int n = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n2 = cArray.length;
        do {
            int n3;
            if (nArray[n3 = this._inputData.readUnsignedByte()] != 0) {
                if (n3 == 34) {
                    return this._textBuffer.setCurrentAndReturn(n);
                }
                this._finishString2(cArray, n, n3);
                return this._textBuffer.contentsAsString();
            }
            cArray[n++] = (char)n3;
        } while (n < n2);
        this._finishString2(cArray, n, this._inputData.readUnsignedByte());
        return this._textBuffer.contentsAsString();
    }

    private final void _finishString2(char[] cArray, int n, int n2) {
        int[] nArray = _icUTF8;
        int n3 = cArray.length;
        while (true) {
            if (nArray[n2] == 0) {
                if (n >= n3) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                    n3 = cArray.length;
                }
                cArray[n++] = (char)n2;
                n2 = this._inputData.readUnsignedByte();
                continue;
            }
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    n2 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 3: {
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 4: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n++] = (char)(0xD800 | n2 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                        n3 = cArray.length;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                        break;
                    }
                    this._reportInvalidChar(n2);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
                n3 = cArray.length;
            }
            cArray[n++] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected void _skipString() {
        this._tokenIncomplete = false;
        int[] nArray = _icUTF8;
        block6: while (true) {
            int n;
            if (nArray[n = this._inputData.readUnsignedByte()] == 0) {
                continue;
            }
            if (n == 34) break;
            switch (nArray[n]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4();
                    continue block6;
                }
            }
            if (n < 32) {
                this._throwUnquotedSpace(n, "string value");
                continue;
            }
            this._reportInvalidChar(n);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n) {
        switch (n) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (this.isEnabled(JsonParser.Feature.ALLOW_MISSING_VALUES)) {
                    this._nextByte = n;
                    return JsonToken.VALUE_NULL;
                }
            }
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                return this._handleInvalidNumberStart(this._inputData.readUnsignedByte(), false);
            }
        }
        if (Character.isJavaIdentifierStart(n)) {
            this._reportInvalidToken(n, "" + (char)n, "('true', 'false' or 'null')");
        }
        this._reportUnexpectedChar(n, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected JsonToken _handleApos() {
        int n = 0;
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        block6: while (true) {
            int n3 = cArray.length;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
                n3 = cArray.length;
            }
            while ((n = this._inputData.readUnsignedByte()) != 39) {
                if (nArray[n] == 0) {
                    cArray[n2++] = (char)n;
                    if (n2 < n3) continue;
                    continue block6;
                }
                switch (nArray[n]) {
                    case 1: {
                        n = this._decodeEscaped();
                        break;
                    }
                    case 2: {
                        n = this._decodeUtf8_2(n);
                        break;
                    }
                    case 3: {
                        n = this._decodeUtf8_3(n);
                        break;
                    }
                    case 4: {
                        n = this._decodeUtf8_4(n);
                        cArray[n2++] = (char)(0xD800 | n >> 10);
                        if (n2 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n2 = 0;
                        }
                        n = 0xDC00 | n & 0x3FF;
                        break;
                    }
                    default: {
                        if (n < 32) {
                            this._throwUnquotedSpace(n, "string value");
                        }
                        this._reportInvalidChar(n);
                    }
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n;
                continue block6;
            }
            break;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n, boolean bl) {
        while (n == 73) {
            String string;
            n = this._inputData.readUnsignedByte();
            if (n == 78) {
                string = bl ? "-INF" : "+INF";
            } else {
                if (n != 110) break;
                string = bl ? "-Infinity" : "+Infinity";
            }
            this._matchToken(string, 3);
            if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
        }
        this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected final void _matchToken(String string, int n) {
        int n2;
        int n3 = string.length();
        do {
            if ((n2 = this._inputData.readUnsignedByte()) == string.charAt(n)) continue;
            this._reportInvalidToken(n2, string.substring(0, n));
        } while (++n < n3);
        n2 = this._inputData.readUnsignedByte();
        if (n2 >= 48 && n2 != 93 && n2 != 125) {
            this._checkMatchEnd(string, n, n2);
        }
        this._nextByte = n2;
    }

    private final void _checkMatchEnd(String string, int n, int n2) {
        char c = (char)this._decodeCharForError(n2);
        if (Character.isJavaIdentifierPart(c)) {
            this._reportInvalidToken(c, string.substring(0, n));
        }
    }

    private final int _skipWS() {
        int n = this._nextByte;
        if (n < 0) {
            n = this._inputData.readUnsignedByte();
        } else {
            this._nextByte = -1;
        }
        while (true) {
            if (n > 32) {
                if (n == 47 || n == 35) {
                    return this._skipWSComment(n);
                }
                return n;
            }
            if (n == 13 || n == 10) {
                ++this._currInputRow;
            }
            n = this._inputData.readUnsignedByte();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int _skipWSComment(int n) {
        while (true) {
            if (n > 32) {
                if (n == 47) {
                    this._skipComment();
                } else {
                    if (n != 35) return n;
                    if (!this._skipYAMLComment()) {
                        return n;
                    }
                }
            } else if (n == 13 || n == 10) {
                ++this._currInputRow;
            }
            n = this._inputData.readUnsignedByte();
        }
    }

    private final int _skipColon() {
        int n = this._nextByte;
        if (n < 0) {
            n = this._inputData.readUnsignedByte();
        } else {
            this._nextByte = -1;
        }
        if (n == 58) {
            n = this._inputData.readUnsignedByte();
            if (n > 32) {
                if (n == 47 || n == 35) {
                    return this._skipColon2(n, true);
                }
                return n;
            }
            if ((n == 32 || n == 9) && (n = this._inputData.readUnsignedByte()) > 32) {
                if (n == 47 || n == 35) {
                    return this._skipColon2(n, true);
                }
                return n;
            }
            return this._skipColon2(n, true);
        }
        if (n == 32 || n == 9) {
            n = this._inputData.readUnsignedByte();
        }
        if (n == 58) {
            n = this._inputData.readUnsignedByte();
            if (n > 32) {
                if (n == 47 || n == 35) {
                    return this._skipColon2(n, true);
                }
                return n;
            }
            if ((n == 32 || n == 9) && (n = this._inputData.readUnsignedByte()) > 32) {
                if (n == 47 || n == 35) {
                    return this._skipColon2(n, true);
                }
                return n;
            }
            return this._skipColon2(n, true);
        }
        return this._skipColon2(n, false);
    }

    private final int _skipColon2(int n, boolean bl) {
        while (true) {
            if (n > 32) {
                if (n == 47) {
                    this._skipComment();
                } else if (n != 35 || !this._skipYAMLComment()) {
                    if (bl) {
                        return n;
                    }
                    if (n != 58) {
                        this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
                    }
                    bl = true;
                }
            } else if (n == 13 || n == 10) {
                ++this._currInputRow;
            }
            n = this._inputData.readUnsignedByte();
        }
    }

    private final void _skipComment() {
        int n;
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if ((n = this._inputData.readUnsignedByte()) == 47) {
            this._skipLine();
        } else if (n == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() {
        int[] nArray = CharTypes.getInputCodeComment();
        int n = this._inputData.readUnsignedByte();
        block7: while (true) {
            int n2;
            if ((n2 = nArray[n]) != 0) {
                switch (n2) {
                    case 42: {
                        n = this._inputData.readUnsignedByte();
                        if (n != 47) continue block7;
                        return;
                    }
                    case 10: 
                    case 13: {
                        ++this._currInputRow;
                        break;
                    }
                    case 2: {
                        this._skipUtf8_2();
                        break;
                    }
                    case 3: {
                        this._skipUtf8_3();
                        break;
                    }
                    case 4: {
                        this._skipUtf8_4();
                        break;
                    }
                    default: {
                        this._reportInvalidChar(n);
                    }
                }
            }
            n = this._inputData.readUnsignedByte();
        }
    }

    private final boolean _skipYAMLComment() {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_YAML_COMMENTS)) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private final void _skipLine() {
        int[] nArray = CharTypes.getInputCodeComment();
        block7: while (true) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputData.readUnsignedByte()]) == 0) {
                continue;
            }
            switch (n2) {
                case 10: 
                case 13: {
                    ++this._currInputRow;
                    return;
                }
                case 42: {
                    continue block7;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block7;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block7;
                }
                case 4: {
                    this._skipUtf8_4();
                    continue block7;
                }
            }
            if (n2 >= 0) continue;
            this._reportInvalidChar(n);
        }
    }

    @Override
    protected char _decodeEscaped() {
        int n = this._inputData.readUnsignedByte();
        switch (n) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)n;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(n));
            }
        }
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3 = this._inputData.readUnsignedByte();
            int n4 = CharTypes.charToHex(n3);
            if (n4 < 0) {
                this._reportUnexpectedChar(n3, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n4;
        }
        return (char)n2;
    }

    protected int _decodeCharForError(int n) {
        int n2 = n & 0xFF;
        if (n2 > 127) {
            int n3;
            if ((n2 & 0xE0) == 192) {
                n2 &= 0x1F;
                n3 = 1;
            } else if ((n2 & 0xF0) == 224) {
                n2 &= 0xF;
                n3 = 2;
            } else if ((n2 & 0xF8) == 240) {
                n2 &= 7;
                n3 = 3;
            } else {
                this._reportInvalidInitial(n2 & 0xFF);
                n3 = 1;
            }
            int n4 = this._inputData.readUnsignedByte();
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (n3 > 1) {
                n4 = this._inputData.readUnsignedByte();
                if ((n4 & 0xC0) != 128) {
                    this._reportInvalidOther(n4 & 0xFF);
                }
                n2 = n2 << 6 | n4 & 0x3F;
                if (n3 > 2) {
                    n4 = this._inputData.readUnsignedByte();
                    if ((n4 & 0xC0) != 128) {
                        this._reportInvalidOther(n4 & 0xFF);
                    }
                    n2 = n2 << 6 | n4 & 0x3F;
                }
            }
        }
        return n2;
    }

    private final int _decodeUtf8_2(int n) {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        return (n & 0x1F) << 6 | n2 & 0x3F;
    }

    private final int _decodeUtf8_3(int n) {
        n &= 0xF;
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        int n3 = n << 6 | n2 & 0x3F;
        n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        n3 = n3 << 6 | n2 & 0x3F;
        return n3;
    }

    private final int _decodeUtf8_4(int n) {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        n = (n & 7) << 6 | n2 & 0x3F;
        n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        n = n << 6 | n2 & 0x3F;
        n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        return (n << 6 | n2 & 0x3F) - 65536;
    }

    private final void _skipUtf8_2() {
        int n = this._inputData.readUnsignedByte();
        if ((n & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF);
        }
    }

    private final void _skipUtf8_3() {
        int n = this._inputData.readUnsignedByte();
        if ((n & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF);
        }
        if (((n = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF);
        }
    }

    private final void _skipUtf8_4() {
        int n = this._inputData.readUnsignedByte();
        if ((n & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF);
        }
        if (((n = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF);
        }
        if (((n = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n & 0xFF);
        }
    }

    protected void _reportInvalidToken(int n, String string) {
        this._reportInvalidToken(n, string, "'null', 'true', 'false' or NaN");
    }

    protected void _reportInvalidToken(int n, String string, String string2) {
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while (Character.isJavaIdentifierPart(c = (char)this._decodeCharForError(n))) {
            stringBuilder.append(c);
            n = this._inputData.readUnsignedByte();
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting " + string2);
    }

    protected void _reportInvalidChar(int n) {
        if (n < 32) {
            this._throwInvalidSpace(n);
        }
        this._reportInvalidInitial(n);
    }

    protected void _reportInvalidInitial(int n) {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    private void _reportInvalidOther(int n) {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    private static int[] _growArrayBy(int[] nArray, int n) {
        if (nArray == null) {
            return new int[n];
        }
        return Arrays.copyOf(nArray, nArray.length + n);
    }

    protected final byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n;
            if ((n = this._inputData.readUnsignedByte()) <= 32) {
                continue;
            }
            int n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                if (n == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n2 = this._decodeBase64Escape(base64Variant, n, 0);
                if (n2 < 0) continue;
            }
            int n3 = n2;
            n = this._inputData.readUnsignedByte();
            n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                n2 = this._decodeBase64Escape(base64Variant, n, 1);
            }
            n3 = n3 << 6 | n2;
            n = this._inputData.readUnsignedByte();
            n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                if (n2 != -2) {
                    if (n == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n3 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 2);
                }
                if (n2 == -2) {
                    n = this._inputData.readUnsignedByte();
                    if (!base64Variant.usesPaddingChar(n)) {
                        throw this.reportInvalidBase64Char(base64Variant, n, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n3 >>= 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            n = this._inputData.readUnsignedByte();
            n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                if (n2 != -2) {
                    if (n == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }

    @Override
    public JsonLocation getTokenLocation() {
        Object object = this._ioContext.getSourceReference();
        return new JsonLocation(object, -1L, -1L, this._tokenInputRow, -1);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        Object object = this._ioContext.getSourceReference();
        return new JsonLocation(object, -1L, -1L, this._currInputRow, -1);
    }

    private static final int pad(int n, int n2) {
        return n2 == 4 ? n : n | -1 << (n2 << 3);
    }
}

