/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson.json;

import shade.ru.endlesscode.rpginventory.jackson.JsonLocation;
import shade.ru.endlesscode.rpginventory.jackson.JsonParseException;
import shade.ru.endlesscode.rpginventory.jackson.JsonParser;
import shade.ru.endlesscode.rpginventory.jackson.JsonStreamContext;
import shade.ru.endlesscode.rpginventory.jackson.io.CharTypes;
import shade.ru.endlesscode.rpginventory.jackson.json.DupDetector;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected DupDetector _dups;
    protected JsonReadContext _child;
    protected String _currentName;
    protected Object _currentValue;
    protected int _lineNr;
    protected int _columnNr;

    public JsonReadContext(JsonReadContext jsonReadContext, DupDetector dupDetector, int n, int n2, int n3) {
        this._parent = jsonReadContext;
        this._dups = dupDetector;
        this._type = n;
        this._lineNr = n2;
        this._columnNr = n3;
        this._index = -1;
    }

    protected void reset(int n, int n2, int n3) {
        this._type = n;
        this._index = -1;
        this._lineNr = n2;
        this._columnNr = n3;
        this._currentName = null;
        this._currentValue = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    public JsonReadContext withDupDetector(DupDetector dupDetector) {
        this._dups = dupDetector;
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public static JsonReadContext createRootContext(int n, int n2, DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, n, n2);
    }

    public static JsonReadContext createRootContext(DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, 1, 0);
    }

    public JsonReadContext createChildArrayContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 1, n, n2);
        } else {
            jsonReadContext.reset(1, n, n2);
        }
        return jsonReadContext;
    }

    public JsonReadContext createChildObjectContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, this._dups == null ? null : this._dups.child(), 2, n, n2);
            return jsonReadContext;
        }
        jsonReadContext.reset(2, n, n2);
        return jsonReadContext;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public JsonReadContext getParent() {
        return this._parent;
    }

    public JsonReadContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public JsonLocation getStartLocation(Object object) {
        long l = -1L;
        return new JsonLocation(object, l, this._lineNr, this._columnNr);
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean expectComma() {
        int n = ++this._index;
        return this._type != 0 && n > 0;
    }

    public void setCurrentName(String string) {
        this._currentName = string;
        if (this._dups != null) {
            this._checkDup(this._dups, string);
        }
    }

    private void _checkDup(DupDetector dupDetector, String string) {
        if (dupDetector.isDup(string)) {
            Object object = dupDetector.getSource();
            throw new JsonParseException(object instanceof JsonParser ? (JsonParser)object : null, "Duplicate field '" + string + "'");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            default: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

