/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson.io;

import java.io.InputStream;
import shade.ru.endlesscode.rpginventory.jackson.io.IOContext;

public final class MergedStream
extends InputStream {
    private final IOContext _ctxt;
    private final InputStream _in;
    private byte[] _b;
    private int _ptr;
    private final int _end;

    public MergedStream(IOContext iOContext, InputStream inputStream, byte[] byArray, int n, int n2) {
        this._ctxt = iOContext;
        this._in = inputStream;
        this._b = byArray;
        this._ptr = n;
        this._end = n2;
    }

    @Override
    public int available() {
        if (this._b != null) {
            return this._end - this._ptr;
        }
        return this._in.available();
    }

    @Override
    public void close() {
        this._free();
        this._in.close();
    }

    @Override
    public void mark(int n) {
        if (this._b == null) {
            this._in.mark(n);
        }
    }

    @Override
    public boolean markSupported() {
        return this._b == null && this._in.markSupported();
    }

    @Override
    public int read() {
        if (this._b != null) {
            int n = this._b[this._ptr++] & 0xFF;
            if (this._ptr >= this._end) {
                this._free();
            }
            return n;
        }
        return this._in.read();
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this._b != null) {
            int n3 = this._end - this._ptr;
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this._b, this._ptr, byArray, n, n2);
            this._ptr += n2;
            if (this._ptr >= this._end) {
                this._free();
            }
            return n2;
        }
        return this._in.read(byArray, n, n2);
    }

    @Override
    public void reset() {
        if (this._b == null) {
            this._in.reset();
        }
    }

    @Override
    public long skip(long l) {
        long l2 = 0L;
        if (this._b != null) {
            int n = this._end - this._ptr;
            if ((long)n > l) {
                this._ptr += (int)l;
                return l;
            }
            this._free();
            l2 += (long)n;
            l -= (long)n;
        }
        if (l > 0L) {
            l2 += this._in.skip(l);
        }
        return l2;
    }

    private void _free() {
        byte[] byArray = this._b;
        if (byArray != null) {
            this._b = null;
            if (this._ctxt != null) {
                this._ctxt.releaseReadIOBuffer(byArray);
            }
        }
    }
}

