/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson.base;

import java.io.IOException;
import shade.ru.endlesscode.rpginventory.jackson.Base64Variant;
import shade.ru.endlesscode.rpginventory.jackson.JsonParseException;
import shade.ru.endlesscode.rpginventory.jackson.JsonParser;
import shade.ru.endlesscode.rpginventory.jackson.JsonStreamContext;
import shade.ru.endlesscode.rpginventory.jackson.JsonToken;
import shade.ru.endlesscode.rpginventory.jackson.io.JsonEOFException;
import shade.ru.endlesscode.rpginventory.jackson.io.NumberInput;
import shade.ru.endlesscode.rpginventory.jackson.util.ByteArrayBuilder;
import shade.ru.endlesscode.rpginventory.jackson.util.VersionUtil;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_HASH = 35;
    protected static final int INT_PERIOD = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase() {
    }

    protected ParserMinimalBase(int n) {
        super(n);
    }

    @Override
    public abstract JsonToken nextToken();

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public int currentTokenId() {
        JsonToken jsonToken = this._currToken;
        return jsonToken == null ? 0 : jsonToken.id();
    }

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public int getCurrentTokenId() {
        JsonToken jsonToken = this._currToken;
        return jsonToken == null ? 0 : jsonToken.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int n) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return 0 == n;
        }
        return jsonToken.id() == n;
    }

    @Override
    public boolean hasToken(JsonToken jsonToken) {
        return this._currToken == jsonToken;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public JsonToken nextValue() {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n;
                continue;
            }
            if (jsonToken.isStructEnd() && --n == 0) break;
        }
        return this;
    }

    protected abstract void _handleEOF();

    @Override
    public abstract String getCurrentName();

    @Override
    public abstract void close();

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract JsonStreamContext getParsingContext();

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public abstract void overrideCurrentName(String var1);

    @Override
    public abstract String getText();

    @Override
    public abstract char[] getTextCharacters();

    @Override
    public abstract boolean hasTextCharacters();

    @Override
    public abstract int getTextLength();

    @Override
    public abstract int getTextOffset();

    @Override
    public abstract byte[] getBinaryValue(Base64Variant var1);

    @Override
    public boolean getValueAsBoolean(boolean bl) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText().trim();
                    if ("true".equals(string)) {
                        return true;
                    }
                    if ("false".equals(string)) {
                        return false;
                    }
                    if (!this._hasTextualNull(string)) break;
                    return false;
                }
                case 7: {
                    return this.getIntValue() != 0;
                }
                case 9: {
                    return true;
                }
                case 10: 
                case 11: {
                    return false;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object;
                }
            }
        }
        return bl;
    }

    @Override
    public int getValueAsInt() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        return this.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt(string, n);
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).intValue();
                }
            }
        }
        return n;
    }

    @Override
    public long getValueAsLong() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        return this.getValueAsLong(0L);
    }

    @Override
    public long getValueAsLong(long l) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong(string, l);
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).longValue();
                }
            }
        }
        return l;
    }

    @Override
    public double getValueAsDouble(double d) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0.0;
                    }
                    return NumberInput.parseAsDouble(string, d);
                }
                case 7: 
                case 8: {
                    return this.getDoubleValue();
                }
                case 9: {
                    return 1.0;
                }
                case 10: 
                case 11: {
                    return 0.0;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).doubleValue();
                }
            }
        }
        return d;
    }

    @Override
    public String getValueAsString() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return this.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return string;
        }
        return this.getText();
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) {
        try {
            base64Variant.decode(string, byteArrayBuilder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._reportError(illegalArgumentException.getMessage());
        }
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected void _reportUnexpectedChar(int n, String string) {
        if (n < 0) {
            this._reportInvalidEOF();
        }
        String string2 = "Unexpected character (" + ParserMinimalBase._getCharDesc(n) + ")";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void _reportInvalidEOF() {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken), this._currToken);
    }

    protected void _reportInvalidEOFInValue(JsonToken jsonToken) {
        String string = jsonToken == JsonToken.VALUE_STRING ? " in a String value" : (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT ? " in a Number value" : " in a value");
        this._reportInvalidEOF(string, jsonToken);
    }

    protected void _reportInvalidEOF(String string, JsonToken jsonToken) {
        throw new JsonEOFException((JsonParser)this, jsonToken, "Unexpected end-of-input" + string);
    }

    @Deprecated
    protected void _reportInvalidEOFInValue() {
        this._reportInvalidEOF(" in a value");
    }

    @Deprecated
    protected void _reportInvalidEOF(String string) {
        throw new JsonEOFException((JsonParser)this, null, "Unexpected end-of-input" + string);
    }

    protected void _reportMissingRootWS(int n) {
        this._reportUnexpectedChar(n, "Expected space separating root-level values");
    }

    protected void _throwInvalidSpace(int n) {
        char c = (char)n;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(string);
    }

    protected void _throwUnquotedSpace(int n, String string) {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n > 32) {
            char c = (char)n;
            String string2 = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char c) {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c;
        }
        if (c == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return c;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(c));
        return c;
    }

    protected static final String _getCharDesc(int n) {
        char c = (char)n;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + n + ")";
        }
        if (n > 255) {
            return "'" + c + "' (code " + n + " / 0x" + Integer.toHexString(n) + ")";
        }
        return "'" + c + "' (code " + n + ")";
    }

    protected final void _reportError(String string) {
        throw this._constructError(string);
    }

    protected final void _wrapError(String string, Throwable throwable) {
        throw this._constructError(string, throwable);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final JsonParseException _constructError(String string, Throwable throwable) {
        return new JsonParseException((JsonParser)this, string, throwable);
    }

    protected static byte[] _asciiBytes(String string) {
        byte[] byArray = new byte[string.length()];
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    protected static String _ascii(byte[] byArray) {
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

