/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson.base;

import java.io.InputStream;
import java.math.BigDecimal;
import shade.ru.endlesscode.rpginventory.jackson.Base64Variant;
import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.jackson.JsonStreamContext;
import shade.ru.endlesscode.rpginventory.jackson.ObjectCodec;
import shade.ru.endlesscode.rpginventory.jackson.PrettyPrinter;
import shade.ru.endlesscode.rpginventory.jackson.SerializableString;
import shade.ru.endlesscode.rpginventory.jackson.TreeNode;
import shade.ru.endlesscode.rpginventory.jackson.Version;
import shade.ru.endlesscode.rpginventory.jackson.json.DupDetector;
import shade.ru.endlesscode.rpginventory.jackson.json.JsonWriteContext;
import shade.ru.endlesscode.rpginventory.jackson.json.PackageVersion;
import shade.ru.endlesscode.rpginventory.jackson.util.DefaultPrettyPrinter;

public abstract class GeneratorBase
extends JsonGenerator {
    public static final int SURR1_FIRST = 55296;
    public static final int SURR1_LAST = 56319;
    public static final int SURR2_FIRST = 56320;
    public static final int SURR2_LAST = 57343;
    protected static final int DERIVED_FEATURES_MASK = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.getMask() | JsonGenerator.Feature.ESCAPE_NON_ASCII.getMask() | JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.getMask();
    protected static final String WRITE_BINARY = "write a binary value";
    protected static final String WRITE_BOOLEAN = "write a boolean value";
    protected static final String WRITE_NULL = "write a null";
    protected static final String WRITE_NUMBER = "write a number";
    protected static final String WRITE_RAW = "write a raw (unencoded) value";
    protected static final String WRITE_STRING = "write a string";
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected ObjectCodec _objectCodec;
    protected int _features;
    protected boolean _cfgNumbersAsStrings;
    protected JsonWriteContext _writeContext;
    protected boolean _closed;

    protected GeneratorBase(int n, ObjectCodec objectCodec) {
        this._features = n;
        this._objectCodec = objectCodec;
        DupDetector dupDetector = JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector(this) : null;
        this._writeContext = JsonWriteContext.createRootContext(dupDetector);
        this._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n);
    }

    protected GeneratorBase(int n, ObjectCodec objectCodec, JsonWriteContext jsonWriteContext) {
        this._features = n;
        this._objectCodec = objectCodec;
        this._writeContext = jsonWriteContext;
        this._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public Object getCurrentValue() {
        return this._writeContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._writeContext.setCurrentValue(object);
    }

    @Override
    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._features & feature.getMask()) != 0;
    }

    @Override
    public int getFeatureMask() {
        return this._features;
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        int n = feature.getMask();
        this._features |= n;
        if ((n & DERIVED_FEATURES_MASK) != 0) {
            if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
                this._cfgNumbersAsStrings = true;
            } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
                this.setHighestNonEscapedChar(127);
            } else if (feature == JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION && this._writeContext.getDupDetector() == null) {
                this._writeContext = this._writeContext.withDupDetector(DupDetector.rootDetector(this));
            }
        }
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        int n = feature.getMask();
        this._features &= ~n;
        if ((n & DERIVED_FEATURES_MASK) != 0) {
            if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
                this._cfgNumbersAsStrings = false;
            } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
                this.setHighestNonEscapedChar(0);
            } else if (feature == JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION) {
                this._writeContext = this._writeContext.withDupDetector(null);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n) {
        int n2 = n ^ this._features;
        this._features = n;
        if (n2 != 0) {
            this._checkStdFeatureChanges(n, n2);
        }
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n, int n2) {
        int n3 = this._features;
        int n4 = n3 & ~n2 | n & n2;
        int n5 = n3 ^ n4;
        if (n5 != 0) {
            this._features = n4;
            this._checkStdFeatureChanges(n4, n5);
        }
        return this;
    }

    protected void _checkStdFeatureChanges(int n, int n2) {
        if ((n2 & DERIVED_FEATURES_MASK) == 0) {
            return;
        }
        this._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n);
        if (JsonGenerator.Feature.ESCAPE_NON_ASCII.enabledIn(n2)) {
            if (JsonGenerator.Feature.ESCAPE_NON_ASCII.enabledIn(n)) {
                this.setHighestNonEscapedChar(127);
            } else {
                this.setHighestNonEscapedChar(0);
            }
        }
        if (JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2)) {
            if (JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n)) {
                if (this._writeContext.getDupDetector() == null) {
                    this._writeContext = this._writeContext.withDupDetector(DupDetector.rootDetector(this));
                }
            } else {
                this._writeContext = this._writeContext.withDupDetector(null);
            }
        }
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        if (this.getPrettyPrinter() != null) {
            return this;
        }
        return this.setPrettyPrinter(this._constructDefaultPrettyPrinter());
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public void writeStartObject(Object object) {
        this.writeStartObject();
        if (this._writeContext != null && object != null) {
            this._writeContext.setCurrentValue(object);
        }
        this.setCurrentValue(object);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        this.writeFieldName(serializableString.getValue());
    }

    @Override
    public void writeString(SerializableString serializableString) {
        this.writeString(serializableString.getValue());
    }

    @Override
    public void writeRawValue(String string) {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string);
    }

    @Override
    public void writeRawValue(String string, int n, int n2) {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string, n, n2);
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) {
        this._verifyValueWrite("write raw value");
        this.writeRaw(cArray, n, n2);
    }

    @Override
    public void writeRawValue(SerializableString serializableString) {
        this._verifyValueWrite("write raw value");
        this.writeRaw(serializableString);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) {
        this._reportUnsupportedOperation();
        return 0;
    }

    @Override
    public void writeObject(Object object) {
        if (object == null) {
            this.writeNull();
        } else {
            if (this._objectCodec != null) {
                this._objectCodec.writeValue(this, object);
                return;
            }
            this._writeSimpleObject(object);
        }
    }

    @Override
    public void writeTree(TreeNode treeNode) {
        if (treeNode == null) {
            this.writeNull();
        } else {
            if (this._objectCodec == null) {
                throw new IllegalStateException("No ObjectCodec defined");
            }
            this._objectCodec.writeValue(this, treeNode);
        }
    }

    @Override
    public abstract void flush();

    @Override
    public void close() {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    protected abstract void _releaseBuffers();

    protected abstract void _verifyValueWrite(String var1);

    protected PrettyPrinter _constructDefaultPrettyPrinter() {
        return new DefaultPrettyPrinter();
    }

    protected String _asString(BigDecimal bigDecimal) {
        if (JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._features)) {
            int n = bigDecimal.scale();
            if (n < -9999 || n > 9999) {
                this._reportError(String.format("Attempt to write plain `java.math.BigDecimal` (see JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) with illegal scale (%d): needs to be between [-%d, %d]", n, 9999, 9999));
            }
            return bigDecimal.toPlainString();
        }
        return bigDecimal.toString();
    }

    protected final int _decodeSurrogate(int n, int n2) {
        if (n2 < 56320 || n2 > 57343) {
            String string = "Incomplete surrogate pair: first char 0x" + Integer.toHexString(n) + ", second 0x" + Integer.toHexString(n2);
            this._reportError(string);
        }
        int n3 = 65536 + (n - 55296 << 10) + (n2 - 56320);
        return n3;
    }
}

