/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.jackson;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import shade.ru.endlesscode.rpginventory.jackson.Base64Variant;
import shade.ru.endlesscode.rpginventory.jackson.Base64Variants;
import shade.ru.endlesscode.rpginventory.jackson.FormatSchema;
import shade.ru.endlesscode.rpginventory.jackson.JsonLocation;
import shade.ru.endlesscode.rpginventory.jackson.JsonParseException;
import shade.ru.endlesscode.rpginventory.jackson.JsonStreamContext;
import shade.ru.endlesscode.rpginventory.jackson.JsonToken;
import shade.ru.endlesscode.rpginventory.jackson.ObjectCodec;
import shade.ru.endlesscode.rpginventory.jackson.SerializableString;
import shade.ru.endlesscode.rpginventory.jackson.TreeNode;
import shade.ru.endlesscode.rpginventory.jackson.Version;
import shade.ru.endlesscode.rpginventory.jackson.Versioned;
import shade.ru.endlesscode.rpginventory.jackson.type.TypeReference;
import shade.ru.endlesscode.rpginventory.jackson.util.RequestPayload;

public abstract class JsonParser
implements Closeable,
Versioned {
    private static final int MIN_BYTE_I = -128;
    private static final int MAX_BYTE_I = 255;
    private static final int MIN_SHORT_I = Short.MIN_VALUE;
    private static final int MAX_SHORT_I = Short.MAX_VALUE;
    protected int _features;
    protected transient RequestPayload _requestPayload;

    protected JsonParser() {
    }

    protected JsonParser(int n) {
        this._features = n;
    }

    public abstract ObjectCodec getCodec();

    public abstract void setCodec(ObjectCodec var1);

    public Object getInputSource() {
        return null;
    }

    public Object getCurrentValue() {
        JsonStreamContext jsonStreamContext = this.getParsingContext();
        return jsonStreamContext == null ? null : jsonStreamContext.getCurrentValue();
    }

    public void setCurrentValue(Object object) {
        JsonStreamContext jsonStreamContext = this.getParsingContext();
        if (jsonStreamContext != null) {
            jsonStreamContext.setCurrentValue(object);
        }
    }

    public void setRequestPayloadOnError(RequestPayload requestPayload) {
        this._requestPayload = requestPayload;
    }

    public void setRequestPayloadOnError(byte[] byArray, String string) {
        this._requestPayload = byArray == null ? null : new RequestPayload(byArray, string);
    }

    public void setRequestPayloadOnError(String string) {
        this._requestPayload = string == null ? null : new RequestPayload(string);
    }

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Parser of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    @Override
    public abstract Version version();

    @Override
    public abstract void close();

    public int releaseBuffered(OutputStream outputStream) {
        return -1;
    }

    public int releaseBuffered(Writer writer) {
        return -1;
    }

    public JsonParser enable(Feature feature) {
        this._features |= feature.getMask();
        return this;
    }

    public JsonParser disable(Feature feature) {
        this._features &= ~feature.getMask();
        return this;
    }

    public JsonParser configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(Feature feature) {
        return feature.enabledIn(this._features);
    }

    public int getFeatureMask() {
        return this._features;
    }

    @Deprecated
    public JsonParser setFeatureMask(int n) {
        this._features = n;
        return this;
    }

    public JsonParser overrideStdFeatures(int n, int n2) {
        int n3 = this._features & ~n2 | n & n2;
        return this.setFeatureMask(n3);
    }

    public int getFormatFeatures() {
        return 0;
    }

    public JsonParser overrideFormatFeatures(int n, int n2) {
        throw new IllegalArgumentException("No FormatFeatures defined for parser of type " + this.getClass().getName());
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public boolean nextFieldName(SerializableString serializableString) {
        return this.nextToken() == JsonToken.FIELD_NAME && serializableString.getValue().equals(this.getCurrentName());
    }

    public String nextFieldName() {
        return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
    }

    public String nextTextValue() {
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int n) {
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n;
    }

    public long nextLongValue(long l) {
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l;
    }

    public Boolean nextBooleanValue() {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    public abstract JsonParser skipChildren();

    public void finishToken() {
    }

    public abstract boolean isClosed();

    public JsonToken currentToken() {
        return this.getCurrentToken();
    }

    public int currentTokenId() {
        return this.getCurrentTokenId();
    }

    public abstract JsonToken getCurrentToken();

    public abstract int getCurrentTokenId();

    public abstract boolean hasCurrentToken();

    public abstract boolean hasTokenId(int var1);

    public abstract boolean hasToken(JsonToken var1);

    public abstract String getCurrentName();

    public abstract JsonStreamContext getParsingContext();

    public abstract JsonLocation getTokenLocation();

    public abstract JsonLocation getCurrentLocation();

    public boolean isExpectedStartArrayToken() {
        return this.currentToken() == JsonToken.START_ARRAY;
    }

    public boolean isExpectedStartObjectToken() {
        return this.currentToken() == JsonToken.START_OBJECT;
    }

    public abstract void clearCurrentToken();

    public abstract JsonToken getLastClearedToken();

    public abstract void overrideCurrentName(String var1);

    public abstract String getText();

    public int getText(Writer writer) {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        writer.write(string);
        return string.length();
    }

    public abstract char[] getTextCharacters();

    public abstract int getTextLength();

    public abstract int getTextOffset();

    public abstract boolean hasTextCharacters();

    public abstract Number getNumberValue();

    public abstract NumberType getNumberType();

    public byte getByteValue() {
        int n = this.getIntValue();
        if (n < -128 || n > 255) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java byte");
        }
        return (byte)n;
    }

    public short getShortValue() {
        int n = this.getIntValue();
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java short");
        }
        return (short)n;
    }

    public abstract int getIntValue();

    public abstract long getLongValue();

    public abstract BigInteger getBigIntegerValue();

    public abstract float getFloatValue();

    public abstract double getDoubleValue();

    public abstract BigDecimal getDecimalValue();

    public boolean getBooleanValue() {
        JsonToken jsonToken = this.currentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        throw new JsonParseException(this, String.format("Current token (%s) not of boolean type", new Object[]{jsonToken})).withRequestPayload(this._requestPayload);
    }

    public Object getEmbeddedObject() {
        return null;
    }

    public abstract byte[] getBinaryValue(Base64Variant var1);

    public byte[] getBinaryValue() {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    public int readBinaryValue(OutputStream outputStream) {
        return this.readBinaryValue(Base64Variants.getDefaultVariant(), outputStream);
    }

    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        this._reportUnsupportedOperation();
        return 0;
    }

    public int getValueAsInt() {
        return this.getValueAsInt(0);
    }

    public int getValueAsInt(int n) {
        return n;
    }

    public long getValueAsLong() {
        return this.getValueAsLong(0L);
    }

    public long getValueAsLong(long l) {
        return l;
    }

    public double getValueAsDouble() {
        return this.getValueAsDouble(0.0);
    }

    public double getValueAsDouble(double d) {
        return d;
    }

    public boolean getValueAsBoolean() {
        return this.getValueAsBoolean(false);
    }

    public boolean getValueAsBoolean(boolean bl) {
        return bl;
    }

    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    public abstract String getValueAsString(String var1);

    public boolean canReadObjectId() {
        return false;
    }

    public boolean canReadTypeId() {
        return false;
    }

    public Object getObjectId() {
        return null;
    }

    public Object getTypeId() {
        return null;
    }

    public <T> T readValueAs(Class<T> clazz) {
        return this._codec().readValue(this, clazz);
    }

    public <T> T readValueAs(TypeReference<?> typeReference) {
        return this._codec().readValue(this, typeReference);
    }

    public <T> Iterator<T> readValuesAs(Class<T> clazz) {
        return this._codec().readValues(this, clazz);
    }

    public <T> Iterator<T> readValuesAs(TypeReference<?> typeReference) {
        return this._codec().readValues(this, typeReference);
    }

    public <T extends TreeNode> T readValueAsTree() {
        return this._codec().readTree(this);
    }

    protected ObjectCodec _codec() {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for parser, needed for deserialization");
        }
        return objectCodec;
    }

    protected JsonParseException _constructError(String string) {
        return new JsonParseException(this, string).withRequestPayload(this._requestPayload);
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by parser of type " + this.getClass().getName());
    }

    public static enum Feature {
        AUTO_CLOSE_SOURCE(true),
        ALLOW_COMMENTS(false),
        ALLOW_YAML_COMMENTS(false),
        ALLOW_UNQUOTED_FIELD_NAMES(false),
        ALLOW_SINGLE_QUOTES(false),
        ALLOW_UNQUOTED_CONTROL_CHARS(false),
        ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER(false),
        ALLOW_NUMERIC_LEADING_ZEROS(false),
        ALLOW_NON_NUMERIC_NUMBERS(false),
        STRICT_DUPLICATE_DETECTION(false),
        IGNORE_UNDEFINED(false),
        ALLOW_MISSING_VALUES(false);

        private final boolean _defaultState;
        private final int _mask = 1 << this.ordinal();

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int n) {
            return (n & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }

    public static enum NumberType {
        INT,
        LONG,
        BIG_INTEGER,
        FLOAT,
        DOUBLE,
        BIG_DECIMAL;

    }
}

