/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.inspector.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;
import shade.ru.endlesscode.rpginventory.kotlin.text.StringsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a$\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\r\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0005\u001a\u0012\u0010\u0013\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0005\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"rootCause", "", "getRootCause", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "stackTraceText", "", "getStackTraceText", "(Ljava/lang/Throwable;)Ljava/lang/String;", "appendLine", "", "Ljava/lang/StringBuilder;", "Lshade/ru/endlesscode/rpginventory/kotlin/text/StringBuilder;", "text", "prefix", "appendSkipCount", "skipCount", "", "getFocusedRootStackTrace", "focusedPackage", "getFocusedStackTrace", "similarTo", "", "other", "inspector-api"})
public final class ExceptionsKt {
    @NotNull
    public static final String getStackTraceText(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull(throwable, "receiver$0");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = stringWriter.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sw.toString()");
        return string;
    }

    @NotNull
    public static final String getFocusedRootStackTrace(@NotNull Throwable throwable, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull(throwable, "receiver$0");
        Intrinsics.checkParameterIsNotNull(string, "focusedPackage");
        return ExceptionsKt.getFocusedStackTrace(ExceptionsKt.getRootCause(throwable), string);
    }

    @NotNull
    public static final Throwable getRootCause(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull(throwable, "receiver$0");
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null || (throwable2 = ExceptionsKt.getRootCause(throwable2)) == null) {
            throwable2 = throwable;
        }
        return throwable2;
    }

    public static final boolean similarTo(@NotNull Throwable throwable, @NotNull Throwable throwable2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(throwable, "receiver$0");
        Intrinsics.checkParameterIsNotNull(throwable2, "other");
        Object[] objectArray = throwable.getStackTrace();
        if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = throwable2.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull(objectArray3, "other.stackTrace");
            Object[] objectArray4 = objectArray3;
            bl = Arrays.equals(objectArray2, objectArray4);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String getFocusedStackTrace(@NotNull Throwable throwable, @NotNull String string) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(throwable, "receiver$0");
        Intrinsics.checkParameterIsNotNull(string, "focusedPackage");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append(throwable.getClass().getName());
        stringBuilder2.append(": ");
        ExceptionsKt.appendLine$default(stringBuilder2, throwable.getLocalizedMessage(), null, 2, null);
        int n = 0;
        boolean bl2 = false;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n2 = stackTraceElementArray.length;
        for (int i = 0; i < n2; ++i) {
            StackTraceElement serializable;
            StackTraceElement stackTraceElement = serializable = stackTraceElementArray[i];
            Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "element");
            String string2 = stackTraceElement.getClassName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "element.className");
            if (StringsKt.startsWith$default(string2, string + '.', false, 2, null)) {
                ExceptionsKt.appendSkipCount(stringBuilder2, n);
                ExceptionsKt.appendLine(stringBuilder2, serializable.toString(), "  at ");
                n = 0;
                bl2 = true;
                continue;
            }
            if (!bl2) {
                ExceptionsKt.appendLine(stringBuilder2, serializable.toString(), "  at ");
                continue;
            }
            ++n;
        }
        ExceptionsKt.appendSkipCount(stringBuilder2, n);
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            Throwable throwable3;
            Throwable serializable2 = throwable3 = throwable2;
            boolean bl3 = false;
            stringBuilder2.append(ExceptionsKt.getFocusedStackTrace(serializable2, string));
        }
        stringBuilder2.setLength(stringBuilder2.length() - 1);
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    private static final void appendLine(@NotNull StringBuilder stringBuilder, String string, String string2) {
        CharSequence charSequence = string2;
        if (charSequence.length() > 0) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string);
        stringBuilder.append("\n");
    }

    static /* synthetic */ void appendLine$default(StringBuilder stringBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        ExceptionsKt.appendLine(stringBuilder, string, string2);
    }

    private static final void appendSkipCount(@NotNull StringBuilder stringBuilder, int n) {
        if (n > 0) {
            stringBuilder.append("  <skipped ");
            stringBuilder.append(n);
            stringBuilder.append(" lines>\n");
        }
    }
}

