/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler;

import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.TypeCastException;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lshade/ru/endlesscode/rpginventory/inspector/bukkit/scheduler/TrackedBukkitRunnable;", "Lorg/bukkit/scheduler/BukkitRunnable;", "()V", "task", "Lorg/bukkit/scheduler/BukkitTask;", "checkNotYetScheduled", "", "checkScheduled", "getScheduler", "Lorg/bukkit/scheduler/BukkitScheduler;", "plugin", "Lorg/bukkit/plugin/Plugin;", "getTaskId", "", "isCancelled", "", "runTask", "runTaskAsynchronously", "runTaskLater", "delay", "", "runTaskLaterAsynchronously", "runTaskTimer", "period", "runTaskTimerAsynchronously", "setupTask", "Inspector"})
public abstract class TrackedBukkitRunnable
extends BukkitRunnable {
    private BukkitTask task;

    public synchronized boolean isCancelled() {
        this.checkScheduled();
        BukkitTask bukkitTask = this.task;
        if (bukkitTask == null) {
            Intrinsics.throwNpe();
        }
        return bukkitTask.isCancelled();
    }

    public synchronized int getTaskId() {
        this.checkScheduled();
        BukkitTask bukkitTask = this.task;
        if (bukkitTask == null) {
            Intrinsics.throwNpe();
        }
        return bukkitTask.getTaskId();
    }

    @NotNull
    public synchronized BukkitTask runTask(@NotNull Plugin plugin) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        this.checkNotYetScheduled();
        TrackedBukkitRunnable trackedBukkitRunnable = this;
        if (trackedBukkitRunnable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Runnable");
        }
        BukkitTask bukkitTask = this.getScheduler(plugin).runTask(plugin, (Runnable)((Object)trackedBukkitRunnable));
        Intrinsics.checkExpressionValueIsNotNull(bukkitTask, "getScheduler(plugin).run\u2026plugin, this as Runnable)");
        return this.setupTask(bukkitTask);
    }

    @NotNull
    public synchronized BukkitTask runTaskAsynchronously(@NotNull Plugin plugin) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        this.checkNotYetScheduled();
        TrackedBukkitRunnable trackedBukkitRunnable = this;
        if (trackedBukkitRunnable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Runnable");
        }
        BukkitTask bukkitTask = this.getScheduler(plugin).runTaskAsynchronously(plugin, (Runnable)((Object)trackedBukkitRunnable));
        Intrinsics.checkExpressionValueIsNotNull(bukkitTask, "getScheduler(plugin).run\u2026plugin, this as Runnable)");
        return this.setupTask(bukkitTask);
    }

    @NotNull
    public synchronized BukkitTask runTaskLater(@NotNull Plugin plugin, long l) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        this.checkNotYetScheduled();
        TrackedBukkitRunnable trackedBukkitRunnable = this;
        if (trackedBukkitRunnable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Runnable");
        }
        BukkitTask bukkitTask = this.getScheduler(plugin).runTaskLater(plugin, (Runnable)((Object)trackedBukkitRunnable), l);
        Intrinsics.checkExpressionValueIsNotNull(bukkitTask, "getScheduler(plugin).run\u2026 this as Runnable, delay)");
        return this.setupTask(bukkitTask);
    }

    @NotNull
    public synchronized BukkitTask runTaskLaterAsynchronously(@NotNull Plugin plugin, long l) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        this.checkNotYetScheduled();
        TrackedBukkitRunnable trackedBukkitRunnable = this;
        if (trackedBukkitRunnable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Runnable");
        }
        BukkitTask bukkitTask = this.getScheduler(plugin).runTaskLaterAsynchronously(plugin, (Runnable)((Object)trackedBukkitRunnable), l);
        Intrinsics.checkExpressionValueIsNotNull(bukkitTask, "getScheduler(plugin).run\u2026 this as Runnable, delay)");
        return this.setupTask(bukkitTask);
    }

    @NotNull
    public synchronized BukkitTask runTaskTimer(@NotNull Plugin plugin, long l, long l2) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        this.checkNotYetScheduled();
        TrackedBukkitRunnable trackedBukkitRunnable = this;
        if (trackedBukkitRunnable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Runnable");
        }
        BukkitTask bukkitTask = this.getScheduler(plugin).runTaskTimer(plugin, (Runnable)((Object)trackedBukkitRunnable), l, l2);
        Intrinsics.checkExpressionValueIsNotNull(bukkitTask, "getScheduler(plugin).run\u2026 Runnable, delay, period)");
        return this.setupTask(bukkitTask);
    }

    @NotNull
    public synchronized BukkitTask runTaskTimerAsynchronously(@NotNull Plugin plugin, long l, long l2) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        this.checkNotYetScheduled();
        TrackedBukkitRunnable trackedBukkitRunnable = this;
        if (trackedBukkitRunnable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Runnable");
        }
        BukkitTask bukkitTask = this.getScheduler(plugin).runTaskTimerAsynchronously(plugin, (Runnable)((Object)trackedBukkitRunnable), l, l2);
        Intrinsics.checkExpressionValueIsNotNull(bukkitTask, "getScheduler(plugin).run\u2026 Runnable, delay, period)");
        return this.setupTask(bukkitTask);
    }

    private final BukkitScheduler getScheduler(Plugin plugin) {
        Server server = plugin.getServer();
        Intrinsics.checkExpressionValueIsNotNull(server, "plugin.server");
        BukkitScheduler bukkitScheduler = server.getScheduler();
        if (bukkitScheduler == null) {
            String string = "Scheduler can't be null";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return bukkitScheduler;
    }

    private final void checkScheduled() {
        if (this.task == null) {
            String string = "Not scheduled yet";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void checkNotYetScheduled() {
        BukkitTask bukkitTask = this.task;
        if (bukkitTask != null) {
            BukkitTask bukkitTask2;
            BukkitTask bukkitTask3 = bukkitTask2 = bukkitTask;
            boolean bl = false;
            String string = "Already scheduled as " + bukkitTask3.getTaskId();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final BukkitTask setupTask(BukkitTask bukkitTask) {
        this.task = bukkitTask;
        return bukkitTask;
    }
}

