/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.inspector.bukkit.report;

import java.util.List;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.Inspector;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.report.DataType;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.report.PluginListField;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.util.PluginsKt;
import shade.ru.endlesscode.rpginventory.inspector.report.ListField;
import shade.ru.endlesscode.rpginventory.inspector.report.ReportEnvironment;
import shade.ru.endlesscode.rpginventory.inspector.report.ReportField;
import shade.ru.endlesscode.rpginventory.inspector.report.TextField;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.Pair;
import shade.ru.endlesscode.rpginventory.kotlin.TuplesKt;
import shade.ru.endlesscode.rpginventory.kotlin.collections.ArraysKt;
import shade.ru.endlesscode.rpginventory.kotlin.collections.CollectionsKt;
import shade.ru.endlesscode.rpginventory.kotlin.collections.MapsKt;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.JvmOverloads;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.JvmStatic;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.functions.Function0;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.functions.Function1;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.DefaultConstructorMarker;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lshade/ru/endlesscode/rpginventory/inspector/bukkit/report/BukkitEnvironment;", "Lshade/ru/endlesscode/rpginventory/inspector/report/ReportEnvironment;", "plugin", "Lorg/bukkit/plugin/Plugin;", "properties", "Lshade/ru/endlesscode/rpginventory/inspector/bukkit/report/BukkitEnvironment$Properties;", "(Lorg/bukkit/plugin/Plugin;Lru/endlesscode/inspector/bukkit/report/BukkitEnvironment$Properties;)V", "appVersion", "", "getAppVersion", "()Ljava/lang/String;", "defaultFieldsTags", "", "getDefaultFieldsTags", "()Ljava/util/List;", "fields", "", "Lshade/ru/endlesscode/rpginventory/inspector/report/ReportField;", "getFields", "()Ljava/util/Map;", "inspector", "Lshade/ru/endlesscode/rpginventory/inspector/bukkit/Inspector;", "getInspector", "()Lru/endlesscode/inspector/bukkit/Inspector;", "isInspectorEnabled", "", "()Z", "Companion", "Properties", "Inspector"})
public final class BukkitEnvironment
implements ReportEnvironment {
    @NotNull
    private final Inspector inspector;
    @NotNull
    private final String appVersion;
    @NotNull
    private final Map<String, ReportField> fields;
    @NotNull
    private final List<String> defaultFieldsTags;
    @NotNull
    public static final String TAG_PLUGIN = "Plugin";
    @NotNull
    public static final String TAG_CORE = "Server core";
    @NotNull
    public static final String TAG_PLUGIN_LIST = "Installed plugins";
    @NotNull
    public static final String TAG_INSPECTOR_VERSION = "Inspector version";
    @NotNull
    public static final String TAG_REPORTER_ID = "Reporter ID";
    @NotNull
    private static final Properties DEFAULT_PROPERTIES;
    public static final Companion Companion;

    @NotNull
    public final Inspector getInspector() {
        return this.inspector;
    }

    @Override
    @NotNull
    public String getAppVersion() {
        return this.appVersion;
    }

    @Override
    @NotNull
    public Map<String, ReportField> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public List<String> getDefaultFieldsTags() {
        return this.defaultFieldsTags;
    }

    @Override
    public boolean isInspectorEnabled() {
        return this.inspector.isEnabled();
    }

    public BukkitEnvironment(final @NotNull Plugin plugin, @NotNull Properties properties) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        Intrinsics.checkParameterIsNotNull(properties, "properties");
        this.inspector = new Inspector(plugin, properties.getConfigName());
        PluginDescriptionFile pluginDescriptionFile = plugin.getDescription();
        Intrinsics.checkExpressionValueIsNotNull(pluginDescriptionFile, "plugin.description");
        String string = pluginDescriptionFile.getVersion();
        Intrinsics.checkExpressionValueIsNotNull(string, "plugin.description.version");
        this.appVersion = string;
        this.defaultFieldsTags = CollectionsKt.listOf(TAG_PLUGIN, TAG_CORE, TAG_PLUGIN_LIST, TAG_INSPECTOR_VERSION, TAG_REPORTER_ID);
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to(TAG_PLUGIN, new TextField(TAG_PLUGIN, PluginsKt.getPrintableForm(plugin), null, null, 12, null));
        StringBuilder stringBuilder = new StringBuilder();
        Server server = plugin.getServer();
        Intrinsics.checkExpressionValueIsNotNull(server, "plugin.server");
        StringBuilder stringBuilder2 = stringBuilder.append(server.getName()).append(" (");
        Server server2 = plugin.getServer();
        Intrinsics.checkExpressionValueIsNotNull(server2, "plugin.server");
        pairArray[1] = TuplesKt.to(TAG_CORE, new TextField(TAG_CORE, stringBuilder2.append(server2.getVersion()).append(')').toString(), null, new Function1<TextField, Boolean>(){

            @Override
            public final boolean invoke(@NotNull TextField textField) {
                Intrinsics.checkParameterIsNotNull(textField, "receiver$0");
                return this.getInspector().shouldSendData(DataType.CORE);
            }
        }, 4, null));
        pairArray[2] = TuplesKt.to(TAG_PLUGIN_LIST, new PluginListField((Function0<? extends List<? extends Plugin>>)new Function0<List<? extends Plugin>>(){

            @Override
            @NotNull
            public final List<Plugin> invoke() {
                Server server = plugin.getServer();
                Intrinsics.checkExpressionValueIsNotNull(server, "plugin.server");
                PluginManager pluginManager = server.getPluginManager();
                Intrinsics.checkExpressionValueIsNotNull(pluginManager, "plugin.server.pluginManager");
                Plugin[] pluginArray = pluginManager.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull(pluginArray, "plugin.server.pluginManager.plugins");
                return ArraysKt.asList(pluginArray);
            }
        }, properties.getInterestPluginsNames(), (Function1<? super ListField<String>, Boolean>)new Function1<ListField<String>, Boolean>(){

            @Override
            public final boolean invoke(@NotNull ListField<String> listField) {
                Intrinsics.checkParameterIsNotNull(listField, "receiver$0");
                return this.getInspector().shouldSendData(DataType.PLUGINS);
            }
        }));
        pairArray[3] = TuplesKt.to(TAG_INSPECTOR_VERSION, new TextField(TAG_INSPECTOR_VERSION, Inspector.Companion.getVersion(), null, null, 12, null));
        String string2 = this.inspector.getServerId().toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "inspector.serverId.toString()");
        pairArray[4] = TuplesKt.to(TAG_REPORTER_ID, new TextField(TAG_REPORTER_ID, string2, null, null, 12, null));
        this.fields = MapsKt.mapOf(pairArray);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_PROPERTIES = new Properties(null, null, 3, null);
    }

    @NotNull
    public static final Properties getDEFAULT_PROPERTIES$Inspector() {
        Companion companion = Companion;
        return DEFAULT_PROPERTIES;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lshade/ru/endlesscode/rpginventory/inspector/bukkit/report/BukkitEnvironment$Properties;", "", "interestPluginsNames", "", "", "configName", "(Ljava/util/List;Ljava/lang/String;)V", "getConfigName", "()Ljava/lang/String;", "getInterestPluginsNames", "()Ljava/util/List;", "Inspector"})
    public static final class Properties {
        @NotNull
        private final List<String> interestPluginsNames;
        @NotNull
        private final String configName;

        @NotNull
        public final List<String> getInterestPluginsNames() {
            return this.interestPluginsNames;
        }

        @NotNull
        public final String getConfigName() {
            return this.configName;
        }

        @JvmOverloads
        public Properties(@NotNull List<String> list, @NotNull String string) {
            Intrinsics.checkParameterIsNotNull(list, "interestPluginsNames");
            Intrinsics.checkParameterIsNotNull(string, "configName");
            this.interestPluginsNames = list;
            this.configName = string;
        }

        @JvmOverloads
        public /* synthetic */ Properties(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                string = "inspector.yml";
            }
            this(list, string);
        }

        @JvmOverloads
        public Properties(@NotNull List<String> list) {
            this(list, null, 2, null);
        }

        @JvmOverloads
        public Properties() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lshade/ru/endlesscode/rpginventory/inspector/bukkit/report/BukkitEnvironment$Companion;", "", "()V", "DEFAULT_PROPERTIES", "Lshade/ru/endlesscode/rpginventory/inspector/bukkit/report/BukkitEnvironment$Properties;", "DEFAULT_PROPERTIES$annotations", "getDEFAULT_PROPERTIES$Inspector", "()Lru/endlesscode/inspector/bukkit/report/BukkitEnvironment$Properties;", "TAG_CORE", "", "TAG_INSPECTOR_VERSION", "TAG_PLUGIN", "TAG_PLUGIN_LIST", "TAG_REPORTER_ID", "Inspector"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void DEFAULT_PROPERTIES$annotations() {
        }

        @NotNull
        public final Properties getDEFAULT_PROPERTIES$Inspector() {
            return DEFAULT_PROPERTIES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

