/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.inspector.bukkit;

import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.Inspector;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.report.DataType;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.util.ConfigurationsKt;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.util.FileUtil;
import shade.ru.endlesscode.rpginventory.kotlin.Lazy;
import shade.ru.endlesscode.rpginventory.kotlin.LazyKt;
import shade.ru.endlesscode.rpginventory.kotlin.Metadata;
import shade.ru.endlesscode.rpginventory.kotlin.TuplesKt;
import shade.ru.endlesscode.rpginventory.kotlin.collections.MapsKt;
import shade.ru.endlesscode.rpginventory.kotlin.io.FilesKt;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.JvmStatic;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.DefaultConstructorMarker;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Intrinsics;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.PropertyReference1Impl;
import shade.ru.endlesscode.rpginventory.kotlin.jvm.internal.Reflection;
import shade.ru.endlesscode.rpginventory.kotlin.reflect.KProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020 J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lshade/ru/endlesscode/rpginventory/inspector/bukkit/Inspector;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "configName", "", "(Lorg/bukkit/plugin/Plugin;Ljava/lang/String;)V", "configFile", "Ljava/io/File;", "globalConfigFile", "(Ljava/io/File;Ljava/io/File;)V", "config", "Lorg/bukkit/configuration/file/YamlConfiguration;", "globalConfig", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "sendData", "", "Lshade/ru/endlesscode/rpginventory/inspector/bukkit/report/DataType;", "serverId", "Ljava/util/UUID;", "getServerId", "()Ljava/util/UUID;", "setServerId", "(Ljava/util/UUID;)V", "readBoolean", "path", "readServerId", "readValuesFromConfig", "", "reload", "shouldSendData", "dataType", "Companion", "Inspector"})
public final class Inspector {
    private boolean isEnabled;
    @NotNull
    private UUID serverId;
    private Map<DataType, Boolean> sendData;
    private final YamlConfiguration globalConfig;
    private final YamlConfiguration config;
    private final File configFile;
    private final File globalConfigFile;
    @NotNull
    private static final String version = "0.8.1";
    private static final Lazy newServerId$delegate;
    public static final Companion Companion;

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final UUID getServerId() {
        return this.serverId;
    }

    public final void setServerId(@NotNull UUID uUID) {
        Intrinsics.checkParameterIsNotNull(uUID, "<set-?>");
        this.serverId = uUID;
    }

    public final void reload() {
        this.globalConfig.load(this.globalConfigFile);
        this.config.load(this.configFile);
        this.readValuesFromConfig();
        this.globalConfig.save(this.globalConfigFile);
        this.config.save(this.configFile);
    }

    public final boolean shouldSendData(@NotNull DataType dataType) {
        Intrinsics.checkParameterIsNotNull((Object)dataType, "dataType");
        return MapsKt.getValue(this.sendData, dataType);
    }

    private final void readValuesFromConfig() {
        this.isEnabled = this.readBoolean("Reporter.enabled");
        Map<DataType, Boolean> map = this.sendData;
        DataType dataType = DataType.CORE;
        Boolean bl = this.readBoolean("Reporter.data.core");
        map.put(dataType, bl);
        map = this.sendData;
        dataType = DataType.PLUGINS;
        bl = this.readBoolean("Reporter.data.plugins");
        map.put(dataType, bl);
        this.serverId = this.readServerId();
    }

    private final boolean readBoolean(String string) {
        return ConfigurationsKt.getBooleanOrPut((FileConfiguration)this.config, string, true) && ConfigurationsKt.getBooleanOrPut((FileConfiguration)this.globalConfig, string, true);
    }

    private final UUID readServerId() {
        return ConfigurationsKt.getUuidOrPut((FileConfiguration)this.globalConfig, "Reporter.server", readServerId.1.INSTANCE);
    }

    public Inspector(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file, "configFile");
        Intrinsics.checkParameterIsNotNull(file2, "globalConfigFile");
        this.configFile = file;
        this.globalConfigFile = file2;
        this.isEnabled = true;
        this.sendData = MapsKt.mutableMapOf(TuplesKt.to(DataType.CORE, true), TuplesKt.to(DataType.PLUGINS, true));
        this.globalConfig = new YamlConfiguration();
        this.config = new YamlConfiguration();
        FileUtil.INSTANCE.createFileIfNotExists(this.globalConfigFile);
        FileUtil.INSTANCE.createFileIfNotExists(this.configFile);
        this.serverId = this.readServerId();
        this.reload();
    }

    public Inspector(@NotNull Plugin plugin, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        Intrinsics.checkParameterIsNotNull(string, "configName");
        File file = plugin.getDataFolder();
        Intrinsics.checkExpressionValueIsNotNull(file, "plugin.dataFolder");
        File file2 = FilesKt.resolve(file, string);
        File file3 = plugin.getDataFolder();
        Intrinsics.checkExpressionValueIsNotNull(file3, "plugin.dataFolder");
        File file4 = file3.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull(file4, "plugin.dataFolder.parentFile");
        this(file2, FilesKt.resolve(file4, "Inspector/config.yml"));
    }

    static {
        Companion = new Companion(null);
        version = version;
        newServerId$delegate = LazyKt.lazy(Companion.newServerId.2.INSTANCE);
    }

    @NotNull
    public static final String getVersion() {
        Companion companion = Companion;
        return version;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lshade/ru/endlesscode/rpginventory/inspector/bukkit/Inspector$Companion;", "", "()V", "newServerId", "Ljava/util/UUID;", "shade.ru.endlesscode.rpginventory.kotlin.jvm.PlatformType", "getNewServerId", "()Ljava/util/UUID;", "newServerId$delegate", "Lshade/ru/endlesscode/rpginventory/kotlin/Lazy;", "version", "", "version$annotations", "getVersion", "()Ljava/lang/String;", "Inspector"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(Companion.class), "newServerId", "getNewServerId()Ljava/util/UUID;"))};
        }

        @JvmStatic
        public static /* synthetic */ void version$annotations() {
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        private final UUID getNewServerId() {
            Lazy lazy = newServerId$delegate;
            Companion companion = Companion;
            KProperty kProperty = $$delegatedProperties[0];
            return (UUID)lazy.getValue();
        }

        private Companion() {
        }

        public static final /* synthetic */ UUID access$getNewServerId$p(Companion companion) {
            return companion.getNewServerId();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

