/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import java.util.Objects;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, "");
    }

    public Version(int n, int n2, int n3, @NotNull String string) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Version can't include negative numbers");
        }
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.qualifier = Objects.requireNonNull(string, "'qualifier' shouldn't be null");
    }

    @NotNull
    public static Version parseVersion(@NotNull String string) {
        String[] stringArray = string.split("-", 2);
        String string2 = stringArray.length > 1 ? stringArray[1] : "";
        stringArray = stringArray[0].split("\\.", 3);
        try {
            int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
            int n2 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 0;
            int n3 = Integer.parseInt(stringArray[0]);
            return new Version(n3, n2, n, string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("Can not parse version string: %s", string), numberFormatException);
        }
    }

    @Override
    public int compareTo(String string) {
        return this.compareTo(Version.parseVersion(string));
    }

    @Override
    public int compareTo(@NotNull Version version) {
        int n = Integer.compare(this.major, version.major);
        if (n != 0 || (n = Integer.compare(this.minor, version.minor)) != 0 || (n = Integer.compare(this.patch, version.patch)) != 0) {
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object || object == null || this.getClass() != object.getClass()) {
            return true;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch && Objects.equals(this.qualifier, version.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.qualifier);
    }

    public String toString() {
        return String.format("%d.%d.%d%s", this.major, this.minor, this.patch, this.qualifier.isEmpty() ? "" : "-" + this.qualifier);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @NotNull
    public String getQualifier() {
        return this.qualifier;
    }

    public int getVersionCode() {
        return this.major * 10000 + this.minor * 100 + this.patch;
    }

    public boolean hasQualifier() {
        return !this.qualifier.isEmpty();
    }
}

