/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.item.ItemStat;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class StringUtils {
    @NotNull
    public static String coloredLine(@NotNull String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    @NotNull
    public static List<String> coloredLines(@Nullable List<String> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(StringUtils.coloredLine(string));
        }
        return arrayList;
    }

    public static String doubleToString(double d) {
        return d == (double)((long)d) ? String.format("%d", (long)d) : String.format("%s", d);
    }

    public static void coloredConsole(String string) {
        Bukkit.getServer().getConsoleSender().sendMessage(string);
    }

    @NotNull
    public static String setPlaceholders(@NotNull Player player, @NotNull String string) {
        if (RPGInventory.isPlaceholderApiHooked()) {
            try {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)string);
            }
            catch (Throwable throwable) {
                Log.w("Can''t set placeholders for line \"{0}\"", string);
                Log.w("Make sure that you use the latest version of PlaceholderAPI.", new Object[0]);
                Log.w(throwable, "If it is, please report about the error to PlaceholderAPI author:", new Object[0]);
                return string;
            }
        }
        return string;
    }

    public static class Placeholders
    extends PlaceholderExpansion {
        public String getIdentifier() {
            return "rpginv";
        }

        public String getAuthor() {
            return "osipxd";
        }

        public String getVersion() {
            return "1.0";
        }

        public boolean canRegister() {
            return true;
        }

        public String onPlaceholderRequest(@Nullable Player player, @NotNull String string) {
            if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
                return null;
            }
            switch (string) {
                case "damage_bonus": {
                    return ItemManager.getModifier(player, ItemStat.StatType.DAMAGE).toString();
                }
                case "bow_damage_bonus": {
                    return ItemManager.getModifier(player, ItemStat.StatType.BOW_DAMAGE).toString();
                }
                case "hand_damage_bonus": {
                    return ItemManager.getModifier(player, ItemStat.StatType.HAND_DAMAGE).toString();
                }
                case "crit_damage_bonus": {
                    return ItemManager.getModifier(player, ItemStat.StatType.CRIT_DAMAGE).toString();
                }
                case "crit_chance": {
                    return ItemManager.getModifier(player, ItemStat.StatType.CRIT_CHANCE).toString();
                }
                case "armor_bonus": {
                    return ItemManager.getModifier(player, ItemStat.StatType.ARMOR).toString();
                }
                case "speed_bonus": {
                    return ItemManager.getModifier(player, ItemStat.StatType.SPEED).toString();
                }
                case "jump_bonus": {
                    return ItemManager.getModifier(player, ItemStat.StatType.JUMP).toString();
                }
            }
            return null;
        }
    }
}

