/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import com.herocraftonline.heroes.Heroes;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import de.tobiyas.racesandclasses.APIs.ClassAPI;
import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import java.util.List;
import java.util.UUID;
import me.baks.rpl.api.API;
import me.leothepro555.skills.database.managers.PlayerInfo;
import me.leothepro555.skills.main.LanguageSupport;
import me.leothepro555.skills.main.Skills;
import me.robin.battlelevels.api.BattleLevelsAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;

public class PlayerUtils {
    public static boolean checkLevel(@NotNull Player player, int n) {
        int n2 = 0;
        switch (RPGInventory.getLevelSystem()) {
            case EXP: {
                n2 = player.getLevel();
                break;
            }
            case SKILLAPI: {
                PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
                n2 = playerData.hasClass() ? playerData.getMainClass().getLevel() : 0;
                break;
            }
            case BATTLELEVELS: {
                n2 = BattleLevelsAPI.getLevel((UUID)player.getUniqueId());
                break;
            }
            case SKILLS: {
                PlayerInfo playerInfo = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)player);
                n2 = playerInfo.getLevel();
                break;
            }
            case HEROES: {
                n2 = Heroes.getInstance().getCharacterManager().getHero(player).getLevel();
                break;
            }
            case RAC: {
                n2 = LevelAPI.getCurrentLevel((Player)player);
                break;
            }
            case RPGPL: {
                n2 = new API().getPlayerLevel(player);
            }
        }
        return n2 >= n;
    }

    public static boolean checkClass(@NotNull Player player, @NotNull List<String> list) {
        String string = "";
        block0 : switch (RPGInventory.getClassSystem()) {
            case PERMISSIONS: {
                for (String string2 : list) {
                    if (!RPGInventory.getPermissions().has(player, "rpginventory.class." + string2)) continue;
                    string = string2;
                    break block0;
                }
                break;
            }
            case SKILLAPI: {
                PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
                if (!playerData.hasClass()) break;
                string = playerData.getMainClass().getData().getName();
                break;
            }
            case SKILLS: {
                PlayerInfo playerInfo = Skills.get().getPlayerDataManager().getOrLoadPlayerInfo((OfflinePlayer)player);
                LanguageSupport.Languages languages = playerInfo.getSkill().getLanguageName();
                string = Skills.getLang().parseFirstString(languages);
                break;
            }
            case HEROES: {
                string = Heroes.getInstance().getCharacterManager().getHero(player).getHeroClass().getName();
                break;
            }
            case RAC: {
                ClassContainer classContainer = ClassAPI.getClassOfPlayer((Player)player);
                string = classContainer == null ? null : classContainer.getDisplayName();
            }
        }
        return list.contains(string);
    }

    public static boolean checkMoney(@NotNull Player player, double d) {
        double d2;
        double d3 = d2 = RPGInventory.economyConnected() ? RPGInventory.getEconomy().getBalance((OfflinePlayer)player) : 0.0;
        if (d2 < d) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.money", StringUtils.doubleToString(d - d2)));
            return false;
        }
        return true;
    }

    public static void updateInventory(final @NotNull Player player) {
        new TrackedBukkitRunnable(){

            public void run() {
                player.updateInventory();
            }
        }.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
    }

    public static void sendMessage(@NotNull Player player, String string) {
        if (InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            PlayerWrapper playerWrapper = InventoryManager.get((OfflinePlayer)player);
            if (playerWrapper.getLastMessage().equals(string)) {
                return;
            }
            playerWrapper.setLastMessage(string);
        }
        player.sendMessage(string);
    }

    public static enum ClassSystem {
        PERMISSIONS("NONE"),
        SKILLAPI("SkillAPI"),
        SKILLS("Skills"),
        HEROES("Heroes"),
        RAC("RacesAndClasses");

        private final String pluginName;

        private ClassSystem(String string2) {
            this.pluginName = string2;
        }

        public String getPluginName() {
            return this.pluginName;
        }
    }

    public static enum LevelSystem {
        EXP("NONE"),
        SKILLAPI("SkillAPI"),
        BATTLELEVELS("BattleLevels"),
        SKILLS("Skills"),
        HEROES("Heroes"),
        RAC("RacesAndClasses"),
        RPGPL("RPGPlayerLeveling");

        private final String pluginName;

        private LevelSystem(String string2) {
            this.pluginName = string2;
        }

        public String getPluginName() {
            return this.pluginName;
        }
    }
}

