/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class NbtFactoryMirror {
    private static StructureModifier<Object> itemStackModifier;

    private NbtFactoryMirror() {
    }

    public static NbtCompound fromItemCompound(ItemStack itemStack) {
        return NbtFactory.asCompound(NbtFactoryMirror.fromItemTag(itemStack));
    }

    public static void setItemTag(ItemStack itemStack, NbtCompound nbtCompound) {
        NbtFactoryMirror.checkItemStack(itemStack);
        StructureModifier<NbtBase<?>> structureModifier = NbtFactoryMirror.getStackModifier(itemStack);
        structureModifier.write(0, (Object)nbtCompound);
    }

    private static NbtWrapper<?> fromItemTag(ItemStack itemStack) {
        NbtFactoryMirror.checkItemStack(itemStack);
        StructureModifier<NbtBase<?>> structureModifier = NbtFactoryMirror.getStackModifier(itemStack);
        NbtBase nbtBase = (NbtBase)structureModifier.read(0);
        if (nbtBase == null) {
            nbtBase = NbtFactory.ofCompound((String)"tag");
            structureModifier.write(0, (Object)nbtBase);
        }
        return NbtFactory.fromBase((NbtBase)nbtBase);
    }

    private static void checkItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            throw new IllegalArgumentException("Stack cannot be NULL.");
        }
        if (!MinecraftReflection.isCraftItemStack((Object)itemStack)) {
            throw new IllegalArgumentException("Stack must be a CraftItemStack.");
        }
        if (itemStack.getType() == Material.AIR) {
            throw new IllegalArgumentException("ItemStacks representing air cannot store NMS information.");
        }
    }

    private static StructureModifier<NbtBase<?>> getStackModifier(ItemStack itemStack) {
        Object object = MinecraftReflection.getMinecraftItemStack((ItemStack)itemStack);
        if (itemStackModifier == null) {
            itemStackModifier = new StructureModifier(object.getClass(), Object.class, false);
        }
        return itemStackModifier.withTarget(object).withType(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter());
    }
}

