/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class LocationUtils {
    private static final List<String> UNSAFE_BLOCK_MATERIALS = Arrays.asList("LADDER", "LAVA", "STATIONARY_LAVA", "LEGACY_STATIONARY_LAVA", "CACTUS", "GREEN_CACTUS", "FIRE");
    private static final Random RANDOM = new Random();

    @Deprecated
    public static Location getLocationNearPlayer(Player player, int n) {
        return LocationUtils.getLocationNearPoint(player.getLocation(), n);
    }

    public static Location getLocationNearPoint(Location location, int n) {
        Block block = location.getBlock();
        ArrayList<Location> arrayList = new ArrayList<Location>();
        World world = location.getWorld();
        for (int i = block.getX() - n; i < block.getX() + n; ++i) {
            for (int j = block.getY() - n; j < block.getY() + n; ++j) {
                for (int k = block.getZ() - n; k < block.getZ() + n; ++k) {
                    Block block2;
                    Location location2 = LocationUtils.getBlockCenter(new Location(world, (double)i, (double)j, (double)k));
                    if (!location2.getBlock().isEmpty() || (block2 = location2.clone().subtract(0.0, 1.0, 0.0).getBlock()).isEmpty() || block2.isLiquid() || !LocationUtils.isSafeLocation(block2.getLocation())) continue;
                    location2.setYaw(-180.0f + RANDOM.nextFloat() * 360.0f);
                    arrayList.add(location2);
                }
            }
        }
        if (arrayList.size() == 0) {
            return LocationUtils.getBlockCenter(block.getLocation().clone());
        }
        return (Location)arrayList.get(RANDOM.nextInt(arrayList.size()));
    }

    public static Location getBlockCenter(Location location) {
        return location.add(0.5, 0.0, 0.5);
    }

    public static boolean isUnderAnyBlockHonestly(@NotNull Location location, double d, int n) {
        for (Block block : LocationUtils.getStandingOn(location, d)) {
            if (!LocationUtils.isUnderAnyBlock(block, n)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Block> getStandingOn(@NotNull Location location, double d) {
        double d2 = d / 2.0;
        ArrayList<Block> arrayList = new ArrayList<Block>(2);
        for (int i = -1; i <= 1; i += 2) {
            for (int j = -1; j <= 1; j += 2) {
                Location location2 = location.clone().add((double)i * d2, 0.0, (double)j * d2);
                Block block = location2.getBlock();
                if (arrayList.contains(block)) continue;
                arrayList.add(block);
            }
        }
        return arrayList;
    }

    public static boolean isUnderAnyBlock(@NotNull Block block, int n) {
        for (int i = 1; i <= n; ++i) {
            Block block2 = block.getRelative(BlockFace.DOWN, i);
            if (block2.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Player> getNearbyPlayers(Location location, double d) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : location.getWorld().getPlayers()) {
            try {
                if (!(player.getLocation().distance(location) <= d)) continue;
                arrayList.add(player);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return arrayList;
    }

    @NotNull
    public static Vector getRandomVector() {
        Vector vector = new Vector();
        vector.setX(0.0 + Math.random() - Math.random());
        vector.setY(Math.random());
        vector.setZ(0.0 + Math.random() - Math.random());
        return vector;
    }

    public static boolean isSafeLocation(@Nullable Location location) {
        return location != null && !UNSAFE_BLOCK_MATERIALS.contains(location.getBlock().getType().name());
    }
}

