/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackManager;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackType;
import ru.endlesscode.rpginventory.item.CustomItem;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.pet.PetFood;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.PetType;
import ru.endlesscode.rpginventory.utils.NbtFactoryMirror;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class ItemUtils {
    public static final String ENTITY_TAG = "EntityTag";
    public static final String BACKPACK_UID_TAG = "backpack.uid";
    public static final String BACKPACK_TAG = "backpack.id";
    public static final String ITEM_TAG = "rpginv.id";
    public static final String FOOD_TAG = "food.id";
    public static final String PET_TAG = "pet.id";

    @NotNull
    public static ItemStack setTag(ItemStack itemStack, @NotNull String string, @NotNull String string2) {
        ItemStack itemStack2 = ItemUtils.toBukkitItemStack(itemStack);
        if (ItemUtils.isEmpty(itemStack2)) {
            return itemStack2;
        }
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack2);
        if (!nbtCompound.containsKey(string)) {
            nbtCompound.put(string, string2);
        }
        NbtFactoryMirror.setItemTag(itemStack2, nbtCompound);
        return itemStack2;
    }

    @NotNull
    public static String getTag(@NotNull ItemStack itemStack, @NotNull String string) {
        return ItemUtils.getTag(itemStack, string, "");
    }

    @NotNull
    public static String getTag(@NotNull ItemStack itemStack, @NotNull String string, @NotNull String string2) {
        ItemStack itemStack2 = ItemUtils.toBukkitItemStack(itemStack);
        if (ItemUtils.isEmpty(itemStack2)) {
            return "";
        }
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack2);
        return nbtCompound.containsKey(string) ? nbtCompound.getString(string) : string2;
    }

    @Contract(value="null, _ -> false")
    public static boolean hasTag(@Nullable ItemStack itemStack, String string) {
        if (ItemUtils.isEmpty(itemStack) || !itemStack.hasItemMeta()) {
            return false;
        }
        ItemStack itemStack2 = ItemUtils.toBukkitItemStack(itemStack.clone());
        if (ItemUtils.isEmpty(itemStack2)) {
            return false;
        }
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack2);
        return nbtCompound.containsKey(string);
    }

    public static boolean isItemHasDurability(ItemStack itemStack) {
        return itemStack.getType().getMaxDurability() > 0;
    }

    @NotNull
    public static ItemStack[] syncItems(ItemStack[] itemStackArray) {
        for (int i = 0; i < itemStackArray.length; ++i) {
            itemStackArray[i] = ItemUtils.syncItem(itemStackArray[i]);
        }
        return itemStackArray;
    }

    @NotNull
    @Contract(value="null -> !null")
    private static ItemStack syncItem(@Nullable ItemStack itemStack) {
        short s;
        if (ItemUtils.isEmpty(itemStack)) {
            return new ItemStack(Material.AIR);
        }
        short s2 = ItemUtils.getDamage(itemStack);
        int n = itemStack.getAmount();
        if (CustomItem.isCustomItem(itemStack)) {
            CustomItem customItem = ItemManager.getCustomItem(itemStack);
            if (customItem == null) {
                return new ItemStack(Material.AIR);
            }
            s = customItem.getTextureDurability();
            itemStack = ItemManager.getItem(ItemUtils.getTag(itemStack, ITEM_TAG));
        } else if (BackpackManager.isBackpack(itemStack)) {
            BackpackType backpackType = BackpackManager.getBackpackType(ItemUtils.getTag(itemStack, BACKPACK_TAG));
            if (backpackType == null) {
                return new ItemStack(Material.AIR);
            }
            s = backpackType.getTextureDurability();
            String string = ItemUtils.getTag(itemStack, BACKPACK_UID_TAG);
            if (!string.isEmpty()) {
                ItemUtils.setTag(itemStack, BACKPACK_UID_TAG, string);
            }
        } else if (PetType.isPetItem(itemStack)) {
            PetType petType = PetManager.getPetFromItem(itemStack);
            if (petType == null) {
                return new ItemStack(Material.AIR);
            }
            s = petType.getTextureDurability();
            long l = PetManager.getDeathTime(itemStack);
            double d = PetManager.getHealth(itemStack, petType.getHealth());
            itemStack = petType.getSpawnItem();
            PetManager.saveDeathTime(itemStack, l);
            PetManager.saveHealth(itemStack, d);
        } else if (PetFood.isFoodItem(itemStack)) {
            PetFood petFood = PetManager.getFoodFromItem(itemStack);
            if (petFood == null) {
                return new ItemStack(Material.AIR);
            }
            s = petFood.getTextureDurability();
            itemStack = petFood.getFoodItem();
        } else {
            return itemStack;
        }
        ItemUtils.setDamage(itemStack, s == -1 ? s2 : s);
        itemStack.setAmount(n);
        return itemStack;
    }

    public static short getDamage(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        return itemMeta == null ? (short)0 : (short)((Damageable)itemMeta).getDamage();
    }

    private static void setDamage(@NotNull ItemStack itemStack, short s) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            ((Damageable)itemMeta).setDamage((int)s);
            itemStack.setItemMeta(itemMeta);
        }
    }

    @Contract(value="null -> true")
    public static boolean isEmpty(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR;
    }

    @Contract(value="null -> false")
    public static boolean isNotEmpty(@Nullable ItemStack itemStack) {
        return itemStack != null && itemStack.getType() != Material.AIR;
    }

    @NotNull
    public static ItemStack toBukkitItemStack(ItemStack itemStack) {
        return MinecraftReflection.getBukkitItemStack((Object)itemStack);
    }
}

