/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.api.InventoryAPI;
import ru.endlesscode.rpginventory.inventory.ArmorType;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.item.CustomItem;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class InventoryUtils {
    public static void heldFreeSlot(@NotNull Player player, int n, SearchType searchType) {
        if (searchType == SearchType.NEXT) {
            for (int i = n + 1; i < n + 9; ++i) {
                int n2 = i % 9;
                if (InventoryManager.isQuickEmptySlot(player.getInventory().getItem(n2))) continue;
                player.getInventory().setHeldItemSlot(n2);
                return;
            }
        } else {
            for (int i = n - 1; i > n - 9; --i) {
                int n3 = (i + 9) % 9;
                if (InventoryManager.isQuickEmptySlot(player.getInventory().getItem(n3))) continue;
                player.getInventory().setHeldItemSlot(n3);
                return;
            }
        }
    }

    @Contract(pure=true)
    public static int getQuickSlot(int n) {
        return n % 9;
    }

    public static boolean playerNeedArmor(Player player, ArmorType armorType) {
        ItemStack itemStack = armorType.getItem(player);
        return ItemUtils.isEmpty(itemStack) && armorType != ArmorType.UNKNOWN;
    }

    public static int getArmorSlotId(Slot slot) {
        switch (slot.getName()) {
            case "helmet": {
                return 5;
            }
            case "chestplate": {
                return 6;
            }
            case "leggings": {
                return 7;
            }
        }
        return 8;
    }

    @NotNull
    public static List<ItemStack> collectEffectiveItems(@NotNull Player player, boolean bl) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(InventoryAPI.getPassiveItems(player));
        Collections.addAll(arrayList, player.getInventory().getArmorContents());
        EntityEquipment entityEquipment = player.getEquipment();
        assert (entityEquipment != null);
        ItemStack itemStack = entityEquipment.getItemInMainHand();
        if (CustomItem.isCustomItem(itemStack) && ItemManager.allowedForPlayer(player, itemStack, bl)) {
            arrayList.add(itemStack);
        }
        if (CustomItem.isCustomItem(itemStack = entityEquipment.getItemInOffHand()) && ItemManager.allowedForPlayer(player, itemStack, bl)) {
            arrayList.add(itemStack);
        }
        return arrayList;
    }

    public static enum SearchType {
        NEXT,
        PREV;

    }
}

