/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import com.comphenix.protocol.utility.MinecraftReflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.PetType;
import ru.endlesscode.rpginventory.utils.LocationUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.inspector.report.Reporter;

public class EntityUtils {
    private static Method craftEntity_getHandle;
    private static Method navigationAbstract_a;
    private static Method entityInsentient_getNavigation;
    private static final Class<?> entityInsentientClass;
    private static final Reporter reporter;

    public static void goPetToPlayer(@NotNull Player player, @NotNull LivingEntity livingEntity) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !player.isOnline() || livingEntity.isDead()) {
            return;
        }
        if (!player.getWorld().getName().equals(livingEntity.getWorld().getName())) {
            PetManager.teleportPet(player, null);
            return;
        }
        Location location = player.getLocation();
        double d = location.distance(livingEntity.getLocation());
        if (d > 20.0 && LocationUtils.isSafeLocation(location)) {
            PetManager.teleportPet(player, null);
        } else if (d < 4.0) {
            return;
        }
        PetType petType = PetManager.getPetFromEntity(livingEntity, (OfflinePlayer)player);
        double d2 = petType == null ? 1.0 : 0.4 / petType.getSpeed();
        try {
            Object obj = entityInsentientClass.cast(craftEntity_getHandle.invoke((Object)livingEntity, new Object[0]));
            Object object = entityInsentient_getNavigation.invoke(obj, new Object[0]);
            navigationAbstract_a.invoke(object, location.getX(), location.getY(), location.getZ(), d2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reporter.report("Error on going pet to player", reflectiveOperationException);
        }
    }

    static {
        entityInsentientClass = MinecraftReflection.getMinecraftClass((String)"EntityInsentient");
        reporter = RPGInventory.getInstance().getReporter();
        try {
            craftEntity_getHandle = MinecraftReflection.getCraftEntityClass().getDeclaredMethod("getHandle", new Class[0]);
            entityInsentient_getNavigation = entityInsentientClass.getDeclaredMethod("getNavigation", new Class[0]);
            navigationAbstract_a = MinecraftReflection.getMinecraftClass((String)"NavigationAbstract").getDeclaredMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reporter.report("Error on EntityUtils initialization", noSuchMethodException);
        }
    }
}

