/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.utils;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.compat.SoundCompat;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.utils.LocationUtils;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;
import shade.ru.endlesscode.rpginventory.packetwrapper.WrapperPlayServerTitle;

public class EffectUtils {
    public static void playParticlesToAll(Particle particle, int n, @NotNull Location location) {
        EffectUtils.playParticlesToAll(particle, n, location, 30.0);
    }

    private static void playParticlesToAll(Particle particle, int n, @NotNull Location location, double d) {
        EffectUtils.playParticlesToAll(particle, n, location, LocationUtils.getRandomVector(), d);
    }

    private static void playParticlesToAll(Particle particle, int n, @NotNull Location location, @NotNull Vector vector, double d) {
        for (Player player : LocationUtils.getNearbyPlayers(location, d)) {
            EffectUtils.playParticles(player, particle, n, location, vector);
        }
    }

    private static void playParticles(Player player, Particle particle, int n, Location location, Vector vector) {
        player.spawnParticle(particle, location, n, vector.getX(), vector.getY(), vector.getZ());
    }

    public static void playSpawnEffect(Entity entity) {
        Location location = entity.getLocation();
        entity.getWorld().playSound(location, SoundCompat.ENDERMAN_TELEPORT.get(), 1.0f, (float)(1.2 + Math.random() * 0.4));
        EffectUtils.playParticlesToAll(Particle.EXPLOSION_LARGE, 3, location);
    }

    public static void playDespawnEffect(Entity entity) {
        Location location = entity.getLocation();
        entity.getWorld().playSound(location, SoundCompat.ENDERMAN_TELEPORT.get(), 1.0f, (float)(0.6 + Math.random() * 0.4));
        EffectUtils.playParticlesToAll(Particle.SMOKE_NORMAL, 3, location);
    }

    public static void showDefaultJoinMessage(Player player) {
        EffectUtils.showJoinMessage(player, "default", null);
    }

    public static boolean showJoinMessage(Player player, String string, @Nullable Runnable runnable) {
        String string2 = "join-messages." + string;
        if (Config.getConfig().getBoolean(string2 + ".enabled", false)) {
            EffectUtils.sendTitle(player, Config.getConfig().getInt("join-messages.delay", 2), Config.getConfig().getString(string2 + ".title"), Config.getConfig().getStringList(string2 + ".text"), runnable);
            return true;
        }
        return false;
    }

    private static void sendTitle(final Player player, int n, String string, final @NotNull List<String> list, final @Nullable Runnable runnable) {
        if (n < 2) {
            n = 2;
        }
        final WrapperPlayServerTitle wrapperPlayServerTitle = new WrapperPlayServerTitle();
        int n2 = (list.size() == 0 ? n : n * list.size()) - 1;
        try {
            WrapperPlayServerTitle wrapperPlayServerTitle2 = new WrapperPlayServerTitle();
            wrapperPlayServerTitle2.setAction(EnumWrappers.TitleAction.RESET);
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, wrapperPlayServerTitle2.getHandle());
            WrapperPlayServerTitle wrapperPlayServerTitle3 = new WrapperPlayServerTitle();
            wrapperPlayServerTitle3.setAction(EnumWrappers.TitleAction.TIMES);
            wrapperPlayServerTitle3.setFadeIn(10);
            wrapperPlayServerTitle3.setFadeOut(10);
            wrapperPlayServerTitle3.setStay(20 * n2);
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, wrapperPlayServerTitle3.getHandle());
            string = StringUtils.coloredLine(StringUtils.setPlaceholders(player, string));
            wrapperPlayServerTitle.setAction(EnumWrappers.TitleAction.TITLE);
            wrapperPlayServerTitle.setTitle(WrappedChatComponent.fromChatMessage((String)StringUtils.coloredLine(string))[0]);
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, wrapperPlayServerTitle.getHandle());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException("Unable to send packet", invocationTargetException);
        }
        new TrackedBukkitRunnable(){
            int line = 0;

            public void run() {
                try {
                    if (this.line == list.size()) {
                        this.cancel();
                        if (runnable != null) {
                            runnable.run();
                        }
                        return;
                    }
                    String string = StringUtils.coloredLine(StringUtils.setPlaceholders(player, (String)list.get(this.line)));
                    wrapperPlayServerTitle.setAction(EnumWrappers.TitleAction.SUBTITLE);
                    wrapperPlayServerTitle.setTitle(WrappedChatComponent.fromChatMessage((String)string)[0]);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, wrapperPlayServerTitle.getHandle());
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new IllegalStateException("Unable to send packet", invocationTargetException);
                }
                ++this.line;
            }
        }.runTaskTimer((Plugin)RPGInventory.getInstance(), 0L, 20 * n);
    }
}

