/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.resourcepack;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

final class ResourcePackValidator {
    private static final String ENDLESSCODE_CLOUD = "cloud.endlesscode.ru";
    private static final String EMPTY_URL = "PUT_YOUR_URL_HERE";
    private static final String EMPTY_HASH = "PUT_YOUR_HASH_HERE";
    private static final String HEADER_LOCATION = "Location";
    private static final String MIME_ZIP = "application/zip";
    private static final String MIME_BINARY = "application/binary";
    private static final int CODE_OK = 200;
    private static final int CODE_MOVED_PERMANENTLY = 301;
    private static final int CODE_FOUND = 302;
    private static final int CODE_TEMPORARY_REDIRECT = 307;
    private static final int CODE_PERMANENT_REDIRECT = 308;
    private final List<String> errors = new ArrayList<String>();

    ResourcePackValidator() {
    }

    @Contract(value="null, _ -> false")
    boolean validateUrlAndHash(String string, String string2) {
        if (!this.isLegalUrl(string)) {
            return false;
        }
        this.checkHashErrors(string2);
        try {
            this.validateUrl(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addErrors(illegalArgumentException.getMessage().split("\n"));
        }
        catch (Exception exception) {
            this.addErrors(exception.toString());
        }
        return true;
    }

    @Contract(value="null -> false")
    private boolean isLegalUrl(String string) {
        if (string == null || EMPTY_URL.equals(string)) {
            this.addErrors("Set 'resource-pack.url' in config or disable it!");
            return false;
        }
        if (string.contains(ENDLESSCODE_CLOUD)) {
            this.addErrors("You should not use EndlessCode's cloud for resource-pack.", "Please, upload resource-pack to own host or use any third-party file hosting", "that can provide direct download link.");
            return false;
        }
        return true;
    }

    private void checkHashErrors(String string) {
        if (string == null || EMPTY_HASH.equals(string)) {
            this.addErrors("Setting 'resource-pack.hash' is missing!", "You should calculate SHA1 hash of RP and paste it into the setting.");
        }
    }

    private void validateUrl(@NotNull String string) {
        HttpURLConnection httpURLConnection;
        HttpURLConnection.setFollowRedirects(false);
        try {
            httpURLConnection = this.getRealConnection(string, false);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Wrong URL: " + malformedURLException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Unknown host: " + unknownHostException.getMessage());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error: " + exception.toString());
        }
        String string2 = httpURLConnection.getURL().toString();
        if (!string2.equals(string)) {
            this.addError(String.format("Link isn't direct. Redirect found!\nTry to replace your link: %s\nBy this link: %s", string, string2));
        }
        if ((httpURLConnection = this.getRealConnection(httpURLConnection.getURL().toString(), true)).getResponseCode() != 200) {
            throw new IllegalArgumentException("Response: " + httpURLConnection.getResponseMessage());
        }
        String string3 = httpURLConnection.getContentType();
        if (!MIME_ZIP.equals(string3) && !MIME_BINARY.equals(string3)) {
            throw new IllegalArgumentException(String.format("MIME type should be '%s' but received '%s'\nPlease provide link to resource pack file, not to download page.", MIME_ZIP, string3));
        }
    }

    @NotNull
    private HttpURLConnection getRealConnection(@NotNull String string, boolean bl) {
        boolean bl2;
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        int n = httpURLConnection.getResponseCode();
        boolean bl3 = n == 301 || n == 308;
        boolean bl4 = bl2 = n == 302 || n == 307;
        if (bl3 || bl && bl2) {
            String string2 = httpURLConnection.getHeaderField(HEADER_LOCATION);
            if (string2.startsWith("/")) {
                string2 = this.getAbsoluteUrl(uRL, string2);
            }
            return this.getRealConnection(string2, bl);
        }
        return httpURLConnection;
    }

    private String getAbsoluteUrl(@NotNull URL uRL, @NotNull String string) {
        String string2 = uRL.getProtocol();
        String string3 = uRL.getHost();
        int n = uRL.getPort();
        if (n == -1) {
            return String.format("%s://%s%s", string2, string3, string);
        }
        return String.format("%s://%s:%d%s", string2, string3, n, string);
    }

    private void addError(@NotNull String string) {
        this.addErrors(string.split("\n"));
    }

    private void addErrors(String ... stringArray) {
        Collections.addAll(this.errors, stringArray);
    }

    @Contract(pure=true)
    List<String> getErrors() {
        return this.errors;
    }
}

