/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.resourcepack;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.resourcepack.ResourcePackValidator;
import ru.endlesscode.rpginventory.utils.EffectUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;
import shade.ru.endlesscode.rpginventory.packetwrapper.WrapperPlayClientResourcePackStatus;
import shade.ru.endlesscode.rpginventory.packetwrapper.WrapperPlayServerResourcePackSend;

public class ResourcePackModule
implements Listener {
    private static final int TICKS_IN_SECOND = 20;
    private final Plugin plugin;
    private final String resourcePackUrl;
    private final String resourcePackHash;
    private final List<UUID> loadList = new ArrayList<UUID>();

    private ResourcePackModule(Plugin plugin, @NotNull String string, String string2) {
        this.plugin = plugin;
        this.resourcePackUrl = string;
        this.resourcePackHash = string2;
    }

    @Nullable
    public static ResourcePackModule init(Plugin plugin) {
        FileConfiguration fileConfiguration = Config.getConfig();
        if (!fileConfiguration.getBoolean("resource-pack.enabled", false)) {
            Log.i("Resource-pack is disabled in config", new Object[0]);
            return null;
        }
        String string = Config.getConfig().getString("resource-pack.url");
        String string2 = Config.getConfig().getString("resource-pack.hash");
        ResourcePackValidator resourcePackValidator = new ResourcePackValidator();
        boolean bl = resourcePackValidator.validateUrlAndHash(string, string2);
        ResourcePackModule.printErrorsIfNotEmpty(resourcePackValidator.getErrors());
        if (!bl) {
            Log.s("Resource-pack can not be enabled", new Object[0]);
            return null;
        }
        ResourcePackModule resourcePackModule = new ResourcePackModule(plugin, string, string2);
        plugin.getServer().getPluginManager().registerEvents((Listener)resourcePackModule, plugin);
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        ResourcePackModule resourcePackModule2 = resourcePackModule;
        resourcePackModule2.getClass();
        protocolManager.addPacketListener((PacketListener)resourcePackModule2.new ResourcePackPacketAdapter(plugin));
        return resourcePackModule;
    }

    private static void printErrorsIfNotEmpty(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        Log.w("", new Object[0]);
        Log.w("######### Something wrong with RP settings! ##########", new Object[0]);
        for (String string : list) {
            Log.w("# {0}", string);
        }
        Log.w("######################################################", new Object[0]);
        Log.w("", new Object[0]);
    }

    public void loadResourcePack(@NotNull Player player, boolean bl) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 1));
        if (bl) {
            this.sendResourcePack(player);
        } else if (InventoryManager.isNewPlayer(player)) {
            if (!EffectUtils.showJoinMessage(player, "rp-info", () -> this.sendResourcePack(player))) {
                this.sendResourcePack(player);
            }
        } else {
            EffectUtils.showDefaultJoinMessage(player);
            this.sendResourcePack(player);
        }
    }

    private void sendResourcePack(final @NotNull Player player) {
        new TrackedBukkitRunnable(){

            public void run() {
                player.setResourcePack(ResourcePackModule.this.resourcePackUrl);
            }
        }.runTaskLater(this.plugin, 20L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onTargetWhenPlayerNotLoaded(@NotNull EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.getTarget() == null || entityTargetLivingEntityEvent.getTarget().getType() != EntityType.PLAYER) {
            return;
        }
        if (!InventoryManager.playerIsLoaded((AnimalTamer)((Player)entityTargetLivingEntityEvent.getTarget()))) {
            entityTargetLivingEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerInteractWhenNotLoaded(@NotNull PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (InventoryManager.isAllowedWorld(player.getWorld()) && !InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.rp.denied"));
            playerInteractEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(@NotNull PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (InventoryManager.isAllowedWorld(player.getWorld()) && !InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
            this.removePlayerFromLoadList(playerQuitEvent.getPlayer());
        }
    }

    private void removePlayerFromLoadList(@NotNull Player player) {
        this.loadList.remove(player.getUniqueId());
    }

    class ResourcePackPacketAdapter
    extends PacketAdapter {
        ResourcePackPacketAdapter(Plugin plugin) {
            super(plugin, new PacketType[]{WrapperPlayClientResourcePackStatus.TYPE, WrapperPlayServerResourcePackSend.TYPE});
        }

        public void onPacketSending(@NotNull PacketEvent packetEvent) {
            WrapperPlayServerResourcePackSend wrapperPlayServerResourcePackSend = new WrapperPlayServerResourcePackSend(packetEvent.getPacket());
            if (!wrapperPlayServerResourcePackSend.getUrl().equals(ResourcePackModule.this.resourcePackUrl)) {
                return;
            }
            wrapperPlayServerResourcePackSend.setHash(ResourcePackModule.this.resourcePackHash);
            Player player = packetEvent.getPlayer();
            ResourcePackModule.this.loadList.add(player.getUniqueId());
        }

        public void onPacketReceiving(@NotNull PacketEvent packetEvent) {
            WrapperPlayClientResourcePackStatus wrapperPlayClientResourcePackStatus = new WrapperPlayClientResourcePackStatus(packetEvent.getPacket());
            Player player = packetEvent.getPlayer();
            if (ResourcePackModule.this.loadList.contains(player.getUniqueId())) {
                switch (wrapperPlayClientResourcePackStatus.getResult()) {
                    case ACCEPTED: {
                        break;
                    }
                    case SUCCESSFULLY_LOADED: {
                        this.onSuccessfullyLoaded(player);
                        break;
                    }
                    case DECLINED: 
                    case FAILED_DOWNLOAD: {
                        this.onFailedOrDeclined(player);
                    }
                }
            }
        }

        private void onSuccessfullyLoaded(final @NotNull Player player) {
            UUID uUID = player.getUniqueId();
            new TrackedBukkitRunnable(){

                public void run() {
                    InventoryManager.loadPlayerInventory(player);
                    player.removePotionEffect(PotionEffectType.BLINDNESS);
                }
            }.runTaskLater(this.plugin, 1L);
            ResourcePackModule.this.loadList.remove(uUID);
        }

        private void onFailedOrDeclined(final @NotNull Player player) {
            new TrackedBukkitRunnable(){

                public void run() {
                    player.kickPlayer(RPGInventory.getLanguage().getMessage("error.rp.denied"));
                }
            }.runTaskLater(this.plugin, 20L);
            ResourcePackModule.this.loadList.remove(player.getUniqueId());
        }
    }
}

