/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.pet.mypet;

import de.Keyle.MyPet.MyPetApi;
import de.Keyle.MyPet.api.WorldGroup;
import de.Keyle.MyPet.api.entity.MyPet;
import de.Keyle.MyPet.api.entity.StoredMyPet;
import de.Keyle.MyPet.api.event.MyPetCallEvent;
import de.Keyle.MyPet.api.event.MyPetCreateEvent;
import de.Keyle.MyPet.api.event.MyPetRemoveEvent;
import de.Keyle.MyPet.api.player.MyPetPlayer;
import de.Keyle.MyPet.api.repository.PlayerManager;
import de.Keyle.MyPet.api.repository.RepositoryCallback;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.compat.MaterialCompat;
import ru.endlesscode.rpginventory.event.PetEquipEvent;
import ru.endlesscode.rpginventory.event.PetUnequipEvent;
import ru.endlesscode.rpginventory.event.PlayerInventoryLoadEvent;
import ru.endlesscode.rpginventory.inventory.ActionType;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;

public class MyPetManager
implements Listener {
    private static final String MYPET_TAG = "mypet.uuid";

    public static boolean init(@NotNull RPGInventory rPGInventory) {
        if (MyPetManager.getMyPetSlot() == null) {
            Log.s("MyPet found, but slot for MyPet not configured!", new Object[0]);
            return false;
        }
        try {
            for (MyPetPlayer myPetPlayer : MyPetApi.getPlayerManager().getMyPetPlayers()) {
                MyPetManager.syncPlayer(myPetPlayer);
            }
            rPGInventory.getServer().getPluginManager().registerEvents((Listener)new MyPetManager(), (Plugin)rPGInventory);
            return true;
        }
        catch (Exception exception) {
            rPGInventory.getReporter().report(exception.getMessage(), exception);
            return false;
        }
    }

    private static void syncPlayer(MyPetPlayer myPetPlayer) {
        Slot slot = MyPetManager.getMyPetSlot();
        if (myPetPlayer.isOnline() && myPetPlayer.hasMyPet()) {
            Player player = myPetPlayer.getPlayer();
            if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || slot == null) {
                return;
            }
            Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
            ItemStack itemStack = inventory.getItem(slot.getSlotId());
            if (MyPetManager.isMyPetItem(itemStack)) {
                MyPet myPet = myPetPlayer.getMyPet();
                String string = ItemUtils.getTag(itemStack, MYPET_TAG);
                if (string.isEmpty()) {
                    return;
                }
                UUID uUID = UUID.fromString(string);
                if (uUID.equals(myPet.getUUID())) {
                    return;
                }
            } else {
                inventory.setItem(slot.getSlotId(), slot.getCup());
            }
            MyPetApi.getMyPetManager().deactivateMyPet(myPetPlayer, false);
        }
    }

    @Nullable
    private static Slot getMyPetSlot() {
        for (Slot slot : SlotManager.instance().getSlots()) {
            if (slot.getSlotType() != Slot.SlotType.PET) continue;
            return slot;
        }
        return null;
    }

    public static boolean validatePet(@NotNull Player player, InventoryAction inventoryAction, @Nullable ItemStack itemStack, ItemStack itemStack2) {
        ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
        boolean bl = actionType == ActionType.GET || inventoryAction == InventoryAction.SWAP_WITH_CURSOR || actionType == ActionType.DROP;
        return !ItemUtils.isNotEmpty(itemStack) || !bl || MyPetManager.swapMyPets(player, MyPetManager.isMyPetItem(itemStack), itemStack2);
    }

    private static boolean swapMyPets(final @NotNull Player player, boolean bl, ItemStack itemStack) {
        PlayerEvent playerEvent;
        if (bl) {
            playerEvent = new PetUnequipEvent(player);
            RPGInventory.getInstance().getServer().getPluginManager().callEvent((Event)playerEvent);
            MyPetManager.deactivateMyPet(player);
        }
        if (!MyPetManager.isMyPetItem(itemStack)) {
            return true;
        }
        playerEvent = new PetEquipEvent(player, itemStack);
        Bukkit.getPluginManager().callEvent((Event)playerEvent);
        if (playerEvent.isCancelled()) {
            return false;
        }
        String string = ItemUtils.getTag(itemStack, MYPET_TAG);
        if (string.isEmpty()) {
            return false;
        }
        final UUID uUID = UUID.fromString(string);
        new TrackedBukkitRunnable(){

            public void run() {
                MyPetManager.activateMyPet(player, uUID);
            }
        }.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
        return true;
    }

    @Contract(value="null -> false")
    private static boolean isMyPetItem(@Nullable ItemStack itemStack) {
        return ItemUtils.isNotEmpty(itemStack) && ItemUtils.hasTag(itemStack, MYPET_TAG);
    }

    private static void deactivateMyPet(@NotNull Player player) {
        if (!MyPetApi.getPlayerManager().isMyPetPlayer(player)) {
            return;
        }
        MyPetPlayer myPetPlayer = MyPetApi.getPlayerManager().getMyPetPlayer(player);
        if (myPetPlayer.hasMyPet()) {
            MyPetApi.getMyPetManager().deactivateMyPet(myPetPlayer, true);
            myPetPlayer.setMyPetForWorldGroup(WorldGroup.getGroupByWorld((String)player.getWorld().getName()).getName(), null);
            MyPetApi.getRepository().updateMyPetPlayer(myPetPlayer, null);
        }
    }

    private static void activateMyPet(final @NotNull Player player, UUID uUID) {
        final MyPetPlayer myPetPlayer = MyPetApi.getPlayerManager().isMyPetPlayer(player) ? MyPetApi.getPlayerManager().getMyPetPlayer(player) : MyPetApi.getPlayerManager().createMyPetPlayer(player);
        if (myPetPlayer.hasMyPet()) {
            MyPetApi.getMyPetManager().deactivateMyPet(myPetPlayer, true);
        }
        final WorldGroup worldGroup = WorldGroup.getGroupByWorld((String)player.getWorld().getName());
        MyPetApi.getRepository().getMyPet(uUID, (RepositoryCallback)new RepositoryCallback<StoredMyPet>(){

            public void callback(@NotNull StoredMyPet storedMyPet) {
                MyPet myPet;
                if (!storedMyPet.getWorldGroup().equals(worldGroup.getName())) {
                    PlayerUtils.sendMessage(player, "This pet doesn't belong into this world.");
                    return;
                }
                boolean bl = storedMyPet.getOwner().getInternalUUID().equals(myPetPlayer.getInternalUUID());
                storedMyPet.setOwner(myPetPlayer);
                String string = player.getWorld().getName();
                myPetPlayer.setMyPetForWorldGroup(WorldGroup.getGroupByWorld((String)string).getName(), storedMyPet.getUUID());
                Optional optional = MyPetManager.activateMyPetCompat(storedMyPet);
                if (optional.isPresent() && (myPet = (MyPet)optional.get()).getStatus() != MyPet.PetState.Dead) {
                    ((MyPet)optional.get()).setStatus(MyPet.PetState.Here);
                }
                if (bl) {
                    MyPetApi.getRepository().updateMyPet(storedMyPet, null);
                }
                MyPetApi.getRepository().updateMyPetPlayer(myPetPlayer, null);
            }
        });
    }

    private static Optional<MyPet> activateMyPetCompat(StoredMyPet storedMyPet) {
        Optional<Object> optional = MyPetApi.getMyPetManager().activateMyPet(storedMyPet);
        Optional<Object> optional2 = optional instanceof com.google.common.base.Optional ? Optional.ofNullable(((com.google.common.base.Optional)optional).orNull()) : optional;
        return optional2;
    }

    @EventHandler
    public void onPlayerInventoryLoaded(@NotNull PlayerInventoryLoadEvent.Post post) {
        Player player = post.getPlayer();
        PlayerManager playerManager = MyPetApi.getPlayerManager();
        if (playerManager.isMyPetPlayer(player)) {
            MyPetManager.syncPlayer(playerManager.getMyPetPlayer(player));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMyPetCreate(@NotNull MyPetCreateEvent myPetCreateEvent) {
        Player player = myPetCreateEvent.getOwner().getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        ItemStack itemStack = new ItemStack(MaterialCompat.getMaterial("MONSTER_EGG"));
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(RPGInventory.getLanguage().getMessage("mypet.egg", myPetCreateEvent.getMyPet().getPetName()));
        itemStack.setItemMeta(itemMeta);
        itemStack = ItemUtils.setTag(itemStack, MYPET_TAG, myPetCreateEvent.getMyPet().getUUID().toString());
        Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        Slot slot = Objects.requireNonNull(MyPetManager.getMyPetSlot(), "MyPet slot should be exist!");
        ItemStack itemStack2 = inventory.getItem(slot.getSlotId());
        boolean bl = itemStack2 != null && !slot.isCup(itemStack2);
        inventory.setItem(slot.getSlotId(), itemStack);
        if (bl) {
            player.getInventory().addItem(new ItemStack[]{itemStack2});
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMyPetCall(@NotNull MyPetCallEvent myPetCallEvent) {
        Player player = myPetCallEvent.getOwner().getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        Slot slot = Objects.requireNonNull(MyPetManager.getMyPetSlot(), "MyPet slot should be exist!");
        ItemStack itemStack = inventory.getItem(slot.getSlotId());
        boolean bl = true;
        if (!MyPetManager.isMyPetItem(itemStack)) {
            bl = false;
        } else {
            String string = ItemUtils.getTag(itemStack, MYPET_TAG);
            if (string.isEmpty()) {
                bl = false;
            } else {
                UUID uUID = UUID.fromString(string);
                if (!uUID.equals(myPetCallEvent.getMyPet().getUUID())) {
                    bl = false;
                }
            }
        }
        if (!bl) {
            myPetCallEvent.setCancelled(true);
            MyPetApi.getMyPetManager().deactivateMyPet(myPetCallEvent.getOwner(), true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMyPetRemove(@NotNull MyPetRemoveEvent myPetRemoveEvent) {
        Slot slot;
        Player player = myPetRemoveEvent.getOwner().getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        ItemStack itemStack = inventory.getItem((slot = Objects.requireNonNull(MyPetManager.getMyPetSlot(), "MyPet slot should be exist!")).getSlotId());
        if (MyPetManager.isMyPetItem(itemStack)) {
            String string = ItemUtils.getTag(itemStack, MYPET_TAG);
            if (string.isEmpty()) {
                inventory.setItem(slot.getSlotId(), slot.getCup());
                return;
            }
            UUID uUID = UUID.fromString(string);
            if (uUID.equals(myPetRemoveEvent.getMyPet().getUUID())) {
                inventory.setItem(slot.getSlotId(), slot.getCup());
            }
        }
    }

    @EventHandler
    public void onMyPetItemUse(@NotNull PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getItem() != null) {
            Player player = playerInteractEvent.getPlayer();
            if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
                return;
            }
            Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
            if (MyPetManager.isMyPetItem(playerInteractEvent.getItem()) && (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR)) {
                ItemStack itemStack;
                Slot slot = Objects.requireNonNull(MyPetManager.getMyPetSlot(), "MyPet slot should be exist!");
                boolean bl = !slot.isCup(itemStack = inventory.getItem(slot.getSlotId()));
                ItemStack itemStack2 = playerInteractEvent.getItem();
                if (!bl) {
                    itemStack = null;
                }
                player.getEquipment().setItemInMainHand(itemStack);
                inventory.setItem(slot.getSlotId(), itemStack2);
                MyPetManager.swapMyPets(player, bl, itemStack2);
            }
        }
    }
}

