/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.pet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.item.ClassedItem;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.misc.FileLanguage;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.SafeEnums;
import ru.endlesscode.rpginventory.utils.StringUtils;
import ru.endlesscode.rpginventory.utils.Utils;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class PetType
extends ClassedItem {
    @NotNull
    private final String name;
    @NotNull
    private final String itemName;
    @NotNull
    private final List<String> lore;
    private final Role role;
    private final EntityType skin;
    private final double health;
    private final double damage;
    private final double speed;
    private final boolean attackMobs;
    private final boolean attackPlayers;
    private final boolean revival;
    private final int cooldown;
    private ItemStack spawnItem;
    private Map<String, String> features;

    PetType(Texture texture, @NotNull ConfigurationSection configurationSection) {
        super(texture, configurationSection);
        this.name = StringUtils.coloredLine(configurationSection.getString("name"));
        this.itemName = StringUtils.coloredLine(configurationSection.getString("item-name"));
        this.lore = StringUtils.coloredLines(configurationSection.getStringList("lore"));
        this.role = SafeEnums.valueOfOrDefault(Role.class, configurationSection.getString("type", "COMPANION"), Role.COMPANION);
        this.skin = this.role.getPossibleSkin(configurationSection.getString("skin"));
        this.health = configurationSection.getDouble("health");
        this.damage = configurationSection.getDouble("damage", 0.0);
        this.speed = configurationSection.getDouble("speed");
        this.attackMobs = configurationSection.getBoolean("attack-mobs", false);
        this.attackPlayers = configurationSection.getBoolean("attack-players", false);
        this.revival = configurationSection.getBoolean("revival", true);
        this.cooldown = this.revival ? configurationSection.getInt("cooldown") : 0;
        this.createSpawnItem(configurationSection.getName());
        this.storeFeatures(configurationSection.getStringList("features"));
    }

    @Contract(value="null -> false")
    public static boolean isPetItem(ItemStack itemStack) {
        return ItemUtils.isNotEmpty(itemStack) && ItemUtils.hasTag(itemStack, "pet.id");
    }

    @Nullable
    public static ItemStack clone(@NotNull ItemStack itemStack) {
        PetType petType = PetManager.getPetFromItem(itemStack);
        if (petType == null) {
            return null;
        }
        ItemStack itemStack2 = petType.getSpawnItem();
        PetManager.saveDeathTime(itemStack2, PetManager.getDeathTime(itemStack));
        PetManager.saveHealth(itemStack2, PetManager.getHealth(itemStack, petType.getHealth()));
        return itemStack2;
    }

    private void storeFeatures(@Nullable List<String> list) {
        Map<String, String> map;
        if (list != null && list.size() > 0) {
            map = new HashMap(list.size());
            for (String string : list) {
                String[] stringArray = string.replaceAll(" ", "").split(":");
                map.put(stringArray[0], stringArray[1]);
            }
        } else {
            map = Collections.emptyMap();
        }
        this.features = map;
    }

    private void createSpawnItem(String string) {
        ItemStack itemStack = this.texture.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.itemName);
        FileLanguage fileLanguage = RPGInventory.getLanguage();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(StringUtils.coloredLine("&8" + fileLanguage.getMessage("pet.role." + this.role.name().toLowerCase())));
        if (this.getLevel() != -1) {
            arrayList.add(fileLanguage.getMessage("item.level", this.getLevel()));
        }
        if (this.getClasses() != null) {
            arrayList.add(fileLanguage.getMessage("item.class", this.getClassesString()));
        }
        arrayList.addAll(this.lore);
        arrayList.add(fileLanguage.getMessage("pet.health", (int)this.health));
        if (this.role == Role.COMPANION && (this.attackMobs || this.attackPlayers)) {
            arrayList.add(fileLanguage.getMessage("pet.damage", (int)this.damage));
        }
        arrayList.add(fileLanguage.getMessage("pet.speed", Utils.round(this.speed, 2)));
        arrayList.add(fileLanguage.getMessage("pet.revival." + (this.revival ? "yes" : "no"), this.cooldown));
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        this.spawnItem = ItemUtils.setTag(itemStack, "pet.id", string);
    }

    public ItemStack getSpawnItem() {
        return this.spawnItem;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public double getHealth() {
        return this.health;
    }

    public boolean isRevival() {
        return this.revival;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public double getSpeed() {
        double d = this.speed * 0.10638297872;
        if (this.role == Role.MOUNT) {
            d /= 4.46808510803;
        }
        if (!this.isAdult()) {
            d /= 1.5;
        }
        return d;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean isAttackPlayers() {
        return this.attackPlayers;
    }

    public boolean isAttackMobs() {
        return this.attackMobs;
    }

    boolean isAdult() {
        return !this.features.containsKey("BABY") || this.features.get("BABY").equals("FALSE");
    }

    public Role getRole() {
        return this.role;
    }

    public Map<String, String> getFeatures() {
        return this.features;
    }

    public EntityType getSkin() {
        return this.skin;
    }

    public static enum Role {
        COMPANION("WOLF", "CAT"),
        MOUNT("HORSE", "PIG");

        private final String defaultSkin;
        @NotNull
        private final List<String> possibleSkins;

        private Role(String ... stringArray) {
            this.defaultSkin = stringArray[0];
            this.possibleSkins = Arrays.asList(stringArray);
        }

        public EntityType getPossibleSkin(String string) {
            String string2 = string;
            if (string2 == null) {
                string2 = this.defaultSkin;
            } else if (!this.possibleSkins.contains(string)) {
                string2 = this.defaultSkin;
            }
            return EntityType.valueOf((String)string2);
        }
    }
}

