/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.pet;

import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Listener;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.compat.MaterialCompat;
import ru.endlesscode.rpginventory.compat.VersionHandler;
import ru.endlesscode.rpginventory.event.listener.PetListener;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.pet.CooldownsTimer;
import ru.endlesscode.rpginventory.pet.PetFood;
import ru.endlesscode.rpginventory.pet.PetType;
import ru.endlesscode.rpginventory.utils.EffectUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.LocationUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.NbtFactoryMirror;
import ru.endlesscode.rpginventory.utils.SafeEnums;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class PetManager {
    private static final String CONFIG_NAME = "pets.yml";
    private static final String METADATA_KEY_PET_OWNER = "rpginventory:petowner";
    private static final Map<String, PetType> PETS = new HashMap<String, PetType>();
    private static final Map<String, PetFood> PET_FOOD = new HashMap<String, PetFood>();
    private static final String DEATH_TIME_TAG = "pet.deathTime";
    private static CooldownsTimer COOLDOWNS_TIMER;
    private static int SLOT_PET;

    private PetManager() {
    }

    public static boolean init(@NotNull RPGInventory rPGInventory) {
        int n = SLOT_PET = SlotManager.instance().getPetSlot() != null ? SlotManager.instance().getPetSlot().getSlotId() : -1;
        if (!PetManager.isEnabled()) {
            Log.i("Slot for pets not found", new Object[0]);
            return false;
        }
        try {
            Object object;
            String string;
            Path path = RPGInventory.getInstance().getDataPath();
            Path path2 = path.resolve(CONFIG_NAME);
            if (Files.notExists(path2, new LinkOption[0])) {
                string = VersionHandler.isLegacy() ? ".legacy" : "";
                object = CONFIG_NAME + string;
                RPGInventory.getInstance().saveResource((String)object, false);
                if (!string.isEmpty()) {
                    Files.move(path.resolve((String)object), path2, new CopyOption[0]);
                }
            }
            if ((object = (string = YamlConfiguration.loadConfiguration((File)path2.toFile())).getConfigurationSection("pets")) == null) {
                Log.s("Section ''pets'' not found in {0}", CONFIG_NAME);
                return false;
            }
            PETS.clear();
            for (Object object2 : object.getKeys(false)) {
                Object object3 = object.getConfigurationSection((String)object2);
                if (object3 == null) continue;
                PetManager.tryToAddPet((String)object2, object3);
            }
            ConfigurationSection configurationSection = string.getConfigurationSection("food");
            if (configurationSection == null) {
                Log.s("Section ''food'' not found in {0}", CONFIG_NAME);
            } else {
                PET_FOOD.clear();
                for (Object object3 : configurationSection.getKeys(false)) {
                    ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection((String)object3);
                    if (configurationSection2 == null) continue;
                    PetManager.tryToAddPetFood((String)object3, configurationSection2);
                }
            }
        }
        catch (Exception exception) {
            rPGInventory.getReporter().report("Error on PetManager initialization", exception);
            return false;
        }
        if (PETS.isEmpty()) {
            Log.i("No one configured pet found", new Object[0]);
            return false;
        }
        Log.i("{0} pet(s) has been loaded", PETS.size());
        Log.i("{0} food(s) has been loaded", PET_FOOD.size());
        rPGInventory.getServer().getPluginManager().registerEvents((Listener)new PetListener(), (Plugin)rPGInventory);
        COOLDOWNS_TIMER = new CooldownsTimer(rPGInventory);
        COOLDOWNS_TIMER.runTaskTimer((Plugin)rPGInventory, 20L, 5L);
        return true;
    }

    private static void tryToAddPet(String string, @NotNull ConfigurationSection configurationSection) {
        try {
            Texture texture = Texture.parseTexture(configurationSection.getString("item"));
            if (texture.isEmpty()) {
                Log.s("Pet ''{0}'' has not been added because its item is not valid.", string);
                return;
            }
            PetType petType = new PetType(texture, configurationSection);
            PETS.put(string, petType);
        }
        catch (Exception exception) {
            Log.s("Pet ''{0}'' can''t be added: {1}", string, exception.toString());
            Log.d(exception);
        }
    }

    private static void tryToAddPetFood(String string, @NotNull ConfigurationSection configurationSection) {
        try {
            Texture texture = Texture.parseTexture(configurationSection.getString("item"));
            if (texture.isEmpty()) {
                Log.s("Pet food ''{0}'' has not been added because its item is not valid.", string);
                return;
            }
            PetFood petFood = new PetFood(texture, configurationSection);
            PET_FOOD.put(string, petFood);
        }
        catch (Exception exception) {
            Log.s("Pet food ''{0}'' can''t be added: {1}", string, exception.toString());
            Log.d(exception);
        }
    }

    public static void initPlayer(@NotNull Player player) {
        if (!PetManager.isEnabled() || !InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        PetManager.respawnPet((OfflinePlayer)player);
    }

    @Contract(pure=true)
    public static boolean isEnabled() {
        return SLOT_PET != -1;
    }

    public static int getPetSlotId() {
        return SLOT_PET;
    }

    @NotNull
    public static List<String> getPetList() {
        return new ArrayList<String>(PETS.keySet());
    }

    @NotNull
    public static List<String> getFoodList() {
        return new ArrayList<String>(PET_FOOD.keySet());
    }

    public static void startCooldownTimer(Player player, ItemStack itemStack) {
        COOLDOWNS_TIMER.addPetCooldown(player, itemStack);
    }

    public static void teleportPet(@NotNull Player player, @Nullable Location location) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !PetManager.isEnabled()) {
            return;
        }
        LivingEntity livingEntity = InventoryManager.get((OfflinePlayer)player).getPet();
        if (livingEntity == null) {
            return;
        }
        Location location2 = location != null ? location : player.getLocation();
        Location location3 = LocationUtils.getLocationNearPoint(location2, 3);
        livingEntity.teleport(location3);
    }

    @Deprecated
    public static void spawnPet(@NotNull Player player, @NotNull ItemStack itemStack) {
        PetManager.respawnPet(player, itemStack);
    }

    public static void respawnPet(@Nullable OfflinePlayer offlinePlayer) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)offlinePlayer) || !PetManager.isEnabled()) {
            return;
        }
        Inventory inventory = InventoryManager.get(offlinePlayer).getInventory();
        ItemStack itemStack = inventory.getItem(SLOT_PET);
        if (itemStack != null) {
            PetManager.respawnPet((Player)offlinePlayer, itemStack);
        }
    }

    public static void respawnPet(@NotNull Player player, @NotNull ItemStack itemStack) {
        HorseInventory horseInventory;
        Horse horse;
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !PetManager.isEnabled()) {
            return;
        }
        PetManager.despawnPet((OfflinePlayer)player);
        PetType petType = PetManager.getPetFromItem(itemStack);
        if (petType == null) {
            return;
        }
        if (PetManager.getCooldown(itemStack) > 0) {
            PetManager.startCooldownTimer(player, itemStack);
            return;
        }
        Location location = LocationUtils.getLocationNearPoint(player.getLocation(), 3);
        Animals animals = (Animals)player.getWorld().spawnEntity(location, petType.getSkin());
        animals.teleport(location);
        EffectUtils.playSpawnEffect((Entity)animals);
        Map<String, String> map = petType.getFeatures();
        boolean bl = false;
        block1 : switch (petType.getRole()) {
            case MOUNT: {
                switch (animals.getType()) {
                    case HORSE: {
                        Material material;
                        String string;
                        horse = (Horse)animals;
                        horseInventory = horse.getInventory();
                        horseInventory.setSaddle(new ItemStack(Material.SADDLE));
                        if (map.containsKey("CHEST") && map.get("CHEST").equals("TRUE")) {
                            try {
                                horse.setCarryingChest(true);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                Log.w("Failed to add a chest to the horse", new Object[0]);
                            }
                        }
                        if (map.containsKey("ARMOR")) {
                            string = map.get("ARMOR");
                            material = MaterialCompat.getMaterialOrNull(string);
                            if (material != null) {
                                horseInventory.setArmor(new ItemStack(material));
                            } else {
                                Log.w("Failed to add an armor to the horse. Unknown material: {0}", string);
                            }
                        }
                        if ((string = SafeEnums.getHorseColor(map.getOrDefault("COLOR", "BROWN"))) != null) {
                            horse.setColor((Horse.Color)string);
                        } else {
                            bl = true;
                        }
                        material = SafeEnums.getHorseStyle(map.getOrDefault("STYLE", "NONE"));
                        if (material != null) {
                            horse.setStyle((Horse.Style)material);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case PIG: {
                        Pig pig = (Pig)animals;
                        pig.setSaddle(true);
                    }
                }
                break;
            }
            case COMPANION: {
                switch (animals.getType()) {
                    case WOLF: {
                        horse = (Wolf)animals;
                        horseInventory = SafeEnums.getDyeColor(map.getOrDefault("COLLAR", "RED"));
                        if (horseInventory != null) {
                            horse.setCollarColor((DyeColor)horseInventory);
                            break block1;
                        }
                        bl = true;
                        break block1;
                    }
                    case CAT: {
                        Cat cat = (Cat)animals;
                        Cat.Type type = SafeEnums.getCatType(map.getOrDefault("TYPE", "TABBY"));
                        if (type != null) {
                            cat.setCatType(type);
                        } else {
                            bl = true;
                        }
                        DyeColor dyeColor = SafeEnums.getDyeColor(map.getOrDefault("COLLAR", "RED"));
                        if (dyeColor != null) {
                            cat.setCollarColor(dyeColor);
                            break block1;
                        }
                        bl = true;
                    }
                }
            }
        }
        if (animals instanceof Tameable) {
            ((Tameable)animals).setTamed(true);
            ((Tameable)animals).setOwner((AnimalTamer)player);
        }
        animals.setBreed(false);
        if (petType.isAdult()) {
            animals.setAdult();
        } else {
            animals.setBaby();
        }
        animals.setAgeLock(true);
        animals.setCustomName(RPGInventory.getLanguage().getMessage("pet.name", petType.getName(), player.getName()));
        animals.setCustomNameVisible(true);
        animals.setCanPickupItems(false);
        animals.setRemoveWhenFarAway(false);
        horse = animals.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        assert (horse != null);
        horse.setBaseValue(petType.getHealth());
        animals.setHealth(PetManager.getHealth(itemStack, horse.getBaseValue()));
        horseInventory = animals.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        assert (horseInventory != null);
        horseInventory.setBaseValue(petType.getSpeed());
        animals.setMetadata(METADATA_KEY_PET_OWNER, (MetadataValue)new FixedMetadataValue((Plugin)RPGInventory.getInstance(), (Object)player.getUniqueId()));
        if (bl) {
            Log.w("The pet ''{0}'' has errors on initialization and can be differ from expected result.", animals.getCustomName());
        }
        InventoryManager.get((OfflinePlayer)player).setPet((LivingEntity)animals);
    }

    public static void despawnPet(OfflinePlayer offlinePlayer) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)offlinePlayer) || !PetManager.isEnabled()) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get(offlinePlayer);
        Inventory inventory = playerWrapper.getInventory();
        LivingEntity livingEntity = playerWrapper.getPet();
        ItemStack itemStack = inventory.getItem(SLOT_PET);
        if (livingEntity == null) {
            return;
        }
        if (itemStack != null) {
            PetManager.saveHealth(itemStack, livingEntity.getHealth());
            inventory.setItem(SLOT_PET, itemStack);
        }
        EffectUtils.playDespawnEffect((Entity)livingEntity);
        livingEntity.remove();
        playerWrapper.setPet(null);
    }

    public static void despawnPet(Tameable tameable) {
        if (!PetManager.isEnabled()) {
            return;
        }
        EffectUtils.playDespawnEffect((Entity)tameable);
        tameable.remove();
    }

    @Nullable
    public static UUID getPetOwner(@NotNull LivingEntity livingEntity) {
        if (!livingEntity.hasMetadata(METADATA_KEY_PET_OWNER)) {
            return null;
        }
        List list = livingEntity.getMetadata(METADATA_KEY_PET_OWNER);
        return list.stream().filter(metadataValue -> RPGInventory.getInstance().equals(metadataValue.getOwningPlugin())).findFirst().map(metadataValue -> (UUID)metadataValue.value()).orElse(null);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PetFood getFoodFromItem(@Nullable ItemStack itemStack) {
        String string;
        if (ItemUtils.isEmpty(itemStack) || (string = ItemUtils.getTag(itemStack, "food.id")).isEmpty()) {
            return null;
        }
        return PET_FOOD.get(string);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PetType getPetFromItem(@Nullable ItemStack itemStack) {
        String string;
        if (ItemUtils.isEmpty(itemStack) || (string = ItemUtils.getTag(itemStack, "pet.id")).isEmpty()) {
            return null;
        }
        return PETS.get(string);
    }

    @Nullable
    public static PetType getPetFromEntity(@Nullable LivingEntity livingEntity, OfflinePlayer offlinePlayer) {
        if (livingEntity == null || !InventoryManager.playerIsLoaded((AnimalTamer)offlinePlayer) || !PetManager.isEnabled()) {
            return null;
        }
        PlayerWrapper playerWrapper = InventoryManager.get(offlinePlayer);
        return livingEntity == playerWrapper.getPet() ? PetManager.getPetFromItem(playerWrapper.getInventory().getItem(SLOT_PET)) : null;
    }

    static void addGlow(@NotNull ItemMeta itemMeta) {
        itemMeta.addEnchant(Enchantment.DURABILITY, 88, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
    }

    public static void saveDeathTime(@NotNull ItemStack itemStack) {
        PetManager.saveDeathTime(itemStack, System.currentTimeMillis());
    }

    public static void saveDeathTime(@NotNull ItemStack itemStack, long l) {
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack);
        if (l == 0L) {
            nbtCompound.remove(DEATH_TIME_TAG);
        } else {
            nbtCompound.put(DEATH_TIME_TAG, l);
        }
        NbtFactoryMirror.setItemTag(itemStack, nbtCompound);
    }

    public static long getDeathTime(@NotNull ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return 0L;
        }
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack.clone());
        return nbtCompound.containsKey(DEATH_TIME_TAG) ? nbtCompound.getLong(DEATH_TIME_TAG) : 0L;
    }

    public static int getCooldown(@NotNull ItemStack itemStack) {
        long l = PetManager.getDeathTime(itemStack);
        if (l == 0L) {
            return 0;
        }
        PetType petType = PetManager.getPetFromItem(itemStack);
        if (petType == null) {
            return 0;
        }
        int n = (int)((System.currentTimeMillis() - l) / 1000L);
        int n2 = petType.getCooldown();
        int n3 = n2 - n;
        if (n3 < 0 || n3 > n2) {
            n3 = 0;
        }
        if (n3 == 0) {
            PetManager.saveDeathTime(itemStack, 0L);
        }
        return n3;
    }

    public static void saveHealth(@NotNull ItemStack itemStack, double d) {
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack);
        if (d == 0.0) {
            nbtCompound.remove("pet.health");
        } else {
            nbtCompound.put("pet.health", d);
        }
        NbtFactoryMirror.setItemTag(itemStack, nbtCompound);
    }

    public static double getHealth(ItemStack itemStack, double d) {
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack.clone());
        if (!nbtCompound.containsKey("pet.health")) {
            return d;
        }
        double d2 = nbtCompound.getDouble("pet.health");
        return Math.min(d2, d);
    }

    @Nullable
    public static ItemStack getPetItem(String string) {
        PetType petType = PETS.get(string);
        return petType == null ? null : petType.getSpawnItem();
    }

    @Nullable
    public static ItemStack getFoodItem(String string) {
        PetFood petFood = PET_FOOD.get(string);
        return petFood == null ? null : petFood.getFoodItem();
    }

    public static ItemStack toPetItem(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return itemStack;
        }
        List list = itemStack.getItemMeta().getLore();
        for (PetType petType : PETS.values()) {
            List list2 = petType.getSpawnItem().getItemMeta().getLore();
            if (!list.equals(list2)) continue;
            return petType.getSpawnItem();
        }
        return itemStack;
    }

    public static boolean isPetItem(@Nullable ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack) || !itemStack.hasItemMeta() || !itemStack.getItemMeta().hasLore()) {
            return false;
        }
        List list = itemStack.getItemMeta().getLore();
        for (PetType petType : PETS.values()) {
            List list2 = petType.getSpawnItem().getItemMeta().getLore();
            if (!list.equals(list2)) continue;
            return true;
        }
        return false;
    }
}

