/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.pet;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.item.TexturedItem;
import ru.endlesscode.rpginventory.misc.FileLanguage;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class PetFood
extends TexturedItem {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> lore;
    private final double value;
    private final List<String> eaters;
    private ItemStack foodItem;

    PetFood(Texture texture, @NotNull ConfigurationSection configurationSection) {
        super(texture);
        this.name = StringUtils.coloredLine(configurationSection.getString("name"));
        this.lore = StringUtils.coloredLines(configurationSection.getStringList("lore"));
        this.value = configurationSection.getDouble("value");
        this.eaters = configurationSection.getStringList("eaters");
        this.createFoodItem(configurationSection.getName());
    }

    @Contract(value="null -> false")
    public static boolean isFoodItem(ItemStack itemStack) {
        return ItemUtils.isNotEmpty(itemStack) && ItemUtils.hasTag(itemStack, "food.id");
    }

    private void createFoodItem(String string) {
        ItemStack itemStack = this.texture.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.name);
        FileLanguage fileLanguage = RPGInventory.getLanguage();
        ArrayList<String> arrayList = new ArrayList<String>(this.lore);
        arrayList.add(fileLanguage.getMessage("pet.food.value", (int)this.value));
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        this.foodItem = ItemUtils.setTag(itemStack, "food.id", string);
    }

    public ItemStack getFoodItem() {
        return this.foodItem;
    }

    public double getValue() {
        return this.value;
    }

    public boolean canBeEaten(@NotNull LivingEntity livingEntity) {
        String string = livingEntity.getType().toString();
        return string != null && this.eaters.contains(string);
    }
}

