/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.pet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scheduler.BukkitRunnable;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;

public class CooldownsTimer
extends BukkitRunnable {
    public static final int TICK_PERIOD = 5;
    private static final int TICK_RATE = 4;
    private final HashMap<UUID, ValuePair> petItemsByPlayer = new HashMap();
    private final HashMap<UUID, ValuePair> temporaryMap = new HashMap();
    private final RPGInventory plugin;
    private final Slot petSlot;

    public CooldownsTimer(RPGInventory rPGInventory) {
        this.plugin = rPGInventory;
        this.petSlot = Objects.requireNonNull(SlotManager.instance().getPetSlot(), "Pet slot can't be null!");
    }

    public void addPetCooldown(Player player, ItemStack itemStack) {
        if (player == null || ItemUtils.isEmpty(itemStack)) {
            return;
        }
        if (PetManager.getPetFromItem(itemStack) == null) {
            return;
        }
        this.temporaryMap.put(player.getUniqueId(), new ValuePair(itemStack, new AtomicInteger(0)));
    }

    public void run() {
        if (!this.temporaryMap.isEmpty()) {
            this.petItemsByPlayer.putAll(this.temporaryMap);
            this.temporaryMap.clear();
        }
        Iterator<Map.Entry<UUID, ValuePair>> iterator2 = this.petItemsByPlayer.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string;
            Map.Entry<UUID, ValuePair> entry = iterator2.next();
            int n = entry.getValue().getTimer().incrementAndGet();
            if (n % 4 != 0) continue;
            Player player = this.plugin.getServer().getPlayer(entry.getKey());
            if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
                iterator2.remove();
                continue;
            }
            Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
            if (inventory.getItem(PetManager.getPetSlotId()) == null) {
                iterator2.remove();
                continue;
            }
            ItemStack itemStack = entry.getValue().getItemStack();
            int n2 = PetManager.getCooldown(itemStack);
            if (1 > n2) {
                PetManager.respawnPet(player, itemStack);
                inventory.setItem(PetManager.getPetSlotId(), itemStack);
                iterator2.remove();
                continue;
            }
            if (60 < n2) continue;
            ItemStack itemStack2 = itemStack.clone();
            String string2 = entry.getValue().getDisplayName();
            ItemMeta itemMeta = itemStack2.getItemMeta();
            if (itemMeta != null) {
                itemMeta.setDisplayName(string2 + " " + RPGInventory.getLanguage().getMessage("pet.cooldown", n2));
                PetManager.addGlow(itemMeta);
                itemStack2.setItemMeta(itemMeta);
            }
            if (!(string = ItemUtils.getTag(itemStack2, "pet.id")).isEmpty()) {
                ItemUtils.setTag(itemStack2, "pet.id", string);
                inventory.setItem(PetManager.getPetSlotId(), itemStack2);
                continue;
            }
            inventory.setItem(PetManager.getPetSlotId(), this.petSlot.getCup());
            iterator2.remove();
        }
    }

    private static class ValuePair {
        private final ItemStack itemStack;
        private final AtomicInteger timer;
        private final String displayName;

        private ValuePair(ItemStack itemStack, AtomicInteger atomicInteger) {
            this.itemStack = itemStack;
            this.displayName = itemStack.getItemMeta().getDisplayName();
            this.timer = atomicInteger;
        }

        private ItemStack getItemStack() {
            return this.itemStack;
        }

        private String getDisplayName() {
            return this.displayName;
        }

        private AtomicInteger getTimer() {
            return this.timer;
        }
    }
}

