/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc.serialization;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class SlotSnapshot
implements ConfigurationSerializable {
    private static final String SLOT_TYPE = "type";
    private static final String SLOT_BOUGHT = "bought";
    private static final String SLOT_ITEMS = "items";
    private final String name;
    private final String type;
    private final boolean bought;
    private final List<ItemStack> items;

    private SlotSnapshot(@NotNull String string, @NotNull String string2, boolean bl, @NotNull List<ItemStack> list) {
        this.name = string;
        this.type = string2;
        this.bought = bl;
        this.items = list;
    }

    @NotNull
    public static SlotSnapshot create(@NotNull Slot slot, @NotNull PlayerWrapper playerWrapper) {
        boolean bl = playerWrapper.isBuyedSlot(slot.getName());
        Inventory inventory = playerWrapper.getInventory();
        List<ItemStack> list = slot.getSlotIds().stream().map(arg_0 -> ((Inventory)inventory).getItem(arg_0)).filter(itemStack -> ItemUtils.isNotEmpty(itemStack) && !slot.isCup((ItemStack)itemStack)).collect(Collectors.toList());
        return new SlotSnapshot(slot.getName(), slot.getSlotType().name(), bl, list);
    }

    @NotNull
    public static SlotSnapshot deserialize(@NotNull Map<String, Object> map) {
        String string = (String)map.getOrDefault(SLOT_TYPE, "{missing}");
        boolean bl = map.containsKey(SLOT_BOUGHT);
        List<ItemStack> list = map.getOrDefault(SLOT_ITEMS, Collections.emptyList());
        return new SlotSnapshot("", string, bl, list);
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(SLOT_TYPE, this.type);
        linkedHashMap.put(SLOT_ITEMS, this.items);
        if (this.bought) {
            linkedHashMap.put(SLOT_BOUGHT, true);
        }
        return linkedHashMap;
    }

    void restore(@NotNull PlayerWrapper playerWrapper, @NotNull Slot slot) {
        if (!slot.getSlotType().name().equals(this.type)) {
            Log.w("Slot ''{0}'' skipped. Wrong type of saved slot: {1}", slot.getName(), this.type);
            return;
        }
        if (this.bought) {
            playerWrapper.setBuyedSlots(slot.getName());
        }
        Inventory inventory = playerWrapper.getInventory();
        List<Integer> list = slot.getSlotIds();
        for (int i = 0; i < Math.min(list.size(), this.items.size()); ++i) {
            inventory.setItem(list.get(i).intValue(), this.items.get(i));
        }
    }

    boolean shouldBeSaved() {
        return !this.items.isEmpty() || this.bought;
    }

    public String getName() {
        return this.name;
    }
}

