/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.yaml.snakeyaml.reader.ReaderException;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.backpack.Backpack;
import ru.endlesscode.rpginventory.misc.serialization.InventorySnapshot;
import ru.endlesscode.rpginventory.misc.serialization.LegacySerialization;
import ru.endlesscode.rpginventory.misc.serialization.SlotSnapshot;
import ru.endlesscode.rpginventory.utils.FileUtils;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class Serialization {
    private static final String ROOT_TAG = "data";

    public static void registerTypes() {
        ConfigurationSerialization.registerClass(InventorySnapshot.class);
        ConfigurationSerialization.registerClass(SlotSnapshot.class);
        ConfigurationSerialization.registerClass(Backpack.class);
    }

    @Nullable
    public static PlayerWrapper loadPlayerOrNull(Player player, @NotNull Path path) {
        PlayerWrapper playerWrapper;
        try {
            playerWrapper = Serialization.loadPlayer(player, path);
        }
        catch (IOException | InvalidConfigurationException throwable) {
            Log.d(throwable);
            FileUtils.resolveException(path);
            playerWrapper = null;
        }
        return playerWrapper;
    }

    @NotNull
    private static PlayerWrapper loadPlayer(Player player, @NotNull Path path) {
        PlayerWrapper playerWrapper;
        try {
            InventorySnapshot inventorySnapshot = (InventorySnapshot)Serialization.load(path);
            playerWrapper = inventorySnapshot.restore(player);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            if (invalidConfigurationException.getCause() instanceof ReaderException) {
                Log.w("Can''t load {0}''s inventory. Trying to use legacy loader...", player.getName());
                playerWrapper = LegacySerialization.loadPlayer(player, path);
            }
            throw invalidConfigurationException;
        }
        return playerWrapper;
    }

    public static Backpack loadBackpack(@NotNull Path path) {
        Backpack backpack;
        try {
            backpack = (Backpack)Serialization.load(path);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            if (invalidConfigurationException.getCause() instanceof ReaderException) {
                Log.w("Can''t load backpack {0}. Trying to use legacy loader...", path.getFileName().toString());
                backpack = LegacySerialization.loadBackpack(path);
            }
            throw invalidConfigurationException;
        }
        return backpack;
    }

    public static void save(@NotNull Object object, @NotNull Path path) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.set(ROOT_TAG, object);
        Path path2 = Files.createTempFile(path.getParent(), path.getFileName().toString(), null, new FileAttribute[0]);
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(Files.newOutputStream(path2, new OpenOption[0])), StandardCharsets.UTF_8);){
            outputStreamWriter.write(yamlConfiguration.saveToString());
        }
        Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
    }

    @NotNull
    private static Object load(@NotNull Path path) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])), StandardCharsets.UTF_8);){
            yamlConfiguration.load((Reader)inputStreamReader);
        }
        return Objects.requireNonNull(yamlConfiguration.get(ROOT_TAG), "Serialized data not found");
    }
}

