/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc.serialization;

import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.io.NbtBinarySerializer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.compat.MaterialCompat;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.backpack.Backpack;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackManager;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackType;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.utils.FileUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.NbtFactoryMirror;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

@Deprecated
class LegacySerialization {
    LegacySerialization() {
    }

    @NotNull
    static PlayerWrapper loadPlayer(Player player, @NotNull Path path) {
        PlayerWrapper playerWrapper = new PlayerWrapper((OfflinePlayer)player);
        Inventory inventory = playerWrapper.getInventory();
        try (DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])));){
            NbtCompound nbtCompound = NbtBinarySerializer.DEFAULT.deserializeCompound((DataInput)dataInputStream);
            playerWrapper.setBuyedSlots(nbtCompound.getInteger("buyed-slots"));
            nbtCompound.remove("buyed-slots");
            NbtCompound nbtCompound2 = nbtCompound.containsKey("slots") ? nbtCompound.getCompound("slots") : nbtCompound;
            for (Slot slot : SlotManager.instance().getSlots()) {
                if (!nbtCompound2.containsKey(slot.getName())) continue;
                NbtCompound nbtCompound3 = nbtCompound2.getCompound(slot.getName());
                if (slot.getSlotType() != Slot.SlotType.valueOf(nbtCompound3.getString("type"))) continue;
                if (nbtCompound3.containsKey("buyed")) {
                    playerWrapper.setBuyedSlots(slot.getName());
                }
                NbtCompound nbtCompound4 = nbtCompound3.getCompound("items");
                ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
                for (String string : nbtCompound4.getKeys()) {
                    arrayList.add(LegacySerialization.nbtToItemStack(nbtCompound4.getCompound(string)));
                }
                List<Integer> list = slot.getSlotIds();
                for (int i = 0; i < list.size(); ++i) {
                    if (arrayList.size() <= i) continue;
                    inventory.setItem(((Integer)list.get(i)).intValue(), (ItemStack)arrayList.get(i));
                }
            }
        }
        return playerWrapper;
    }

    @Nullable
    static Backpack loadBackpack(@NotNull Path path) {
        Backpack backpack;
        try (DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])));){
            NbtCompound nbtCompound = NbtBinarySerializer.DEFAULT.deserializeCompound((DataInput)dataInputStream);
            BackpackType backpackType = BackpackManager.getBackpackType(nbtCompound.getString("type"));
            if (backpackType == null) {
                Backpack backpack2 = null;
                return backpack2;
            }
            long l = nbtCompound.containsKey("last-use") ? nbtCompound.getLong("last-use") : System.currentTimeMillis();
            backpack = new Backpack(backpackType, UUID.fromString(FileUtils.stripExtension(path.getFileName().toString())));
            backpack.setLastUse(l);
            NbtCompound nbtCompound2 = nbtCompound.getCompound("contents");
            ItemStack[] itemStackArray = new ItemStack[backpackType.getSize()];
            for (int i = 0; i < backpackType.getSize() && nbtCompound2.containsKey(i + ""); ++i) {
                NbtCompound nbtCompound3 = nbtCompound2.getCompound(i + "");
                itemStackArray[i] = nbtCompound3 == null ? new ItemStack(Material.AIR) : LegacySerialization.nbtToItemStack(nbtCompound3);
            }
            backpack.setContents(itemStackArray);
        }
        return backpack;
    }

    @NotNull
    private static ItemStack nbtToItemStack(NbtCompound nbtCompound) {
        ItemStack itemStack = new ItemStack(MaterialCompat.getMaterialOrAir(nbtCompound.getString("material")));
        if (ItemUtils.isNotEmpty(itemStack)) {
            itemStack.setAmount(nbtCompound.getInteger("amount"));
            itemStack.setDurability(nbtCompound.getShort("data").shortValue());
            if (nbtCompound.containsKey("tag") && ItemUtils.isNotEmpty(itemStack = ItemUtils.toBukkitItemStack(itemStack))) {
                NbtFactoryMirror.setItemTag(itemStack, nbtCompound.getCompound("tag"));
            }
        }
        return itemStack;
    }
}

