/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc.serialization;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.misc.serialization.SlotSnapshot;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class InventorySnapshot
implements ConfigurationSerializable {
    private static final String INV_SLOTS = "slots";
    private static final String INV_BOUGHT_SLOTS = "bought-slots";
    private final Map<String, SlotSnapshot> slots;
    private final int boughtSlots;

    private InventorySnapshot(@NotNull Map<String, SlotSnapshot> map, int n) {
        this.slots = map;
        this.boughtSlots = n;
    }

    @NotNull
    public static InventorySnapshot create(@NotNull PlayerWrapper playerWrapper) {
        Map<String, SlotSnapshot> map = SlotManager.instance().getSlots().stream().filter(slot -> slot.getSlotType() != Slot.SlotType.ARMOR).map(slot -> SlotSnapshot.create(slot, playerWrapper)).filter(SlotSnapshot::shouldBeSaved).collect(Collectors.toMap(SlotSnapshot::getName, Function.identity()));
        return new InventorySnapshot(map, playerWrapper.getBuyedGenericSlots());
    }

    @NotNull
    public static InventorySnapshot deserialize(@NotNull Map<String, Object> map) {
        Map<String, SlotSnapshot> map2 = map.getOrDefault(INV_SLOTS, Collections.emptyMap());
        int n = (Integer)map.getOrDefault(INV_BOUGHT_SLOTS, 0);
        return new InventorySnapshot(map2, n);
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(INV_BOUGHT_SLOTS, this.boughtSlots);
        linkedHashMap.put(INV_SLOTS, this.slots);
        return linkedHashMap;
    }

    public PlayerWrapper restore(@NotNull Player player) {
        PlayerWrapper playerWrapper = new PlayerWrapper((OfflinePlayer)player);
        playerWrapper.setBuyedSlots(this.boughtSlots);
        SlotManager.instance().getSlots().stream().filter(slot -> this.slots.containsKey(slot.getName())).forEach(slot -> this.slots.get(slot.getName()).restore(playerWrapper, (Slot)slot));
        return playerWrapper;
    }
}

