/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc.config;

import java.util.Arrays;
import java.util.Collections;
import org.bukkit.configuration.file.FileConfiguration;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.utils.Version;

public class ConfigUpdater {
    public static void update(Version version) {
        FileConfiguration fileConfiguration = Config.getConfig();
        if (version.compareTo("1.0.0") < 0) {
            fileConfiguration.set("ids", null);
            fileConfiguration.set("attack.auto-held", (Object)true);
        }
        if (version.compareTo("1.0.1") < 0) {
            fileConfiguration.set("slots.pet", null);
            fileConfiguration.set("slots.crafting", null);
            fileConfiguration.set("slots.enabled", (Object)true);
            fileConfiguration.set("slots.level.spend", (Object)false);
            SlotManager.instance().saveDefaults();
        }
        if (version.compareTo("1.1.0") < 0) {
            fileConfiguration.set("alternate-view.enabled", (Object)false);
            fileConfiguration.set("alternate-view.fill", (Object)"STAINED_GLASS_PANE:0");
        }
        if (version.compareTo("1.0.4") < 0) {
            fileConfiguration.set("alternate-view.item", (Object)"ENCHANTED_BOOK");
            fileConfiguration.set("alternate-view.slot", (Object)8);
            fileConfiguration.set("alternate-view.name", (Object)"&6Equipment");
            fileConfiguration.set("alternate-view.lore", (Object)"&7&o(Right click to open equipment)");
        }
        if (version.compareTo("1.0.5") < 0) {
            if (fileConfiguration.getInt("alternate-view.slot") == 9) {
                fileConfiguration.set("alternate-view.slot", (Object)8);
            }
            fileConfiguration.set("resource-pack.mode", (Object)(fileConfiguration.getBoolean("alternate-view.enabled") ? "DISABLED" : "AUTO"));
            fileConfiguration.set("resource-pack.url", (Object)"PUT_YOUR_URL_HERE");
            fileConfiguration.set("resource-pack.hash", (Object)"PUT_YOUR_HASH_HERE");
            fileConfiguration.set("alternate-view.enabled", null);
            fileConfiguration.set("alternate-view.use-item", (Object)true);
        }
        if (version.compareTo("1.1.8") < 0) {
            fileConfiguration.set("alternate-view.enable-craft", (Object)true);
            fileConfiguration.set("worlds.mode", (Object)"BLACKLIST");
            fileConfiguration.set("worlds.list", (Object)new String[]{"blocked_world"});
        }
        if (version.compareTo("1.2.4") < 0) {
            fileConfiguration.set("backpacks.expiration-time", (Object)30);
        }
        if (version.compareTo("1.2.5") < 0) {
            fileConfiguration.set("level-system", (Object)"EXP");
            fileConfiguration.set("class-system", (Object)"PERMISSIONS");
            fileConfiguration.set("metrics", (Object)true);
        }
        if (version.compareTo("1.2.7") < 0) {
            fileConfiguration.set("items.lore-pattern", (Object)new String[]{"_UNBREAKABLE_", "_DROP_", "_LEVEL_", "_CLASS_", "_SEPARATOR_", "_LORE_", "_SEPARATOR_", "_SKILLS_", "_SEPARATOR_", "_STATS_"});
            fileConfiguration.set("items.separator", (Object)"");
            fileConfiguration.set("auto-update", (Object)false);
        }
        if (version.compareTo("1.3.0") < 0) {
            fileConfiguration.set("auto-update", (Object)true);
        }
        if (version.compareTo("1.3.3") < 0) {
            fileConfiguration.set("health.base", (Object)20);
            fileConfiguration.set("health.scale", (Object)false);
            fileConfiguration.set("health.hearts", (Object)20);
            fileConfiguration.set("health.heart-capacity.min", (Object)1);
            fileConfiguration.set("health.heart-capacity.max", (Object)5);
        }
        if (version.compareTo("2.0.0") < 0) {
            fileConfiguration.set("resource-pack.fill", (Object)"DIAMOND_HOE:1");
            fileConfiguration.set("resource-pack.mode", null);
            fileConfiguration.set("alternate-view", null);
            fileConfiguration.set("containers.block", (Object)false);
            fileConfiguration.set("slots.locked", (Object)"DIAMOND_HOE:19");
            fileConfiguration.set("slots.buyable", (Object)"DIAMOND_HOE:18");
            fileConfiguration.set("craft.enabled", (Object)true);
            fileConfiguration.set("craft.extendable", (Object)"DIAMOND_HOE:0");
            fileConfiguration.set("craft.extensions.journeyman.name", (Object)"&aJourneyman slots");
            fileConfiguration.set("craft.extensions.journeyman.lore", (Object)"&eYou must be a journeyman to use it");
            fileConfiguration.set("craft.extensions.journeyman.slots", Arrays.asList(8, 9));
            fileConfiguration.set("craft.extensions.master.name", (Object)"&3Master slots");
            fileConfiguration.set("craft.extensions.master.lore", (Object)"&eYou must be a master to use it");
            fileConfiguration.set("craft.extensions.master.includes", Collections.singletonList("journeyman"));
            fileConfiguration.set("craft.extensions.master.slots", Arrays.asList(1, 4, 7));
            fileConfiguration.set("join-messages.enabled", (Object)true);
            fileConfiguration.set("join-messages.delay", (Object)3);
            fileConfiguration.set("join-messages.default.title", (Object)"&l&2Welcome to server!");
            fileConfiguration.set("join-messages.default.text", Arrays.asList("&6Glad to see you, &3%PLAYER%", "&6This server using &9RPGInventory"));
            fileConfiguration.set("join-messages.rp-info.title", (Object)"&l&4It is important!");
            fileConfiguration.set("join-messages.rp-info.text", Arrays.asList("&6You should &callow &6resource pack to play on this server", "&6This will allow you fully immerse in the RPG atmosphere", "&6But if you declined downloading of RP you can fix it...", "&6Select the server in list, click &e'Edit' &6 and set &e'Resource-Pack: Accept'"));
        }
        if (version.compareTo("2.0.1") < 0 && "&l&2Welcome to server!".equals(fileConfiguration.get("join-messages.rp-info.title"))) {
            fileConfiguration.set("join-messages.rp-info.title", (Object)"&l&4It is important!");
            fileConfiguration.set("join-messages.default.title", (Object)"&l&2Welcome to server!");
        }
        if (version.compareTo("2.0.4") < 0) {
            fileConfiguration.set("join-messages.enabled", null);
            fileConfiguration.set("join-messages.rp-info.enabled", (Object)true);
            fileConfiguration.set("join-messages.default.enabled", (Object)true);
            fileConfiguration.set("backpacks.limit", (Object)1);
            fileConfiguration.set("craft.workbench", (Object)true);
            if ("DIAMOND_HOE:0".equals(fileConfiguration.get("craft.extendable"))) {
                fileConfiguration.set("craft.extendable", (Object)"DIAMOND_HOE:27");
            }
        }
        if (version.compareTo("2.0.8") < 0) {
            fileConfiguration.set("fill", fileConfiguration.get("resource-pack.fill"));
            fileConfiguration.set("resource-pack.fill", null);
            fileConfiguration.set("resource-pack.enabled", (Object)true);
        }
        if (version.compareTo("2.1.0") < 0) {
            fileConfiguration.set("resource-pack.delay", (Object)2);
            fileConfiguration.set("check-update", (Object)fileConfiguration.getBoolean("auto-update"));
            fileConfiguration.set("auto-update", null);
        }
        if (version.compareTo("2.1.4") < 0) {
            fileConfiguration.set("health", null);
        }
        if (version.compareTo("2.2.0") < 0) {
            fileConfiguration.set("armor-slots-action", (Object)"default");
            fileConfiguration.set("craft-slots-action", (Object)"rpginv");
        }
        if (version.compareTo("2.3.0") < 0) {
            fileConfiguration.set("metrics", null);
            fileConfiguration.set("containers", null);
        }
    }
}

