/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.misc.config.VanillaSlotAction;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class Config {
    public static VanillaSlotAction craftSlotsAction = VanillaSlotAction.RPGINV;
    public static VanillaSlotAction armorSlotsAction = VanillaSlotAction.DEFAULT;
    private static final FileConfiguration config = new YamlConfiguration();
    private static Path configFile;

    public static void init(RPGInventory rPGInventory) {
        configFile = rPGInventory.getDataPath().resolve("config.yml");
        rPGInventory.saveDefaultConfig();
        InputStream inputStream = rPGInventory.getResource("config.yml");
        if (inputStream != null) {
            Config.loadDefaultConfig(inputStream);
        }
        Config.reload();
    }

    public static FileConfiguration getConfig() {
        return config;
    }

    public static void reload() {
        try {
            config.load(configFile.toFile());
        }
        catch (IOException | InvalidConfigurationException throwable) {
            Log.w(throwable, "Error on load config.yml", new Object[0]);
        }
        Config.copyOptionsFromConfig();
        Config.save();
    }

    public static void save() {
        try {
            config.save(configFile.toFile());
        }
        catch (IOException iOException) {
            Log.w(iOException, "Error on save config.yml", new Object[0]);
        }
    }

    private static void loadDefaultConfig(@NotNull InputStream inputStream) {
        Path path = configFile.getParent().resolve("config-example.yml");
        try (InputStream inputStream2 = inputStream;){
            Files.copy(inputStream2, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            Log.w(iOException, "Error on copying config-example.yml", new Object[0]);
        }
        config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((File)path.toFile()));
        config.options().copyDefaults(true);
    }

    private static void copyOptionsFromConfig() {
        craftSlotsAction = VanillaSlotAction.parseString(config.getString("craft-slots-action"));
        armorSlotsAction = VanillaSlotAction.parseString(config.getString("armor-slots-action"));
    }
}

