/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class Updater {
    private static final String TITLE_VALUE = "name";
    private static final String LINK_VALUE = "fileUrl";
    private static final String VERSION_VALUE = "gameVersion";
    private static final String DESCRIPTION_VALUE = "description";
    private static final String QUERY = "/updates/versions.json";
    private static final String HOST = "http://rpginventory.endlesscode.ru";
    private static final String USER_AGENT = "RPGInventory";
    private static final String DELIMITER = "^v|[\\s_-]v";
    private static final String[] NO_UPDATE_TAG = new String[]{"-DEV", "-PRE", "-SNAPSHOT"};
    private static final String API_KEY_CONFIG_KEY = "api-key";
    private static final String DISABLE_CONFIG_KEY = "disable";
    private static final String API_KEY_DEFAULT = "PUT_API_KEY_HERE";
    private static final boolean DISABLE_DEFAULT = false;
    private final Plugin plugin;
    private final UpdateType type;
    private String versionName;
    private String infoLink;
    private String description;
    private URL url;
    private Thread thread;
    @NotNull
    private UpdateResult result = UpdateResult.SUCCESS;

    public Updater(Plugin plugin, UpdateType updateType) {
        this.plugin = plugin;
        this.type = updateType;
        File file = this.plugin.getDataFolder().getParentFile();
        File file2 = new File(file, "Updater");
        File file3 = new File(file2, "config.yml");
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.options().header("This configuration file affects all plugins using the Updater system (version 2+ - http://forums.bukkit.org/threads/96681/ )\nIf you wish to use your API key, read http://wiki.bukkit.org/ServerMods_API and place it below.\nSome updating systems will not adhere to the disabled value, but these may be turned off in their plugin's configuration.");
        yamlConfiguration.addDefault(API_KEY_CONFIG_KEY, (Object)API_KEY_DEFAULT);
        yamlConfiguration.addDefault(DISABLE_CONFIG_KEY, (Object)false);
        if (!file2.exists()) {
            this.fileIOOrError(file2, file2.mkdir(), true);
        }
        boolean bl = !file3.exists();
        try {
            if (bl) {
                this.fileIOOrError(file3, file3.createNewFile(), true);
                yamlConfiguration.options().copyDefaults(true);
                yamlConfiguration.save(file3);
            } else {
                yamlConfiguration.load(file3);
            }
        }
        catch (Exception exception) {
            String string = bl ? "The updater could not create configuration at " + file2.getAbsolutePath() : "The updater could not load configuration at " + file2.getAbsolutePath();
            this.plugin.getLogger().log(Level.SEVERE, string, exception);
        }
        if (yamlConfiguration.getBoolean(DISABLE_CONFIG_KEY)) {
            this.result = UpdateResult.DISABLED;
            return;
        }
        try {
            this.url = new URL("http://rpginventory.endlesscode.ru/updates/versions.json");
            this.thread = new Thread(new UpdateRunnable());
            this.thread.start();
        }
        catch (MalformedURLException malformedURLException) {
            this.runUpdater();
        }
    }

    @NotNull
    public UpdateResult getResult() {
        this.waitForThread();
        return this.result;
    }

    public String getLatestName() {
        this.waitForThread();
        return this.versionName;
    }

    public String getInfoLink() {
        return this.infoLink;
    }

    private void waitForThread() {
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                this.plugin.getLogger().log(Level.SEVERE, null, interruptedException);
            }
        }
    }

    private boolean versionCheck() {
        String string = this.versionName;
        if (this.type != UpdateType.NO_VERSION_CHECK) {
            String string2 = this.plugin.getDescription().getVersion();
            if (string.split(DELIMITER).length == 2) {
                String string3 = string.split(DELIMITER)[1].split(" ")[0];
                if (this.hasTag(string2) || !this.shouldUpdate(string2, string3)) {
                    this.result = UpdateResult.NO_UPDATE;
                    return false;
                }
            } else {
                String string4 = this.plugin.getDescription().getAuthors().isEmpty() ? "" : " (" + (String)this.plugin.getDescription().getAuthors().get(0) + ")";
                this.plugin.getLogger().warning("The author of this plugin" + string4 + " has misconfigured their Auto Update system");
                this.plugin.getLogger().warning("File versions should follow the format 'PluginName vVERSION'");
                this.plugin.getLogger().warning("Please notify the author of this error.");
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
        }
        return true;
    }

    private boolean shouldUpdate(String string, String string2) {
        return !string.equalsIgnoreCase(string2);
    }

    private boolean hasTag(@NotNull String string) {
        for (String string2 : NO_UPDATE_TAG) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean read() {
        try {
            return this.tryToRead();
        }
        catch (IOException | NullPointerException exception) {
            Log.s("The updater could not contact {0} for check updates.", HOST);
            Log.s("The site experiencing temporary downtime.", new Object[0]);
            this.result = UpdateResult.FAIL_DBO;
            return false;
        }
    }

    private boolean tryToRead() {
        Object object;
        URLConnection uRLConnection = this.url.openConnection();
        uRLConnection.setConnectTimeout(5000);
        uRLConnection.addRequestProperty("User-Agent", USER_AGENT);
        uRLConnection.setDoOutput(true);
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), StandardCharsets.UTF_8));
        Object object3 = null;
        try {
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                stringBuilder.append(((String)object).trim());
            }
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object3 != null) {
                    try {
                        ((BufferedReader)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    ((BufferedReader)object2).close();
                }
            }
        }
        object2 = null;
        object3 = new TypeToken<ArrayList<UpdateData>>(){}.getType();
        object = (List)new Gson().fromJson(stringBuilder.toString(), (Type)object3);
        Iterator iterator2 = object.iterator();
        block10: while (iterator2.hasNext()) {
            String[] stringArray;
            UpdateData updateData = (UpdateData)iterator2.next();
            for (String string : stringArray = updateData.mcVersions.split(", ")) {
                if (!Bukkit.getBukkitVersion().startsWith(string)) continue;
                object2 = updateData;
                continue block10;
            }
        }
        if (object2 == null) {
            this.result = UpdateResult.NO_UPDATE;
            return false;
        }
        this.versionName = ((UpdateData)object2).versionName;
        this.infoLink = ((UpdateData)object2).infoLink;
        this.description = ((UpdateData)object2).description;
        return true;
    }

    private void fileIOOrError(@NotNull File file, boolean bl, boolean bl2) {
        if (!bl) {
            this.plugin.getLogger().severe("The updater could not " + (bl2 ? "create" : "delete") + " file at: " + file.getAbsolutePath());
        }
    }

    private void runUpdater() {
        if (this.url != null && this.read() && this.versionCheck()) {
            this.result = UpdateResult.UPDATE_AVAILABLE;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public static final class UpdateData {
        @SerializedName(value="gameVersion")
        public String mcVersions;
        @SerializedName(value="name")
        public String versionName;
        @SerializedName(value="fileUrl")
        public String infoLink;
        @SerializedName(value="description")
        public String description;
    }

    private class UpdateRunnable
    implements Runnable {
        private UpdateRunnable() {
        }

        @Override
        public void run() {
            Updater.this.runUpdater();
        }
    }

    public static interface UpdateCallback {
        public void onFinish(Updater var1);
    }

    public static enum UpdateType {
        NO_VERSION_CHECK,
        NO_DOWNLOAD;

    }

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        DISABLED,
        FAIL_DBO,
        FAIL_NOVERSION,
        UPDATE_AVAILABLE;

    }
}

