/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class FileLanguage {
    private final RPGInventory plugin;
    private final HashMap<String, MessageFormat> messageCache = new HashMap();
    private final Properties language = new Properties();
    @NotNull
    private final Path langFile;

    public FileLanguage(RPGInventory rPGInventory) {
        this.plugin = rPGInventory;
        String string = Config.getConfig().getString("language");
        this.langFile = this.plugin.getDataPath().resolve(String.format("lang/%s.lang", string));
        this.saveDefault();
        this.checkAndUpdateOutdatedLocaleFile();
        this.load();
        this.validateLocaleFile();
    }

    private void saveDefault() {
        if (Files.exists(this.langFile, new LinkOption[0])) {
            return;
        }
        String string = "lang/" + this.langFile.getFileName();
        try {
            this.plugin.saveResource(string, true);
        }
        catch (Exception exception) {
            Log.w("Failed to load {0}: {1}; using en.lang", this.langFile.getFileName(), exception.toString());
            try (InputStream inputStream = this.plugin.getResource("lang/en.lang");){
                Objects.requireNonNull(inputStream);
                Files.copy(inputStream, Paths.get(this.langFile.toUri()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | NullPointerException exception2) {
                Log.s("Failed to write default locale to {0}: {1}; continue without localization.", this.langFile.getFileName(), exception2.toString());
            }
        }
    }

    private void load() {
        try (InputStream inputStream = Files.newInputStream(this.langFile, new OpenOption[0]);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            this.language.load(inputStreamReader);
        }
        catch (IOException iOException) {
            Log.s("Failed to load locale file: {0}; continue without localization.", iOException.toString());
        }
    }

    private void checkAndUpdateOutdatedLocaleFile() {
        List<String> list;
        Path path = this.langFile;
        try {
            list = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            Log.w(iOException, "Failed to read locale file", new Object[0]);
            return;
        }
        if (list.get(0).startsWith("#version")) {
            return;
        }
        Pattern pattern = Pattern.compile("%(s|d|.2f)");
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("#version: 2.0 | Do not remove this line!");
        for (int i = 0; i < list.size(); ++i) {
            Matcher matcher;
            String string = list.get(i);
            String string2 = string.replace("\"", "");
            int n = 0;
            while ((matcher = pattern.matcher(string2)).find()) {
                string2 = matcher.replaceFirst("{" + n + "}");
                ++n;
            }
            if (list.size() > i + 1) {
                String string3 = list.get(i + 1);
                if (!("\n ".length() >= string3.length() || string3.contains(":") && string3.indexOf(58) <= string3.indexOf(32))) {
                    string2 = string2 + "\\";
                }
            }
            linkedList.add(string2);
        }
        try {
            Files.write(path, linkedList, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            Log.w("Failed to save locale file: {0}", iOException.toString());
        }
    }

    private void validateLocaleFile() {
        Properties properties = new Properties();
        InputStream inputStream = this.plugin.getResource("lang/en.lang");
        try {
            Throwable throwable = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);){
                properties.load(inputStreamReader);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | NullPointerException exception) {
            Log.w(exception, "Failed to read inbuilt locale file", new Object[0]);
            return;
        }
        if (this.language.keySet().containsAll(properties.keySet())) {
            return;
        }
        for (Object e : properties.keySet()) {
            if (this.language.containsKey(e)) continue;
            this.language.setProperty((String)e, properties.getProperty((String)e));
        }
    }

    @Deprecated
    @NotNull
    public String getCaption(String string, Object ... objectArray) {
        return this.getMessage(string, objectArray);
    }

    @NotNull
    public String getMessage(String string) {
        return this.getMessage(string, false);
    }

    @NotNull
    public String getMessage(String string, boolean bl) {
        return this.getMessage(string, bl, (Object[])null);
    }

    @NotNull
    public String getMessage(String string, Object ... objectArray) {
        return this.getMessage(string, false, objectArray);
    }

    @NotNull
    public String getMessage(String string, boolean bl, Object ... objectArray) {
        if (!this.messageCache.containsKey(string)) {
            this.messageCache.put(string, new MessageFormat(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getProperty(string, "Unknown localization key: \"" + string + "\""))));
        }
        String string2 = this.messageCache.get(string).format(objectArray);
        return bl ? ChatColor.stripColor((String)string2) : string2;
    }
}

