/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.item;

import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import ru.endlesscode.rpginventory.compat.MaterialCompat;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.NbtFactoryMirror;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class Texture {
    private static final Texture EMPTY_TEXTURE = new Texture(new ItemStack(Material.AIR));
    @NotNull
    private final ItemStack prototype;
    private final short durability;

    private Texture(@NotNull ItemStack itemStack) {
        this(itemStack, -1);
    }

    private Texture(@NotNull ItemStack itemStack, short s) {
        this.prototype = itemStack;
        this.durability = s;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY_TEXTURE);
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.prototype.clone();
    }

    public short getDurability() {
        return this.durability;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Texture)) {
            return false;
        }
        Texture texture = (Texture)object;
        return this.prototype.equals((Object)texture.prototype);
    }

    public int hashCode() {
        return Objects.hash(this.prototype);
    }

    public static Texture parseTexture(String string) {
        if (string == null) {
            return EMPTY_TEXTURE;
        }
        String[] stringArray = string.split(":");
        Material material = MaterialCompat.getMaterialOrNull(stringArray[0]);
        if (material == null) {
            Log.w("Unknown material: {0}", stringArray[0]);
            return EMPTY_TEXTURE;
        }
        ItemStack itemStack = ItemUtils.toBukkitItemStack(new ItemStack(material));
        if (ItemUtils.isEmpty(itemStack)) {
            return EMPTY_TEXTURE;
        }
        if (stringArray.length > 1) {
            if (material.name().equals("MONSTER_EGG")) {
                return Texture.parseLegacyMonsterEgg(itemStack, stringArray[1]);
            }
            if (material.name().startsWith("LEATHER_")) {
                return Texture.parseLeatherArmor(itemStack, stringArray[1]);
            }
            return Texture.parseItemWithDurability(itemStack, stringArray[1]);
        }
        return new Texture(itemStack);
    }

    private static Texture parseLegacyMonsterEgg(ItemStack itemStack, String string) {
        NbtCompound nbtCompound = NbtFactoryMirror.fromItemCompound(itemStack);
        nbtCompound.put("EntityTag", (NbtBase)NbtFactory.ofCompound((String)"temp").put("id", string));
        return new Texture(itemStack);
    }

    private static Texture parseLeatherArmor(ItemStack itemStack, String string) {
        try {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
            assert (leatherArmorMeta != null);
            leatherArmorMeta.setColor(Color.fromRGB((int)Integer.parseInt(string, 16)));
            itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException runtimeException) {
            Log.w("Can''t parse leather color: {0}", runtimeException.toString());
        }
        return new Texture(itemStack);
    }

    private static Texture parseItemWithDurability(ItemStack itemStack, String string) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        short s = -1;
        if (itemMeta != null) {
            try {
                s = Short.parseShort(string);
                ((Damageable)itemMeta).setDamage((int)s);
            }
            catch (NumberFormatException numberFormatException) {
                Log.w("Can''t parse durability. Specify a number instead of \"{0}\"", string);
            }
            itemMeta.addItemFlags(ItemFlag.values());
            if (ItemUtils.isItemHasDurability(itemStack)) {
                itemMeta.setUnbreakable(true);
            }
            itemStack.setItemMeta(itemMeta);
        }
        return new Texture(itemStack, s);
    }
}

