/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.item;

import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.utils.Utils;

public class Modifier {
    public static final Modifier EMPTY = new Modifier();
    private final double minBonus;
    private final double maxBonus;
    private final double minMultiplier;
    private final double maxMultiplier;

    private Modifier() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    Modifier(double d, double d2, double d3, double d4) {
        if (d > d2) {
            d += d2;
            d2 = d - d2;
            d -= d2;
        }
        this.minBonus = d;
        this.maxBonus = d2;
        if (d3 <= 0.0) {
            d3 = 0.1;
        }
        if (d4 <= 0.0) {
            d4 = 0.1;
        }
        if (d3 > d4) {
            d3 += d4;
            d4 = d3 - d4;
            d3 -= d4;
        }
        this.minMultiplier = Utils.round(d3, 3);
        this.maxMultiplier = Utils.round(d4, 3);
    }

    private double getMinBonus() {
        return this.minBonus;
    }

    private double getMaxBonus() {
        return this.maxBonus;
    }

    private double getMinMultiplier() {
        return this.minMultiplier;
    }

    private double getMaxMultiplier() {
        return this.maxMultiplier;
    }

    public double getBonus() {
        return Utils.round(this.minBonus + (this.maxBonus - this.minBonus) * Math.random(), 1);
    }

    public double getMultiplier() {
        return Utils.round(this.minMultiplier + (this.maxMultiplier - this.minMultiplier) * Math.random(), 1);
    }

    public String toString() {
        double d;
        double d2;
        if (this.equals(EMPTY)) {
            return RPGInventory.getLanguage().getMessage("stat.message.no_bonus");
        }
        String string = "";
        if (this.minBonus != 0.0 && this.maxBonus != 0.0) {
            d2 = this.minBonus;
            d = this.maxBonus;
            if ((d <= 0.0 || d2 >= 0.0) && Math.abs(d2) > Math.abs(d)) {
                d2 += d;
                d = d2 - d;
                d2 -= d;
            }
            if (d2 >= 0.0) {
                string = string + "+";
            }
            string = string + d2;
            if (d2 != d) {
                string = string + "-" + (d2 * d >= 0.0 ? Double.valueOf(Math.abs(d)) : "(+" + d + ")");
            }
        }
        if (this.minMultiplier != 1.0 && this.maxMultiplier != 1.0) {
            d2 = Utils.round(this.minMultiplier * 100.0 - 100.0, 1);
            d = Utils.round(this.maxMultiplier * 100.0 - 100.0, 1);
            if ((d <= 0.0 || d2 >= 0.0) && Math.abs(d2) > Math.abs(d)) {
                d2 += d;
                d = d2 - d;
                d2 -= d;
            }
            if (d2 >= 0.0) {
                string = string + "+";
            }
            string = string + d2;
            if (d2 != d) {
                string = string + "-" + (d2 * d >= 0.0 ? Double.valueOf(Math.abs(d)) : "(+" + d + ")");
            }
            string = string + "%";
        }
        return string;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Modifier)) {
            return false;
        }
        Modifier modifier = (Modifier)object;
        return modifier.getMinBonus() == this.minBonus && modifier.getMinMultiplier() == this.minMultiplier && modifier.getMaxBonus() == this.maxBonus && modifier.getMaxMultiplier() == this.maxMultiplier;
    }
}

