/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.item;

import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class ItemStat {
    private final StatType type;
    @NotNull
    private final OperationType operationType;
    private final boolean percentage;
    private final double minValue;
    private final double maxValue;

    ItemStat(StatType statType, String string) {
        this.type = statType;
        this.operationType = OperationType.valueOf(string.charAt(0));
        this.percentage = this.type.isOnlyPercentage() || string.endsWith("%");
        string = string.substring(1).replaceAll("%", "");
        if (string.contains("-")) {
            this.minValue = Double.parseDouble(string.split("-")[0]);
            this.maxValue = Double.parseDouble(string.split("-")[1]);
        } else {
            this.minValue = Double.parseDouble(string);
            this.maxValue = -1.0;
        }
    }

    @NotNull
    String getStringValue() {
        String string = this.operationType.getOperation() + StringUtils.doubleToString(this.minValue);
        if (this.maxValue != -1.0) {
            string = string + "-" + StringUtils.doubleToString(this.maxValue);
        }
        if (this.percentage) {
            string = string + "%";
        }
        return string;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.isRanged() ? this.maxValue : this.minValue;
    }

    private boolean isRanged() {
        return this.maxValue != -1.0;
    }

    public double getValue() {
        double d = this.minValue;
        if (this.maxValue != -1.0) {
            d += (this.maxValue - this.minValue) * Math.random();
        }
        return d;
    }

    boolean isPercentage() {
        return this.percentage;
    }

    @NotNull
    OperationType getOperationType() {
        return this.operationType;
    }

    public StatType getType() {
        return this.type;
    }

    public static enum StatType {
        DAMAGE,
        BOW_DAMAGE,
        HAND_DAMAGE,
        ARMOR,
        JUMP,
        CRIT_CHANCE(true),
        CRIT_DAMAGE(true),
        SPEED(true);

        private final boolean onlyPercentage;

        private StatType() {
            this(false);
        }

        private StatType(boolean bl) {
            this.onlyPercentage = bl;
        }

        public boolean isOnlyPercentage() {
            return this.onlyPercentage;
        }
    }

    static enum OperationType {
        PLUS('+'),
        MINUS('-');

        private final char operation;

        private OperationType(char c) {
            this.operation = c;
        }

        @NotNull
        public static OperationType valueOf(char c) {
            for (OperationType operationType : OperationType.values()) {
                if (operationType.getOperation() != c) continue;
                return operationType;
            }
            return PLUS;
        }

        public char getOperation() {
            return this.operation;
        }
    }
}

