/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.item;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.event.listener.ItemListener;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.item.ClassedItem;
import ru.endlesscode.rpginventory.item.CustomItem;
import ru.endlesscode.rpginventory.item.ItemStat;
import ru.endlesscode.rpginventory.item.Modifier;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.misc.FileLanguage;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.PetType;
import ru.endlesscode.rpginventory.utils.InventoryUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class ItemManager {
    private static final String CONFIG_NAME = "items.yml";
    private static final Map<String, CustomItem> CUSTOM_ITEMS = new HashMap<String, CustomItem>();
    private static final List<String> LORE_PATTERN = Config.getConfig().getStringList("items.lore-pattern");
    private static final String LORE_SEPARATOR = Config.getConfig().getString("items.separator");

    private ItemManager() {
    }

    public static boolean init(@NotNull RPGInventory rPGInventory) {
        try {
            YamlConfiguration yamlConfiguration;
            ConfigurationSection configurationSection;
            Path path = RPGInventory.getInstance().getDataPath().resolve(CONFIG_NAME);
            if (Files.notExists(path, new LinkOption[0])) {
                RPGInventory.getInstance().saveResource(CONFIG_NAME, false);
            }
            if ((configurationSection = (yamlConfiguration = YamlConfiguration.loadConfiguration((File)path.toFile())).getConfigurationSection("items")) == null) {
                Log.s("Section ''items'' not found in {0}", CONFIG_NAME);
                return false;
            }
            CUSTOM_ITEMS.clear();
            for (String string : configurationSection.getKeys(false)) {
                ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
                if (configurationSection2 == null) continue;
                ItemManager.tryToAddItem(string, configurationSection2);
            }
            if (CUSTOM_ITEMS.isEmpty()) {
                Log.i("No one configured item found", new Object[0]);
                return false;
            }
            Log.i("{0} item(s) has been loaded", CUSTOM_ITEMS.size());
            rPGInventory.getServer().getPluginManager().registerEvents((Listener)new ItemListener(), (Plugin)rPGInventory);
            return true;
        }
        catch (Exception exception) {
            rPGInventory.getReporter().report("Error on InventoryManager initialization", exception);
            return false;
        }
    }

    private static void tryToAddItem(String string, @NotNull ConfigurationSection configurationSection) {
        try {
            Texture texture = Texture.parseTexture(configurationSection.getString("texture"));
            if (texture.isEmpty()) {
                Log.s("Item ''{0}'' has not been added because its texture is not valid.", string);
                return;
            }
            CustomItem customItem = new CustomItem(string, texture, configurationSection);
            CUSTOM_ITEMS.put(string, customItem);
        }
        catch (Exception exception) {
            Log.s("Item ''{0}'' can''t be added: {1}", string, exception.toString());
            Log.d(exception);
        }
    }

    public static Modifier getModifier(Player player, ItemStat.StatType statType) {
        return ItemManager.getModifier(player, statType, false);
    }

    private static Modifier getModifier(Player player, ItemStat.StatType statType, boolean bl) {
        List<ItemStack> list = InventoryUtils.collectEffectiveItems(player, bl);
        double d = 0.0;
        double d2 = 0.0;
        float f = 1.0f;
        float f2 = 1.0f;
        for (ItemStack itemStack : list) {
            int n;
            ItemStat itemStat;
            CustomItem customItem;
            if (!CustomItem.isCustomItem(itemStack) || (customItem = ItemManager.getCustomItem(itemStack)) == null || (itemStat = customItem.getStat(statType)) == null) continue;
            int n2 = n = itemStat.getOperationType() == ItemStat.OperationType.MINUS ? -1 : 1;
            if (itemStat.isPercentage()) {
                f = (float)((double)f + (double)n * itemStat.getMinValue() / 100.0);
                f2 = (float)((double)f2 + (double)n * itemStat.getMaxValue() / 100.0);
                continue;
            }
            d += (double)n * itemStat.getMinValue();
            d2 += (double)n * itemStat.getMaxValue();
        }
        return new Modifier(d, d2, f, f2);
    }

    @NotNull
    public static List<String> getItemList() {
        return new ArrayList<String>(CUSTOM_ITEMS.keySet());
    }

    @NotNull
    public static ItemStack getItem(String string) {
        CustomItem customItem = CUSTOM_ITEMS.get(string);
        return customItem == null ? new ItemStack(Material.AIR) : customItem.getItemStack();
    }

    @Nullable
    public static CustomItem getCustomItem(@Nullable ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        String string = ItemUtils.getTag(itemStack, "rpginv.id");
        if (string.isEmpty()) {
            return null;
        }
        return CUSTOM_ITEMS.get(string);
    }

    public static boolean allowedForPlayer(Player player, ItemStack itemStack, boolean bl) {
        ClassedItem classedItem;
        if (CustomItem.isCustomItem(itemStack)) {
            classedItem = ItemManager.getCustomItem(itemStack);
        } else if (PetType.isPetItem(itemStack)) {
            classedItem = PetManager.getPetFromItem(itemStack);
        } else {
            return true;
        }
        if (classedItem == null) {
            return true;
        }
        if (!PlayerUtils.checkLevel(player, classedItem.getLevel())) {
            if (bl) {
                PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.item.level", classedItem.getLevel()));
            }
            return false;
        }
        if (classedItem.getClasses() == null || PlayerUtils.checkClass(player, classedItem.getClasses())) {
            return true;
        }
        if (bl) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.item.class", classedItem.getClassesString()));
        }
        return false;
    }

    public static void updateStats(Player player) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        InventoryManager.get((OfflinePlayer)player).updateStatsLater();
    }

    @NotNull
    static List<String> buildLore(@NotNull CustomItem customItem) {
        FileLanguage fileLanguage = RPGInventory.getLanguage();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        Iterator<String> iterator2 = LORE_PATTERN.iterator();
        block20: while (iterator2.hasNext()) {
            String string;
            switch (string = iterator2.next()) {
                case "_UNBREAKABLE_": {
                    if (!customItem.isUnbreakable()) continue block20;
                    arrayList.add(fileLanguage.getMessage("item.unbreakable"));
                    bl = false;
                    break;
                }
                case "_DROP_": {
                    if (customItem.isDrop()) continue block20;
                    arrayList.add(fileLanguage.getMessage("item.nodrop"));
                    bl = false;
                    break;
                }
                case "_SEPARATOR_": {
                    if (bl) continue block20;
                    arrayList.add(LORE_SEPARATOR);
                    bl = true;
                    break;
                }
                case "_LEVEL_": {
                    if (customItem.getLevel() == -1) continue block20;
                    arrayList.add(fileLanguage.getMessage("item.level", customItem.getLevel()));
                    bl = false;
                    break;
                }
                case "_CLASS_": {
                    if (customItem.getClasses() == null) continue block20;
                    arrayList.add(fileLanguage.getMessage("item.class", customItem.getClassesString()));
                    bl = false;
                    break;
                }
                case "_LORE_": {
                    if (customItem.getLore() == null) continue block20;
                    arrayList.addAll(customItem.getLore());
                    bl = false;
                    break;
                }
                case "_SKILLS_": {
                    if (customItem.hasLeftClickCaption()) {
                        arrayList.add(fileLanguage.getMessage("item.left-click", customItem.getLeftClickCaption()));
                        bl = false;
                    }
                    if (!customItem.hasRightClickCaption()) continue block20;
                    arrayList.add(fileLanguage.getMessage("item.right-click", customItem.getRightClickCaption()));
                    bl = false;
                    break;
                }
                case "_STATS_": {
                    if (customItem.isStatsHidden()) {
                        arrayList.add(fileLanguage.getMessage("item.hide"));
                        bl = false;
                        break;
                    }
                    for (ItemStat itemStat : customItem.getStats()) {
                        arrayList.add(fileLanguage.getMessage("stat." + itemStat.getType().name().toLowerCase(), itemStat.getStringValue()));
                        bl = false;
                    }
                    continue block20;
                }
                default: {
                    arrayList.add(StringUtils.coloredLine(string));
                }
            }
        }
        if (bl) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (((String)arrayList.get(0)).equals(LORE_SEPARATOR)) {
            arrayList.remove(0);
        }
        return arrayList;
    }
}

