/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.item;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.item.ClassedItem;
import ru.endlesscode.rpginventory.item.ItemAction;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.item.ItemStat;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.SafeEnums;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class CustomItem
extends ClassedItem {
    @NotNull
    private final String name;
    private final List<ItemStat> stats = new ArrayList<ItemStat>();
    @Nullable
    private final List<String> lore;
    @Nullable
    private final List<String> permissions;
    private final boolean drop;
    private final boolean unbreakable;
    private final boolean statsHidden;
    @Nullable
    private final ItemAction rightClickAction;
    @Nullable
    private final ItemAction leftClickAction;
    private ItemStack customItem;

    CustomItem(String string, Texture texture, @NotNull ConfigurationSection configurationSection) {
        super(texture, configurationSection);
        Rarity rarity = SafeEnums.valueOfOrDefault(Rarity.class, configurationSection.getString("rarity"), Rarity.COMMON);
        this.name = StringUtils.coloredLine(rarity.getColor() + configurationSection.getString("name"));
        if (configurationSection.contains("stats")) {
            for (String string2 : configurationSection.getStringList("stats")) {
                String[] stringArray = string2.split(" ");
                ItemStat.StatType statType = SafeEnums.valueOf(ItemStat.StatType.class, stringArray[0], "stat type");
                if (statType == null) continue;
                this.stats.add(new ItemStat(statType, stringArray[1]));
            }
        }
        this.lore = configurationSection.contains("lore") ? StringUtils.coloredLines(configurationSection.getStringList("lore")) : null;
        this.leftClickAction = configurationSection.contains("abilities.left-click.command") ? new ItemAction(configurationSection.getConfigurationSection("abilities.left-click")) : null;
        this.rightClickAction = configurationSection.contains("abilities.right-click.command") ? new ItemAction(configurationSection.getConfigurationSection("abilities.right-click")) : null;
        this.permissions = configurationSection.contains("abilities.permissions") ? configurationSection.getStringList("abilities.permissions") : null;
        this.drop = configurationSection.getBoolean("drop", true);
        this.unbreakable = configurationSection.getBoolean("unbreakable", false);
        this.statsHidden = configurationSection.getBoolean("hide-stats", false);
        this.createItem(string);
    }

    @Contract(value="null -> false")
    public static boolean isCustomItem(@Nullable ItemStack itemStack) {
        return ItemUtils.isNotEmpty(itemStack) && ItemUtils.hasTag(itemStack, "rpginv.id");
    }

    public void onEquip(Player player) {
        if (this.permissions == null) {
            return;
        }
        InventoryManager.get((OfflinePlayer)player).addPermissions(this.permissions);
    }

    public void onRightClick(Player player) {
        if (this.rightClickAction != null) {
            this.rightClickAction.doAction(player);
        }
    }

    public void onLeftClick(Player player) {
        if (this.leftClickAction != null) {
            this.leftClickAction.doAction(player);
        }
    }

    private void createItem(String string) {
        ItemStack itemStack = this.texture.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(this.name);
            itemMeta.setLore(ItemManager.buildLore(this));
            if (this.unbreakable) {
                itemMeta.setUnbreakable(true);
            }
            itemStack.setItemMeta(itemMeta);
        }
        this.customItem = ItemUtils.setTag(itemStack, "rpginv.id", string);
    }

    ItemStack getItemStack() {
        return this.customItem;
    }

    @Nullable
    ItemStat getStat(ItemStat.StatType statType) {
        for (ItemStat itemStat : this.stats) {
            if (itemStat.getType() != statType) continue;
            return itemStat;
        }
        return null;
    }

    public boolean isDrop() {
        return this.drop;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore;
    }

    boolean hasLeftClickCaption() {
        return this.leftClickAction != null && this.leftClickAction.getCaption() != null;
    }

    boolean hasRightClickCaption() {
        return this.rightClickAction != null && this.rightClickAction.getCaption() != null;
    }

    @NotNull
    String getLeftClickCaption() {
        return this.leftClickAction == null ? "" : this.leftClickAction.getCaption();
    }

    @NotNull
    String getRightClickCaption() {
        return this.rightClickAction == null ? "" : this.rightClickAction.getCaption();
    }

    @NotNull
    List<ItemStat> getStats() {
        return this.stats;
    }

    boolean isStatsHidden() {
        return this.statsHidden;
    }

    boolean isUnbreakable() {
        return this.unbreakable;
    }

    private static enum Rarity {
        COMMON('7'),
        UNCOMMON('6'),
        RARE('9'),
        MYTHICAL('5'),
        LEGENDARY('d');

        private final char color;

        private Rarity(char c) {
            this.color = c;
        }

        @Contract(pure=true)
        public String getColor() {
            return "&" + this.color;
        }
    }
}

