/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.item;

import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.item.TexturedItem;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class ClassedItem
extends TexturedItem {
    private final int level;
    @Nullable
    private final List<String> classes;

    protected ClassedItem(Texture texture, ConfigurationSection configurationSection) {
        super(texture);
        this.level = configurationSection.getInt("level", -1);
        this.classes = configurationSection.contains("classes") ? configurationSection.getStringList("classes") : null;
    }

    public int getLevel() {
        return this.level;
    }

    @Nullable
    protected List<String> getClasses() {
        return this.classes;
    }

    @NotNull
    protected String getClassesString() {
        if (this.classes == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.classes) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

