/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.slot;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.inventory.InventoryType;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.slot.ActionSlot;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.SafeEnums;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class SlotManager {
    private static final String CONFIG_NAME = "slots.yml";
    @Nullable
    private static SlotManager slotManager = null;
    private final List<Slot> slots = new ArrayList<Slot>();
    @NotNull
    private final Path slotsFile = RPGInventory.getInstance().getDataPath().resolve("slots.yml");
    @NotNull
    private final FileConfiguration slotsConfig;

    private SlotManager() {
        if (Files.notExists(this.slotsFile, new LinkOption[0])) {
            RPGInventory.getInstance().saveResource(CONFIG_NAME, false);
        }
        this.slotsConfig = YamlConfiguration.loadConfiguration((File)this.slotsFile.toFile());
        @Nullable ConfigurationSection configurationSection = this.slotsConfig.getConfigurationSection("slots");
        if (configurationSection == null) {
            Log.s("Section ''slots'' not found in {0}", CONFIG_NAME);
            return;
        }
        for (String string : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            assert (configurationSection2 != null);
            Slot.SlotType slotType = SafeEnums.valueOfOrDefault(Slot.SlotType.class, configurationSection2.getString("type"), Slot.SlotType.GENERIC, "slot type");
            Slot slot = slotType == Slot.SlotType.ACTION ? new ActionSlot(string, configurationSection2) : new Slot(string, slotType, configurationSection2);
            if (this.validateSlot(slot)) {
                this.slots.add(slot);
                continue;
            }
            Log.w("Slot \"{0}\" was not been added.", slot.getName());
        }
    }

    public static boolean init() {
        try {
            slotManager = new SlotManager();
        }
        catch (Exception exception) {
            Log.w(exception, "Failed to initialize SlotManager", new Object[0]);
            return false;
        }
        return true;
    }

    @NotNull
    public static SlotManager instance() {
        return Objects.requireNonNull(slotManager, "Plugin is not initialized yet");
    }

    private boolean validateSlot(Slot slot) {
        if (slot.getSlotType().isReadItemList() && slot.itemListIsEmpty()) {
            Log.w("Slot with type {0} must contains list of allowed items", new Object[]{slot.getSlotType()});
        }
        if (!slot.getSlotType().isAllowMultiSlots() && slot.getSlotIds().size() > 1) {
            Log.w("Slot with type {0} can not contain more than one slotId", new Object[]{slot.getSlotType()});
            return false;
        }
        for (Slot slot2 : this.slots) {
            int n;
            int n22;
            for (int n22 : slot.getSlotIds()) {
                if (!slot2.getSlotIds().contains(n22)) continue;
                Log.w("Slot {0} is occupied by {1}", n22, slot2.getName());
                return false;
            }
            if (slot.isQuick() && slot2.isQuick() && (n = slot.getQuickSlot()) == (n22 = slot2.getQuickSlot())) {
                Log.w("Quickbar slot {0} is occupied by {1}", n, slot2.getName());
                return false;
            }
            if (!slot.getSlotType().isUnique() || slot.getSlotType() != slot2.getSlotType()) continue;
            Log.w("You can not create more then one slot with type {0}!", new Object[]{slot.getSlotType()});
            return false;
        }
        return true;
    }

    @Nullable
    public Slot getSlot(String string) {
        for (Slot slot : this.slots) {
            if (!slot.getName().equalsIgnoreCase(string)) continue;
            return slot;
        }
        return null;
    }

    @Nullable
    public Slot getSlot(int n, InventoryType.SlotType slotType) {
        for (Slot slot : this.slots) {
            if (!(slotType == InventoryType.SlotType.QUICKBAR ? (slot.isQuick() || slot.getSlotType() == Slot.SlotType.SHIELD) && slot.getQuickSlot() == n : slot.containsSlot(n))) continue;
            return slot;
        }
        return null;
    }

    @NotNull
    public List<Slot> getQuickSlots() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Slot slot : this.slots) {
            if (!slot.isQuick()) continue;
            arrayList.add(slot);
        }
        return arrayList;
    }

    @NotNull
    public List<Slot> getPassiveSlots() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Slot slot : this.slots) {
            Slot.SlotType slotType = slot.getSlotType();
            if (slotType != Slot.SlotType.PASSIVE && slotType != Slot.SlotType.BACKPACK && slotType != Slot.SlotType.ELYTRA) continue;
            arrayList.add(slot);
        }
        return arrayList;
    }

    @NotNull
    public List<Slot> getActiveSlots() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Slot slot : this.slots) {
            if (slot.getSlotType() != Slot.SlotType.ACTIVE) continue;
            arrayList.add(slot);
        }
        return arrayList;
    }

    @NotNull
    public List<Slot> getArmorSlots() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>(4);
        for (Slot slot : this.slots) {
            if (slot.getSlotType() != Slot.SlotType.ARMOR) continue;
            arrayList.add(slot);
        }
        return arrayList;
    }

    @NotNull
    public List<Slot> getInfoSlots() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Slot slot : this.slots) {
            if (slot.getSlotType() != Slot.SlotType.INFO) continue;
            arrayList.add(slot);
        }
        return arrayList;
    }

    @NotNull
    public List<Slot> getSlots() {
        return this.slots;
    }

    @Nullable
    public Slot getPetSlot() {
        for (Slot slot : this.slots) {
            if (slot.getSlotType() != Slot.SlotType.PET) continue;
            return slot;
        }
        return null;
    }

    @Nullable
    public Slot getShieldSlot() {
        for (Slot slot : this.slots) {
            if (slot.getSlotType() != Slot.SlotType.SHIELD) continue;
            return slot;
        }
        return null;
    }

    @Nullable
    public Slot getBackpackSlot() {
        for (Slot slot : this.slots) {
            if (slot.getSlotType() != Slot.SlotType.BACKPACK) continue;
            return slot;
        }
        return null;
    }

    @Nullable
    public Slot getElytraSlot() {
        for (Slot slot : this.slots) {
            if (slot.getSlotType() != Slot.SlotType.ELYTRA) continue;
            return slot;
        }
        return null;
    }

    public void saveDefaults() {
        try {
            this.slotsConfig.save(this.slotsFile.toFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

