/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.slot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.utils.InventoryUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class Slot {
    public static final int SHIELD_RAW_SLOT_ID = 45;
    private static final int SHIELD_SLOT_ID = 40;
    private final String name;
    @NotNull
    private final SlotType slotType;
    private final List<String> allowed = new ArrayList<String>();
    private final List<String> denied = new ArrayList<String>();
    @NotNull
    private final List<Integer> slotIds;
    @NotNull
    private final ItemStack cup;
    private final int requiredLevel;
    private final int cost;
    private final int quickSlot;
    private final boolean drop;

    public Slot(String string, @NotNull SlotType slotType, @NotNull ConfigurationSection configurationSection) {
        ItemMeta itemMeta;
        String string2;
        Object object;
        int n;
        this.name = string;
        this.slotType = slotType;
        List<Integer> list = configurationSection.getIntegerList("slot");
        this.slotIds = list.isEmpty() ? Collections.singletonList(configurationSection.getInt("slot")) : list;
        this.requiredLevel = configurationSection.getInt("cost.required-level", 0);
        this.cost = configurationSection.getInt("cost.money", 0);
        this.drop = configurationSection.getBoolean("drop", true);
        int n2 = n = configurationSection.contains("quickbar") ? InventoryUtils.getQuickSlot(configurationSection.getInt("quickbar")) : -1;
        if (slotType == SlotType.SHIELD) {
            n = 40;
        } else if (slotType != SlotType.ACTIVE && n == -1 || !slotType.isAllowQuick() || this.slotIds.size() > 1) {
            if (configurationSection.contains("quickbar")) {
                Log.w("Option \"quickbar\" is ignored for slot \"{0}\"!", string);
            }
            n = -1;
        }
        this.quickSlot = n;
        if (slotType.isReadItemList()) {
            object = configurationSection.getStringList("items").iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                if (string2.startsWith("-")) {
                    this.denied.add(string2.substring(1));
                    continue;
                }
                this.allowed.add(string2);
            }
        } else {
            if (configurationSection.contains("items")) {
                Log.w("Option \"items\" is ignored for slot \"{0}\"!", string);
            }
            if (slotType == SlotType.ELYTRA) {
                this.allowed.add("ELYTRA");
            }
        }
        if ((itemMeta = (string2 = ((Texture)(object = Texture.parseTexture(configurationSection.getString("holder.item")))).getItemStack()).getItemMeta()) != null) {
            itemMeta.setDisplayName(configurationSection.contains("holder.name") ? StringUtils.coloredLine(configurationSection.getString("holder.name")) : "[Holder name missing]");
            itemMeta.setLore(configurationSection.contains("holder.lore") ? StringUtils.coloredLines(configurationSection.getStringList("holder.lore")) : Collections.singletonList("[Holder lore missing]"));
            string2.setItemMeta(itemMeta);
        }
        this.cup = string2;
    }

    private static boolean searchItem(List<String> list, @NotNull ItemStack itemStack) {
        for (String string : list) {
            String[] stringArray = string.split(":");
            if (string.equals("ALL")) {
                return true;
            }
            if (!itemStack.getType().name().equals(stringArray[0])) continue;
            if (stringArray.length > 1) {
                String[] stringArray2 = stringArray[1].split("-");
                short s = ItemUtils.getDamage(itemStack);
                if (stringArray2.length == 1 && s != Integer.parseInt(stringArray[1])) continue;
                if (stringArray2.length == 2) {
                    int n;
                    int n2 = Integer.parseInt(stringArray2[0]);
                    if (n2 > (n = Integer.parseInt(stringArray2[1]))) {
                        n2 *= n;
                        n = n2 / n;
                        n2 /= n;
                    }
                    if (s < n2 || s > n) continue;
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack getCup() {
        return this.cup.clone();
    }

    public boolean isCup(@Nullable ItemStack itemStack) {
        return this.cup.equals((Object)itemStack);
    }

    boolean containsSlot(int n) {
        return this.slotIds.contains(n);
    }

    public boolean isValidItem(@Nullable ItemStack itemStack) {
        return ItemUtils.isNotEmpty(itemStack) && !this.isDenied(itemStack) && this.isAllowed(itemStack);
    }

    public boolean isFree() {
        return this.cost == 0;
    }

    boolean itemListIsEmpty() {
        return this.allowed.isEmpty() && this.denied.isEmpty();
    }

    private boolean isDenied(@NotNull ItemStack itemStack) {
        return Slot.searchItem(this.denied, itemStack);
    }

    private boolean isAllowed(@NotNull ItemStack itemStack) {
        return Slot.searchItem(this.allowed, itemStack);
    }

    @NotNull
    public SlotType getSlotType() {
        return this.slotType;
    }

    public String getName() {
        return this.name;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public int getSlotId() {
        return this.slotIds.get(0);
    }

    public int getQuickSlot() {
        return this.quickSlot;
    }

    public boolean isQuick() {
        return this.quickSlot != -1 && this.slotType != SlotType.SHIELD;
    }

    @NotNull
    public List<Integer> getSlotIds() {
        return this.slotIds;
    }

    public int getCost() {
        return this.cost;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public static enum SlotType {
        GENERIC(true, true, false, true),
        ACTION(false, true, false, false),
        PET(false, false, true, false),
        ARMOR(false, false, false, true),
        ACTIVE(true, false, false, true),
        BACKPACK(true, false, false, false),
        PASSIVE(true, true, false, true),
        SHIELD(false, false, true, true),
        ELYTRA(false, false, true, false),
        INFO(false, false, false, false);

        private final boolean allowQuick;
        private final boolean allowMultiSlots;
        private final boolean unique;
        private final boolean readItemList;

        private SlotType(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.allowQuick = bl;
            this.allowMultiSlots = bl2;
            this.unique = bl3;
            this.readItemList = bl4;
        }

        public boolean isAllowQuick() {
            return this.allowQuick;
        }

        public boolean isAllowMultiSlots() {
            return this.allowMultiSlots;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public boolean isReadItemList() {
            return this.readItemList;
        }
    }
}

