/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.slot;

import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.utils.SafeEnums;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class ActionSlot
extends Slot {
    private final ActionType actionType;
    private final String command;
    private final boolean isGui;

    ActionSlot(String string, @NotNull ConfigurationSection configurationSection) {
        super(string, Slot.SlotType.ACTION, configurationSection);
        this.actionType = SafeEnums.valueOf(ActionType.class, configurationSection.getString("action"), "action type");
        this.command = configurationSection.getString("command");
        this.isGui = configurationSection.getBoolean("gui", false);
    }

    public void preformAction(@NotNull Player player) {
        if (this.isGui) {
            player.closeInventory();
        }
        if (this.actionType == ActionType.WORKBENCH) {
            InventoryManager.get((OfflinePlayer)player).openWorkbench();
        } else if (this.actionType == ActionType.ENDERCHEST) {
            player.openInventory(player.getEnderChest());
        } else if (this.actionType == ActionType.COMMAND && this.command != null) {
            player.performCommand(this.command);
        }
    }

    private static enum ActionType {
        WORKBENCH,
        ENDERCHEST,
        COMMAND;

    }
}

